/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.Locale;
import org.fenixedu.academic.domain.curricularPeriod.CurricularPeriod;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public class CurricularPeriodLabelFormatter {
    public static String getFullLabelI18N(CurricularPeriod curricularPeriod, boolean abbreviated, Locale locale) {
        StringBuilder result = new StringBuilder();
        while (curricularPeriod.getParent() != null) {
            CurricularPeriodLabelFormatter.buildLabel(curricularPeriod, result, abbreviated, locale);
            if ((curricularPeriod = curricularPeriod.getParent()).getParent() == null) continue;
            result.insert(0, ", ");
        }
        return result.toString();
    }

    public static String getLabel(CurricularPeriod curricularPeriod, boolean abbreviated) {
        StringBuilder result = new StringBuilder();
        CurricularPeriodLabelFormatter.buildLabel(curricularPeriod, result, abbreviated, I18N.getLocale());
        return result.toString();
    }

    public static String getFullLabel(CurricularPeriod curricularPeriod, boolean abbreviated) {
        return CurricularPeriodLabelFormatter.getFullLabelI18N(curricularPeriod, abbreviated, I18N.getLocale());
    }

    private static void buildLabel(CurricularPeriod curricularPeriod, StringBuilder result, boolean abbreviated, Locale locale) {
        result.insert(0, BundleUtil.getString((String)"resources.EnumerationResources", (String)(abbreviated ? curricularPeriod.getAcademicPeriod().getAbbreviatedName() : curricularPeriod.getAcademicPeriod().getName()), (String[])new String[0]));
        result.insert(0, " ");
        result.insert(0, curricularPeriod.getChildOrder());
    }
}

