/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Project;
import org.fenixedu.academic.domain.ProjectSubmission;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.projectSubmission.CreateProjectSubmissionBean;
import org.fenixedu.academic.dto.student.ManageStudentStatuteBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.projectSubmission.CreateProjectSubmission;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=StudentApplication.StudentSubmitApp.class, path="projects", titleKey="projects")
@Mapping(module="student", path="/projectSubmission")
@Forwards(value={@Forward(name="viewProjectSubmissions", path="/student/projectSubmissions/viewProjectSubmissions.jsp"), @Forward(name="viewProjectsWithOnlineSubmission", path="/student/projectSubmissions/viewProjectsWithOnlineSubmission.jsp"), @Forward(name="submitProject", path="/student/projectSubmissions/submitProject.jsp")})
public class ProjectSubmissionDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward viewProjectsWithOnlineSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        Student student = ProjectSubmissionDispatchAction.getUserView(request).getPerson().getStudent();
        ManageStudentStatuteBean bean = (ManageStudentStatuteBean)this.getRenderedObject("studentBean");
        if (bean == null) {
            bean = new ManageStudentStatuteBean(student);
        }
        request.setAttribute("studentBean", (Object)bean);
        request.setAttribute("attends", student.getAttendsForExecutionPeriod(bean.getExecutionPeriod()));
        return mapping.findForward("viewProjectsWithOnlineSubmission");
    }

    public ActionForward viewProjectSubmissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        Attends attends = this.getAttends(request);
        Project project = this.getProject(request);
        StudentGroup studentGroup = project.getGrouping().getStudentGroupByAttends(attends);
        request.setAttribute("project", (Object)project);
        if (studentGroup != null) {
            List<ProjectSubmission> projectSubmissionsSortedByMostRecent = this.getProjectSubmissionsForStudentGroupSortedByMostRecent(project, studentGroup);
            request.setAttribute("attends", (Object)attends);
            request.setAttribute("projectSubmissions", projectSubmissionsSortedByMostRecent);
        } else {
            request.setAttribute("noStudentGroupForGrouping", (Object)true);
        }
        return mapping.findForward("viewProjectSubmissions");
    }

    public ActionForward viewObservation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        ProjectSubmission submission = this.getProjectSubmission(request);
        if (submission != null && submission.getStudentGroup().isPersonInStudentGroup(this.getLoggedPerson(request))) {
            Attends attends = this.getAttends(request);
            Project project = this.getProject(request);
            StudentGroup studentGroup = project.getGrouping().getStudentGroupByAttends(attends);
            String rowClasses = "";
            for (ProjectSubmission oneSubmission : this.getProjectSubmissionsForStudentGroupSortedByMostRecent(project, studentGroup)) {
                if (oneSubmission.equals((Object)submission)) {
                    rowClasses = rowClasses + "selected,";
                    continue;
                }
                rowClasses = rowClasses + ",";
            }
            request.setAttribute("submission", (Object)submission);
            request.setAttribute("rowClasses", (Object)rowClasses);
        }
        return this.viewProjectSubmissions(mapping, form, request, response);
    }

    private List<ProjectSubmission> getProjectSubmissionsForStudentGroupSortedByMostRecent(Project project, StudentGroup studentGroup) {
        ArrayList<ProjectSubmission> projectSubmissionsSortedByMostRecent = new ArrayList<ProjectSubmission>(project.getProjectSubmissionsByStudentGroup(studentGroup));
        Collections.sort(projectSubmissionsSortedByMostRecent, ProjectSubmission.COMPARATOR_BY_MOST_RECENT_SUBMISSION_DATE);
        return projectSubmissionsSortedByMostRecent;
    }

    public ActionForward prepareProjectSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        Attends attends = this.getAttends(request);
        Project project = this.getProject(request);
        StudentGroup studentGroup = project.getGrouping().getStudentGroupByAttends(attends);
        request.setAttribute("attends", (Object)attends);
        request.setAttribute("project", (Object)this.getProject(request));
        request.setAttribute("studentGroup", (Object)studentGroup);
        request.setAttribute("person", (Object)ProjectSubmissionDispatchAction.getUserView(request).getPerson());
        request.setAttribute("projectSubmission", (Object)new CreateProjectSubmissionBean());
        RenderUtils.invalidateViewState((String)"createProjectSubmission");
        return mapping.findForward("submitProject");
    }

    public ActionForward submitProject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException, IOException {
        IViewState viewState = RenderUtils.getViewState((String)"createProjectSubmission");
        CreateProjectSubmissionBean createProjectSubmissionBean = (CreateProjectSubmissionBean)viewState.getMetaObject().getObject();
        try (InputStream is = createProjectSubmissionBean.getInputStream();){
            if (is == null) {
                this.saveActionMessageOnRequest(request, "error.file.empty", null);
                ActionForward actionForward = this.prepareProjectSubmission(mapping, form, request, response);
                return actionForward;
            }
            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
            try {
                CreateProjectSubmission.run(bytes, createProjectSubmissionBean.getFilename(), createProjectSubmissionBean.getAttends(), createProjectSubmissionBean.getProject(), createProjectSubmissionBean.getStudentGroup(), createProjectSubmissionBean.getPerson());
            }
            catch (DomainException ex) {
                this.saveActionMessageOnRequest(request, ex.getKey(), ex.getArgs());
                ActionForward actionForward = this.prepareProjectSubmission(mapping, form, request, response);
                if (is != null) {
                    if (var8_8 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
                return actionForward;
            }
        }
        return this.viewProjectSubmissions(mapping, form, request, response);
    }

    private void saveActionMessageOnRequest(HttpServletRequest request, String errorKey, String[] args) {
        ActionMessages actionMessages = new ActionMessages();
        actionMessages.add(errorKey, new ActionMessage(errorKey, (Object[])args));
        this.saveMessages(request, actionMessages);
    }

    private ProjectSubmission getProjectSubmission(HttpServletRequest request) {
        return (ProjectSubmission)((Object)this.getDomainObject(request, "projectSubmissionId"));
    }

    private Project getProject(HttpServletRequest request) {
        return (Project)((Object)this.getDomainObject(request, "projectId"));
    }

    private Attends getAttends(HttpServletRequest request) {
        return (Attends)((Object)this.getDomainObject(request, "attendsId"));
    }
}

