/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.LabelValueBean;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.InfoCurricularYear;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoShift;
import org.fenixedu.academic.dto.InfoShiftEditor;
import org.fenixedu.academic.dto.resourceAllocationManager.ContextSelectionBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceMultipleException;
import org.fenixedu.academic.service.services.resourceAllocationManager.CriarTurno;
import org.fenixedu.academic.service.services.resourceAllocationManager.DeleteShift;
import org.fenixedu.academic.service.services.resourceAllocationManager.DeleteShifts;
import org.fenixedu.academic.service.services.resourceAllocationManager.ReadShiftsByExecutionPeriodAndExecutionDegreeAndCurricularYear;
import org.fenixedu.academic.ui.struts.action.exceptions.ExistingActionException;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ExecutionPeriodDA;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ManageShiftDA;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.base.FenixExecutionDegreeAndCurricularYearContextDispatchAction;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.utils.RequestUtils;
import org.fenixedu.academic.ui.struts.action.utils.ContextUtils;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/manageShifts", module="resourceAllocationManager", input="/manageShifts.do?method=listShifts", formBean="createShiftForm", functionality=ExecutionPeriodDA.class)
@Forwards(value={@Forward(name="ShowShiftList", path="/resourceAllocationManager/manageShifts_bd.jsp"), @Forward(name="EditShift", path="/resourceAllocationManager/manageShift.do?method=prepareEditShift")})
@Exceptions(value={@ExceptionHandling(handler=FenixErrorExceptionHandler.class, type=ExistingActionException.class, key="resources.Action.exceptions.ExistingActionException", scope="request")})
public class ManageShiftsDA
extends FenixExecutionDegreeAndCurricularYearContextDispatchAction {
    public ActionForward listShifts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.readAndSetInfoToManageShifts(request);
        return mapping.findForward("ShowShiftList");
    }

    public ActionForward listExecutionCourseCourseLoads(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.readAndSetInfoToManageShifts(request);
        DynaActionForm createShiftForm = (DynaActionForm)form;
        InfoExecutionCourse infoExecutionCourse = RequestUtils.getExecutionCourseBySigla(request, (String)createShiftForm.get("courseInitials"));
        if (infoExecutionCourse != null) {
            ArrayList<LabelValueBean> tiposAula = new ArrayList<LabelValueBean>();
            for (ShiftType shiftType : infoExecutionCourse.getExecutionCourse().getShiftTypes()) {
                tiposAula.add(new LabelValueBean(BundleUtil.getString((String)"resources.EnumerationResources", (String)shiftType.getName(), (String[])new String[0]), shiftType.name()));
            }
            request.setAttribute("tiposAula", tiposAula);
        }
        return mapping.findForward("ShowShiftList");
    }

    public ActionForward createShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm createShiftForm = (DynaActionForm)form;
        InfoShiftEditor infoShift = new InfoShiftEditor();
        infoShift.setAvailabilityFinal(new Integer(0));
        InfoExecutionCourse infoExecutionCourse = RequestUtils.getExecutionCourseBySigla(request, (String)createShiftForm.get("courseInitials"));
        infoShift.setInfoDisciplinaExecucao(infoExecutionCourse);
        infoShift.setInfoLessons(null);
        infoShift.setLotacao((Integer)createShiftForm.get("lotacao"));
        infoShift.setNome((String)createShiftForm.get("nome"));
        String[] selectedShiftTypes = (String[])createShiftForm.get("shiftTiposAula");
        if (selectedShiftTypes.length == 0) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("errors.shift.types.notSelected", new ActionError("errors.shift.types.notSelected"));
            this.saveErrors(request, actionErrors);
            return mapping.getInputForward();
        }
        ArrayList<ShiftType> shiftTypes = new ArrayList<ShiftType>();
        for (String selectedShiftType : selectedShiftTypes) {
            shiftTypes.add(ShiftType.valueOf(selectedShiftType.toString()));
        }
        infoShift.setTipos(shiftTypes);
        InfoShift newInfoShift = CriarTurno.run(infoShift);
        request.setAttribute("shift", (Object)newInfoShift);
        request.setAttribute("execution_course", (Object)infoExecutionCourse);
        return mapping.findForward("EditShift");
    }

    private void readAndSetInfoToManageShifts(HttpServletRequest request) throws FenixServiceException, Exception {
        ContextSelectionBean context = (ContextSelectionBean)request.getAttribute("context_selection_bean");
        List<InfoShift> infoShifts = ReadShiftsByExecutionPeriodAndExecutionDegreeAndCurricularYear.run(context.getAcademicInterval(), new InfoExecutionDegree(context.getExecutionDegree()), new InfoCurricularYear(context.getCurricularYear()));
        Collections.sort(infoShifts, InfoShift.SHIFT_COMPARATOR_BY_TYPE_AND_ORDERED_LESSONS);
        if (infoShifts != null && !infoShifts.isEmpty()) {
            request.setAttribute("shifts", infoShifts);
        }
        ManageShiftDA.getExecutionCourses(request);
    }

    @Mapping(path="/deleteShifts", module="resourceAllocationManager", input="/manageShifts.do?method=listShifts&page=0", formBean="selectMultipleItemsForm", functionality=ExecutionPeriodDA.class)
    public static class DeleteShiftsDA
    extends ManageShiftsDA {
        private String getQueryParam(HttpServletRequest request, String name) {
            return Stream.of(name, (String)request.getAttribute(name)).collect(Collectors.joining("="));
        }

        private ActionForward redirectToShiftsList(HttpServletRequest request) {
            String url = Stream.of("/manageShifts.do?method=listShifts&page=0", this.getQueryParam(request, "academicInterval"), this.getQueryParam(request, "curricular_year_oid"), this.getQueryParam(request, "execution_degree_oid")).collect(Collectors.joining("&"));
            return this.redirect(url, request);
        }

        public ActionForward deleteShift(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
            ContextUtils.setShiftContext(request);
            InfoShift infoShiftToDelete = (InfoShift)request.getAttribute("shift");
            try {
                DeleteShift.run(infoShiftToDelete);
            }
            catch (FenixServiceException exception) {
                ActionErrors actionErrors = new ActionErrors();
                if (exception.getMessage() != null && exception.getMessage().length() > 0) {
                    actionErrors.add("errors.deleteshift", new ActionError(exception.getMessage(), (Object[])exception.getArgs()));
                } else {
                    actionErrors.add("errors.deleteshift", new ActionError("error.deleteShift"));
                }
                this.saveErrors(request, actionErrors);
                return mapping.getInputForward();
            }
            catch (DomainException exception) {
                ActionMessages actionMessages = new ActionMessages();
                actionMessages.add("errors.deleteshift", new ActionMessage(exception.getLocalizedMessage(), false));
                this.saveErrors(request, actionMessages);
                return mapping.getInputForward();
            }
            return this.redirectToShiftsList(request);
        }

        public ActionForward deleteShifts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
            DynaActionForm deleteShiftsForm = (DynaActionForm)form;
            String[] selectedShifts = (String[])deleteShiftsForm.get("selectedItems");
            if (selectedShifts.length == 0) {
                ActionErrors actionErrors = new ActionErrors();
                actionErrors.add("errors.shifts.notSelected", new ActionError("errors.shifts.notSelected"));
                this.saveErrors(request, actionErrors);
                return mapping.getInputForward();
            }
            ArrayList<String> shiftOIDs = new ArrayList<String>();
            for (String selectedShift : selectedShifts) {
                shiftOIDs.add(selectedShift);
            }
            try {
                DeleteShifts.run(shiftOIDs);
            }
            catch (FenixServiceMultipleException e) {
                ActionMessages actionMessages = new ActionMessages();
                for (DomainException domainException : e.getExceptionList()) {
                    actionMessages.add(Integer.toString(((Object)((Object)domainException)).hashCode()), new ActionMessage(domainException.getLocalizedMessage(), false));
                }
                this.saveErrors(request, actionMessages);
                return mapping.getInputForward();
            }
            return this.redirectToShiftsList(request);
        }
    }
}

