/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.residenceManagement;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accounting.ResidenceEvent;
import org.fenixedu.academic.domain.organizationalStructure.ResidenceManagementUnit;
import org.fenixedu.academic.domain.residence.ResidenceMonth;
import org.fenixedu.academic.dto.residenceManagement.ImportResidenceEventBean;
import org.fenixedu.academic.dto.residenceManagement.ResidenceDebtEventBean;
import org.fenixedu.academic.dto.residenceManagement.ResidenceEventBean;
import org.fenixedu.academic.dto.residenceManagement.ResidentListsHolderBean;
import org.fenixedu.academic.service.services.residenceManagement.CreateResidenceEvents;
import org.fenixedu.academic.service.services.residenceManagement.PayResidenceEvent;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.residenceManagement.ResidenceEventManagementDispatchAction;
import org.fenixedu.academic.ui.struts.action.residenceManagement.ResidenceManagementDispatchAction$callable$makePayments;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Mapping(path="/residenceManagement", module="residenceManagement", functionality=ResidenceEventManagementDispatchAction.class)
@Forwards(value={@Forward(name="importData", path="/residenceManagement/importData.jsp"), @Forward(name="yearConfiguration", path="residenceManagement-yearConfiguration"), @Forward(name="editPaymentLimitDay", path="/residenceManagement/editPaymentLimitDay.jsp"), @Forward(name="importCurrentDebt", path="/residenceManagement/importCurrentDebts.jsp"), @Forward(name="editRoomValues", path="/residenceManagement/editRoomValues.jsp"), @Forward(name="missingPayments", path="/residenceManagement/missingPayment.jsp")})
public class ResidenceManagementDispatchAction
extends FenixDispatchAction {
    public static final Advice advice$makePayments = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public ActionForward missingPayments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<ResidenceEvent> results = new ArrayList<ResidenceEvent>();
        for (ResidenceMonth month : rootDomainObject.getResidenceMonths0Set()) {
            for (ResidenceEvent residenceEvent : month.getEventsSet()) {
                if (!residenceEvent.isInDebt()) continue;
                results.add(residenceEvent);
            }
        }
        Collections.sort(results, new Comparator<ResidenceEvent>(){

            @Override
            public int compare(ResidenceEvent o1, ResidenceEvent o2) {
                return o1.getEventStateDate().compareTo((ReadableInstant)o2.getEventStateDate());
            }
        });
        request.setAttribute("list", results);
        return mapping.findForward("missingPayments");
    }

    public ActionForward importCurrentDebts(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ImportResidenceEventBean bean = (ImportResidenceEventBean)this.getRenderedObject("importFile");
        if (bean == null) {
            ResidenceMonth month = this.getResidenceMonth(request);
            bean = month != null ? new ImportResidenceEventBean(month) : new ImportResidenceEventBean();
        } else {
            ArrayList<ResidenceEventBean> sucessful = new ArrayList<ResidenceEventBean>();
            ArrayList<ResidenceEventBean> unsucessful = new ArrayList<ResidenceEventBean>();
            List<ResidenceEventBean> process2 = null;
            try {
                process2 = this.processCurrentDebts(bean);
            }
            catch (InvalidSpreadSheetName exception) {
                this.addActionMessage(request, "label.error.invalid.spreadsheetname", exception.getRequestedSheet());
                request.setAttribute("availableSpreadsheets", (Object)exception.getAvailableSpreadSheets());
                RenderUtils.invalidateViewState();
                request.setAttribute("importFileBean", (Object)bean);
                return mapping.findForward("importCurrentDebt");
            }
            catch (Exception exception) {
                this.addActionMessage(request, "label.error.invalid.table");
                RenderUtils.invalidateViewState();
                request.setAttribute("importFileBean", (Object)bean);
                return mapping.findForward("importCurrentDebt");
            }
            for (ResidenceEventBean eventBean : process2) {
                if (eventBean.getStatus()) {
                    sucessful.add(eventBean);
                    continue;
                }
                unsucessful.add(eventBean);
            }
            ResidentListsHolderBean listHolder = new ResidentListsHolderBean(sucessful, unsucessful);
            request.setAttribute("importList", (Object)listHolder);
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("importFileBean", (Object)bean);
        return mapping.findForward("importCurrentDebt");
    }

    public ActionForward importData(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ImportResidenceEventBean bean = (ImportResidenceEventBean)this.getRenderedObject("importFile");
        if (bean == null) {
            ResidenceMonth month = this.getResidenceMonth(request);
            bean = month != null ? new ImportResidenceEventBean(month) : new ImportResidenceEventBean();
        } else {
            ArrayList<ResidenceEventBean> sucessful = new ArrayList<ResidenceEventBean>();
            ArrayList<ResidenceEventBean> unsucessful = new ArrayList<ResidenceEventBean>();
            List<ResidenceEventBean> process2 = null;
            try {
                process2 = this.process(bean);
            }
            catch (InvalidSpreadSheetName exception) {
                this.addActionMessage(request, "label.error.invalid.spreadsheetname", exception.getRequestedSheet());
                request.setAttribute("availableSpreadsheets", (Object)exception.getAvailableSpreadSheets());
                RenderUtils.invalidateViewState();
                request.setAttribute("importFileBean", (Object)bean);
                return mapping.findForward("importData");
            }
            catch (Exception exception) {
                this.addActionMessage(request, "label.error.invalid.table");
                RenderUtils.invalidateViewState();
                request.setAttribute("importFileBean", (Object)bean);
                return mapping.findForward("importCurrentDebt");
            }
            for (ResidenceEventBean eventBean : process2) {
                if (eventBean.getStatus()) {
                    sucessful.add(eventBean);
                    continue;
                }
                unsucessful.add(eventBean);
            }
            ResidentListsHolderBean listHolder = new ResidentListsHolderBean(sucessful, unsucessful);
            request.setAttribute("importList", (Object)listHolder);
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("importFileBean", (Object)bean);
        return mapping.findForward("importData");
    }

    public ActionForward invalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ImportResidenceEventBean bean = (ImportResidenceEventBean)this.getRenderedObject("importFile");
        request.setAttribute("importFileBean", (Object)bean);
        return mapping.findForward("importData");
    }

    public ActionForward editPaymentLimitDay(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.editResidencePriceTableProperty(mapping, actionForm, request, response, "editPaymentLimitDay");
    }

    public ActionForward editRoomValues(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.editResidencePriceTableProperty(mapping, actionForm, request, response, "editRoomValues");
    }

    private ActionForward editResidencePriceTableProperty(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, String forwardName) throws Exception {
        ResidenceManagementUnit unit = this.getManagementUnit(request);
        ResidenceMonth month = this.getResidenceMonth(request);
        request.setAttribute("residenceMonth", (Object)month);
        request.setAttribute("priceTable", (Object)unit.getResidencePriceTable());
        return mapping.findForward(forwardName);
    }

    private ResidenceManagementUnit getManagementUnit(HttpServletRequest request) {
        return Bennu.getInstance().getResidenceManagementUnit();
    }

    private ResidenceMonth getResidenceMonth(HttpServletRequest request) {
        String oid = request.getParameter("monthOID");
        return oid == null ? null : (ResidenceMonth)FenixFramework.getDomainObject((String)oid);
    }

    public ActionForward generateDebts(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResidentListsHolderBean listHolder = (ResidentListsHolderBean)this.getRenderedObject("importList");
        ImportResidenceEventBean eventBean = (ImportResidenceEventBean)this.getRenderedObject("dateBean");
        try {
            CreateResidenceEvents.run(listHolder.getSuccessfulEvents(), eventBean.getResidenceMonth());
        }
        catch (Exception e) {
            this.addActionMessage(request, e.getMessage());
            return this.importData(mapping, actionForm, request, response);
        }
        request.setAttribute("createdDebts", (Object)true);
        return this.importData(mapping, actionForm, request, response);
    }

    public void makePayments(List<ResidenceEventBean> list, HttpServletRequest httpServletRequest) throws Exception {
        Object object = advice$makePayments.perform((Callable)new ResidenceManagementDispatchAction$callable$makePayments(this, list, httpServletRequest));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$makePayments(ResidenceManagementDispatchAction this_, List events, HttpServletRequest request) throws Exception {
        for (ResidenceEventBean event : events) {
            ResidenceDebtEventBean debtEvent = (ResidenceDebtEventBean)event;
            PayResidenceEvent.run(this_.getLoggedPerson(request).getUser(), debtEvent.getEventObject(), debtEvent.getPaidDateObject());
        }
    }

    public ActionForward generatePayments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResidentListsHolderBean listHolder = (ResidentListsHolderBean)this.getRenderedObject("importList");
        ImportResidenceEventBean eventBean = (ImportResidenceEventBean)this.getRenderedObject("dateBean");
        try {
            this.makePayments(listHolder.getSuccessfulEvents(), request);
        }
        catch (Exception e) {
            this.addActionMessage(request, e.getMessage());
            return this.importData(mapping, actionForm, request, response);
        }
        request.setAttribute("createdDebts", (Object)true);
        return this.importCurrentDebts(mapping, actionForm, request, response);
    }

    private List<ResidenceEventBean> process(ImportResidenceEventBean bean) throws IOException, InvalidSpreadSheetName {
        String room;
        HSSFRow row;
        ArrayList<ResidenceEventBean> beans = new ArrayList<ResidenceEventBean>();
        POIFSFileSystem fs = new POIFSFileSystem(bean.getFile());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            throw new InvalidSpreadSheetName(bean.getSpreadsheetName(), this.getAllSpreadsheets(wb));
        }
        int i = 2;
        while ((row = sheet.getRow(i)) != null && !StringUtils.isEmpty((String)(room = row.getCell((short)0).getStringCellValue()))) {
            String userName = this.getValueFromColumnMayBeNull(row, 1);
            String fiscalNumber = this.getValueFromColumnMayBeNull(row, 2);
            String name = this.getValueFromColumnMayBeNull(row, 3);
            Double roomValue = new Double(row.getCell((short)4).getNumericCellValue());
            beans.add(new ResidenceEventBean(userName, fiscalNumber, name, roomValue, room));
            ++i;
        }
        return beans;
    }

    private List<ResidenceEventBean> processCurrentDebts(ImportResidenceEventBean bean) throws IOException, InvalidSpreadSheetName {
        String room;
        HSSFRow row;
        ArrayList<ResidenceEventBean> beans = new ArrayList<ResidenceEventBean>();
        POIFSFileSystem fs = new POIFSFileSystem(bean.getFile());
        HSSFWorkbook wb = new HSSFWorkbook(fs);
        HSSFSheet sheet = wb.getSheetAt(0);
        if (sheet == null) {
            throw new InvalidSpreadSheetName(bean.getSpreadsheetName(), this.getAllSpreadsheets(wb));
        }
        int i = 2;
        while ((row = sheet.getRow(i)) != null && !StringUtils.isEmpty((String)(room = row.getCell((short)0).getStringCellValue()))) {
            String userName = this.getValueFromColumnMayBeNull(row, 1);
            String fiscalNumber = this.getValueFromColumnMayBeNull(row, 2);
            String name = this.getValueFromColumnMayBeNull(row, 3);
            Double roomValue = new Double(row.getCell((short)4).getNumericCellValue());
            String paidDate = this.getDateFromColumn(row, 5);
            Double roomValuePaid = new Double(row.getCell((short)6).getNumericCellValue());
            ResidenceDebtEventBean residenceDebtEventBean = new ResidenceDebtEventBean(userName, fiscalNumber, name, roomValue, room, paidDate, roomValuePaid);
            residenceDebtEventBean.setMonth(bean.getResidenceMonth());
            beans.add(residenceDebtEventBean);
            ++i;
        }
        return beans;
    }

    private String getValueFromColumnMayBeNull(HSSFRow row, int i) {
        HSSFCell cell = row.getCell((short)i);
        if (cell == null) {
            return "";
        }
        return this.getValueFromColumn(row, i);
    }

    private String[] getAllSpreadsheets(HSSFWorkbook wb) {
        String[] spreadsheets = new String[wb.getNumberOfSheets()];
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            spreadsheets[i] = wb.getSheetName(i);
        }
        return spreadsheets;
    }

    private String getDateFromColumn(HSSFRow row, int i) {
        try {
            return new SimpleDateFormat("dd-MM-yy").format(row.getCell((short)i).getDateCellValue());
        }
        catch (Exception e) {
            return row.getCell((short)i).getStringCellValue();
        }
    }

    private String getValueFromColumn(HSSFRow row, int i) {
        try {
            return new Integer(new Double(row.getCell((short)i).getNumericCellValue()).intValue()).toString();
        }
        catch (NumberFormatException e) {
            return row.getCell((short)i).getStringCellValue();
        }
        catch (IllegalStateException e) {
            return row.getCell((short)i).getStringCellValue();
        }
    }

    private static class InvalidSpreadSheetName
    extends Exception {
        private final String requestedSheet;
        private final String[] availableSpreadSheets;

        public InvalidSpreadSheetName(String requestedSheet, String[] availableSpreadSheets) {
            this.requestedSheet = requestedSheet;
            this.availableSpreadSheets = availableSpreadSheets;
        }

        public String[] getAvailableSpreadSheets() {
            return this.availableSpreadSheets;
        }

        public String getRequestedSheet() {
            return this.requestedSheet;
        }
    }
}

