/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.thesis;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.candidacy.activities.DeleteDocument;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.activities.JuryReporterFeedbackUpload;
import org.fenixedu.academic.domain.phd.thesis.activities.ScheduleThesisMeeting;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.PhdDocumentsZip;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessDA;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public abstract class CommonPhdThesisProcessDA
extends PhdProcessDA {
    protected PhdThesisProcess getProcess(HttpServletRequest request) {
        return (PhdThesisProcess)((Object)super.getProcess(request));
    }

    public ActionForward viewIndividualProgramProcess(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    protected ActionForward viewIndividualProgramProcess(HttpServletRequest request, PhdThesisProcess process2) {
        return this.redirect(String.format("/phdIndividualProgramProcess.do?method=viewProcess&processId=%s", process2.getIndividualProgramProcess().getExternalId()), request);
    }

    public ActionForward prepareJuryReportFeedbackUpload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        bean.addDocument(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.JURY_REPORT_FEEDBACK));
        bean.setJuryElement(this.getProcess(request).getThesisJuryElement(AccessControl.getPerson()));
        request.setAttribute("thesisProcessBean", (Object)bean);
        request.setAttribute("thesisDocuments", this.getProcess(request).getThesisDocumentsToFeedback());
        return mapping.findForward("juryReporterFeedbackUpload");
    }

    public ActionForward juryReportFeedbackUploadInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        request.setAttribute("thesisDocuments", this.getProcess(request).getThesisDocumentsToFeedback());
        return mapping.findForward("juryReporterFeedbackUpload");
    }

    public ActionForward juryReportFeedbackUpload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            IViewState viewState = RenderUtils.getViewState((String)"thesisProcessBean.edit.documents");
            if (!viewState.isValid()) {
                return this.juryReportFeedbackUploadInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request)), JuryReporterFeedbackUpload.class, (Object)this.getThesisProcessBean());
            this.addSuccessMessage(request, "message.thesis.jury.report.feedback.uploaded.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getMessage(), e.getArgs());
            return this.juryReportFeedbackUploadInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, this.getProcess(request));
    }

    public ActionForward downloadThesisDocumentsToFeedback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.writeFile(response, this.getThesisDocumentsToFeedbackFilename(request), PhdDocumentsZip.ZIP_MIME_TYPE, PhdDocumentsZip.zip(this.getProcess(request).getThesisDocumentsToFeedback()));
        return null;
    }

    protected String getThesisDocumentsToFeedbackFilename(HttpServletRequest request) {
        return this.getProcess(request).getProcessNumber().replace("/", "-") + "-Documents.zip";
    }

    protected PhdThesisProcessBean getThesisProcessBean() {
        return (PhdThesisProcessBean)this.getRenderedObject("thesisProcessBean");
    }

    public ActionForward manageThesisDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("manageThesisDocuments");
    }

    public ActionForward downloadThesisDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.writeFile(response, this.getThesisDocumentsFilename(request), PhdDocumentsZip.ZIP_MIME_TYPE, this.createZip(request));
        return null;
    }

    protected String getThesisDocumentsFilename(HttpServletRequest request) {
        PhdIndividualProgramProcess process2 = this.getProcess(request).getIndividualProgramProcess();
        return String.format("%s-%s.zip", process2.getProcessNumber().replace("/", "-"), this.getMessageFromResource("label.phd.manageThesisDocuments", new String[0]).replace(" ", "_"));
    }

    public ActionForward deleteDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.executeActivity(DeleteDocument.class, this.getDomainObject(request, "documentId"), request, mapping, "manageThesisDocuments", "manageThesisDocuments", "message.document.deleted.successfuly", new String[0]);
    }

    public ActionForward prepareScheduleThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcessBean bean = new PhdThesisProcessBean();
        PhdThesisProcess thesisProcess = this.getProcess(request);
        bean.setThesisProcess(thesisProcess);
        this.setDefaultMeetingMailInformation(bean, thesisProcess);
        request.setAttribute("thesisProcessBean", (Object)bean);
        return mapping.findForward("scheduleThesisMeeting");
    }

    private void setDefaultMeetingMailInformation(PhdThesisProcessBean bean, PhdThesisProcess thesisProcess) {
        PhdIndividualProgramProcess process2 = thesisProcess.getIndividualProgramProcess();
        bean.setMailSubject(AlertService.getSubjectPrefixed(process2, "message.phd.thesis.schedule.thesis.meeting.default.subject"));
        bean.setMailBody(AlertService.getBodyText(process2, "message.phd.thesis.schedule.thesis.meeting.default.body"));
    }

    public ActionForward scheduleThesisMeetingInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        return mapping.findForward("scheduleThesisMeeting");
    }

    public ActionForward scheduleThesisMeetingPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("thesisProcessBean", (Object)this.getThesisProcessBean());
        RenderUtils.invalidateViewState();
        return mapping.findForward("scheduleThesisMeeting");
    }

    public ActionForward scheduleThesisMeeting(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdThesisProcess thesisProcess = this.getProcess(request);
        try {
            ExecuteProcessActivity.run((Process)((Object)thesisProcess), ScheduleThesisMeeting.class, (Object)this.getThesisProcessBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.scheduleThesisMeetingInvalid(mapping, actionForm, request, response);
        }
        return this.viewIndividualProgramProcess(request, thesisProcess);
    }
}

