/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.coordinator;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.ui.struts.action.coordinator.SummaryBean;
import org.fenixedu.academic.ui.struts.action.coordinator.thesis.ThesisPresentationState;

public class ThesisSummaryBean
extends SummaryBean {
    private final Map<ThesisPresentationState, Integer> thesisCount = new LinkedHashMap<ThesisPresentationState, Integer>();
    private final Set<ThesisPresentationState> thesisExcludedStates = new HashSet<ThesisPresentationState>();

    public ThesisSummaryBean(ExecutionDegree executionDegree, DegreeCurricularPlan degreeCurricularPlan) {
        super(executionDegree, degreeCurricularPlan);
        this.thesisExcludedStates.add(ThesisPresentationState.UNKNOWN);
        this.initThesis();
    }

    private void initThesis() {
        this.thesisCount.clear();
        for (ThesisPresentationState state : ThesisPresentationState.values()) {
            if (this.thesisExcludedStates.contains((Object)state)) continue;
            this.thesisCount.put(state, 0);
        }
        this.setThesisCount();
    }

    private void setThesisCount() {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan();
        ExecutionYear executionYear = this.getExecutionDegree().getExecutionYear().getNextExecutionYear();
        for (Enrolment enrolment : degreeCurricularPlan.getDissertationEnrolments(executionYear)) {
            ThesisPresentationState state = ThesisPresentationState.getThesisPresentationState(enrolment.getThesis());
            if (this.thesisExcludedStates.contains((Object)state)) continue;
            this.incThesis(state);
        }
    }

    private void incThesis(ThesisPresentationState thesisPresentationState) {
        this.thesisCount.put(thesisPresentationState, this.thesisCount.get((Object)thesisPresentationState) + 1);
    }

    public Map<ThesisPresentationState, Integer> getThesisCount() {
        return this.thesisCount;
    }
}

