/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.lists;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.dto.academicAdministration.SearchStudentsByCurricularCourseParametersBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.commons.spreadsheet.StyledExcelSpreadsheet;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminListingsApp.class, path="students-by-curricular-course", titleKey="link.studentsListByCurricularCourse", accessGroup="academic(STUDENT_LISTINGS)")
@Mapping(path="/studentsListByCurricularCourse", module="academicAdministration")
@Forwards(value={@Forward(name="chooseCurricularCourse", path="/academicAdminOffice/lists/chooseCurricularCourses.jsp"), @Forward(name="studentByCurricularCourse", path="/academicAdminOffice/lists/studentsByCurricularCourses.jsp")})
public class StudentsListByCurricularCourseDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepareByCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        request.setAttribute("searchBean", (Object)this.getOrCreateSearchBean());
        return mapping.findForward("chooseCurricularCourse");
    }

    public ActionForward chooseExecutionYearPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        SearchStudentsByCurricularCourseParametersBean searchBean = this.getOrCreateSearchBean();
        RenderUtils.invalidateViewState();
        request.setAttribute("searchBean", (Object)searchBean);
        return mapping.findForward("chooseCurricularCourse");
    }

    private SearchStudentsByCurricularCourseParametersBean getOrCreateSearchBean() {
        SearchStudentsByCurricularCourseParametersBean bean = (SearchStudentsByCurricularCourseParametersBean)this.getRenderedObject("searchBean");
        if (bean == null) {
            bean = new SearchStudentsByCurricularCourseParametersBean(AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.STUDENT_LISTINGS, Authenticate.getUser()).collect(Collectors.toSet()));
        }
        return bean;
    }

    public ActionForward showActiveCurricularCourseScope(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        SearchStudentsByCurricularCourseParametersBean searchBean = this.getOrCreateSearchBean();
        TreeSet<DegreeModuleScope> degreeModuleScopes = new TreeSet<DegreeModuleScope>(DegreeModuleScope.COMPARATOR_BY_CURRICULAR_YEAR_AND_SEMESTER_AND_CURRICULAR_COURSE_NAME_AND_BRANCH);
        degreeModuleScopes.addAll(searchBean.getDegreeCurricularPlan().getDegreeModuleScopesFor(searchBean.getExecutionYear()));
        if (degreeModuleScopes.isEmpty()) {
            this.addActionMessage("message", request, "error.nonExisting.AssociatedCurricularCourses");
        } else {
            request.setAttribute("degreeModuleScopes", degreeModuleScopes);
        }
        request.setAttribute("searchBean", (Object)searchBean);
        return mapping.findForward("chooseCurricularCourse");
    }

    public ActionForward searchByCurricularCourse(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        CurricularCourse curricularCourse = (CurricularCourse)((Object)this.getDomainObject(request, "curricularCourseCode"));
        Integer semester = this.getIntegerFromRequest(request, "semester");
        ExecutionYear executionYear = (ExecutionYear)this.getDomainObject(request, "executionYearID");
        request.setAttribute("semester", (Object)semester);
        request.setAttribute("year", (Object)this.getIntegerFromRequest(request, "year"));
        request.setAttribute("curricularYear", (Object)executionYear);
        request.setAttribute("enrolmentList", this.searchStudentByCriteria(executionYear, curricularCourse, semester));
        SearchStudentsByCurricularCourseParametersBean bean = this.getOrCreateSearchBean();
        bean.setExecutionYear(executionYear);
        bean.setCurricularCourse(curricularCourse);
        bean.setDegreeCurricularPlan(curricularCourse.getDegreeCurricularPlan());
        request.setAttribute("searchBean", (Object)bean);
        return mapping.findForward("studentByCurricularCourse");
    }

    private List<Enrolment> searchStudentByCriteria(ExecutionYear executionYear, CurricularCourse curricularCourse, Integer semester) {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        ExecutionSemester executionSemester = executionYear.getExecutionSemesterFor(semester);
        for (Enrolment enrolment : curricularCourse.getEnrolmentsByExecutionPeriod(executionSemester)) {
            result.add(enrolment);
        }
        Collections.sort(result, new BeanComparator("studentCurricularPlan.registration.number"));
        return result;
    }

    public ActionForward exportInfoToExcel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        return this.doExportInfoToExcel(mapping, actionForm, request, response, false);
    }

    public ActionForward exportDetailedInfoToExcel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        return this.doExportInfoToExcel(mapping, actionForm, request, response, true);
    }

    public ActionForward doExportInfoToExcel(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response, Boolean detailed) throws FenixServiceException {
        CurricularCourse curricularCourse = (CurricularCourse)((Object)this.getDomainObject(request, "curricularCourseCode"));
        Integer semester = this.getIntegerFromRequest(request, "semester");
        ExecutionYear executionYear = ExecutionYear.readExecutionYearByName((String)this.getFromRequest(request, "curricularYear"));
        String year = (String)this.getFromRequest(request, "year");
        try {
            String filename = StudentsListByCurricularCourseDA.getResourceMessage("label.students") + "_" + curricularCourse.getName() + "_(" + curricularCourse.getDegreeCurricularPlan().getName() + ")_" + executionYear.getYear();
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-disposition", "attachment; filename=" + filename.replace(" ", "_") + ".xls");
            ServletOutputStream writer = response.getOutputStream();
            this.exportToXls(this.searchStudentByCriteria(executionYear, curricularCourse, semester), (OutputStream)writer, executionYear, curricularCourse, year, semester.toString(), detailed);
            writer.flush();
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new FenixServiceException();
        }
        return null;
    }

    private void exportToXls(List<Enrolment> registrations, OutputStream outputStream, ExecutionYear executionYear, CurricularCourse curricularCourse, String year, String semester, Boolean detailed) throws IOException {
        StyledExcelSpreadsheet spreadsheet = new StyledExcelSpreadsheet(StudentsListByCurricularCourseDA.getResourceMessage("lists.studentByCourse.unspaced"));
        this.fillSpreadSheetFilters(executionYear, curricularCourse, year, semester, spreadsheet);
        this.fillSpreadSheetResults(registrations, spreadsheet, executionYear, detailed);
        spreadsheet.getWorkbook().write(outputStream);
    }

    private void fillSpreadSheetFilters(ExecutionYear executionYear, CurricularCourse curricularCourse, String year, String semester, StyledExcelSpreadsheet spreadsheet) {
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(curricularCourse.getDegree().getNameFor(executionYear) + " - " + curricularCourse.getName() + " - " + executionYear.getYear() + " - " + year + " " + StudentsListByCurricularCourseDA.getResourceMessage("label.year") + " " + semester + " " + StudentsListByCurricularCourseDA.getResourceMessage("label.semester"));
    }

    private void fillSpreadSheetResults(List<Enrolment> registrations, StyledExcelSpreadsheet spreadsheet, ExecutionYear executionYear, Boolean detailed) {
        spreadsheet.newRow();
        spreadsheet.newRow();
        spreadsheet.addCell((Object)(registrations.size() + " " + StudentsListByCurricularCourseDA.getResourceMessage("label.students")));
        this.setHeaders(spreadsheet, detailed);
        for (Enrolment registrationWithStateForExecutionYearBean : registrations) {
            Registration registration = registrationWithStateForExecutionYearBean.getRegistration();
            spreadsheet.newRow();
            spreadsheet.addCell((Object)registration.getNumber().toString());
            spreadsheet.addCell((Object)registration.getPerson().getName());
            spreadsheet.addCell((Object)registration.getRegistrationProtocol().getCode());
            Degree degree = registration.getDegree();
            spreadsheet.addCell((Object)(!StringUtils.isEmpty((String)degree.getSigla()) ? degree.getSigla() : degree.getNameFor(executionYear).toString()));
            spreadsheet.addCell((Object)registrationWithStateForExecutionYearBean.getEnrollmentState().getDescription());
            spreadsheet.addCell((Object)registrationWithStateForExecutionYearBean.getEvaluationSeason().getName().getContent());
            if (!detailed.booleanValue()) continue;
            spreadsheet.addCell((Object)(registration.getPerson().hasDefaultEmailAddress() ? registration.getPerson().getDefaultEmailAddressValue() : "-"));
            spreadsheet.addCell((Object)(registration.getPerson().hasInstitutionalEmailAddress() ? registration.getPerson().getInstitutionalEmailAddressValue() : "-"));
            PartyContact mobileContact = this.getMobileContact(registration.getPerson());
            spreadsheet.addCell((Object)(mobileContact != null ? mobileContact.getPresentationValue() : "-"));
        }
    }

    private PartyContact getMobileContact(Person person) {
        for (PartyContact contact : person.getPartyContactsSet()) {
            if (!contact.isMobile()) continue;
            return contact;
        }
        return null;
    }

    private void setHeaders(StyledExcelSpreadsheet spreadsheet, Boolean detailed) {
        spreadsheet.newHeaderRow();
        spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.student.number"));
        spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.name"));
        spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.registrationAgreement"));
        spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.degree"));
        spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.state"));
        spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.epoch"));
        if (detailed.booleanValue()) {
            spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.email"));
            spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.institutional.email"));
            spreadsheet.addHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.mobile"));
        }
    }

    public ActionForward downloadStatistics(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ExecutionYear executionYear = (ExecutionYear)this.getDomainObject(request, "executionYearId");
        Set<Degree> degreesToInclude = AcademicAccessRule.getDegreesAccessibleToFunction(AcademicOperationType.STUDENT_LISTINGS, Authenticate.getUser()).collect(Collectors.toSet());
        String filename = StudentsListByCurricularCourseDA.getResourceMessage("label.statistics") + "_" + executionYear.getName().replace('/', '-');
        Spreadsheet spreadsheet = new Spreadsheet(filename);
        this.addStatisticsHeaders(spreadsheet);
        this.addStatisticsInformation(spreadsheet, executionYear, degreesToInclude);
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
        ServletOutputStream writer = response.getOutputStream();
        spreadsheet.exportToXLSSheet((OutputStream)writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private void addStatisticsHeaders(Spreadsheet spreadsheet) {
        spreadsheet.setHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.degree.acronym"));
        spreadsheet.setHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.degree.name"));
        spreadsheet.setHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.curricularCourse.name"));
        spreadsheet.setHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.degree.numberOfEnrolments"));
        spreadsheet.setHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.degree.numberOfEnrolments.first.semester"));
        spreadsheet.setHeader(StudentsListByCurricularCourseDA.getResourceMessage("label.degree.numberOfEnrolments.second.semester"));
    }

    private void addStatisticsInformation(Spreadsheet spreadsheet, ExecutionYear executionYear, Set<Degree> degreesToInclude) {
        for (DegreeCurricularPlan degreeCurricularPlan : executionYear.getDegreeCurricularPlans()) {
            Degree degree = degreeCurricularPlan.getDegree();
            if (degreesToInclude != null && !degreesToInclude.contains(degree)) continue;
            for (CurricularCourse curricularCourse : degreeCurricularPlan.getAllCurricularCourses()) {
                if (!curricularCourse.isActive(executionYear)) continue;
                int enrolmentCount = this.countEnrolments(curricularCourse, (ExecutionInterval)((Object)executionYear));
                Spreadsheet.Row row = spreadsheet.addRow();
                row.setCell(degree.getSigla());
                row.setCell(degree.getPresentationName(executionYear));
                row.setCell(curricularCourse.getName());
                row.setCell(Integer.toString(enrolmentCount));
                row.setCell(Integer.toString(this.countEnrolments(curricularCourse, (ExecutionInterval)((Object)executionYear.getFirstExecutionPeriod()))));
                row.setCell(Integer.toString(this.countEnrolments(curricularCourse, (ExecutionInterval)((Object)executionYear.getLastExecutionPeriod()))));
            }
        }
    }

    private int countEnrolments(CurricularCourse curricularCourse, ExecutionInterval interval) {
        int c = 0;
        for (CurriculumModule curriculumModule : curricularCourse.getCurriculumModulesSet()) {
            Enrolment enrolment;
            ExecutionSemester executionSemester;
            if (!curriculumModule.isEnrolment() || interval != (executionSemester = (enrolment = (Enrolment)((Object)curriculumModule)).getExecutionPeriod()) && interval != executionSemester.getExecutionYear()) continue;
            ++c;
        }
        return c;
    }

    private static String getResourceMessage(String key) {
        return BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)key, (String[])new String[0]);
    }

    protected Set<DegreeType> getAdministratedDegreeTypes() {
        return AcademicAccessRule.getDegreeTypesAccessibleToFunction(AcademicOperationType.STUDENT_LISTINGS, Authenticate.getUser()).collect(Collectors.toSet());
    }
}

