/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.pricesManagement;

import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.postingRules.PartialRegistrationRegimeRequestPR;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminPricesApp.class, path="manage", titleKey="label.pricesManagement", accessGroup="academic(MANAGE_PRICES)")
@Mapping(path="/pricesManagement", module="academicAdministration")
@Forwards(value={@Forward(name="viewPrices", path="/academicAdminOffice/pricesManagement/viewPrices.jsp"), @Forward(name="editPrice", path="/academicAdminOffice/pricesManagement/editPrice.jsp")})
public class PricesManagementDispatchAction
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward viewPrices(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        TreeSet<PostingRule> sortedPostingRules = new TreeSet<PostingRule>(PostingRule.COMPARATOR_BY_EVENT_TYPE);
        Set offices = AcademicAccessRule.getOfficesAccessibleToFunction(AcademicOperationType.MANAGE_PRICES, Authenticate.getUser()).collect(Collectors.toSet());
        for (AdministrativeOffice office : offices) {
            sortedPostingRules.addAll(office.getServiceAgreementTemplate().getActiveVisiblePostingRules());
        }
        request.setAttribute("postingRules", sortedPostingRules);
        return mapping.findForward("viewPrices");
    }

    public ActionForward prepareEditPrice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("executionYearBean", (Object)new ExecutionYearBean(ExecutionYear.readCurrentExecutionYear()));
        request.setAttribute("postingRule", this.getDomainObject(request, "postingRuleId"));
        return mapping.findForward("editPrice");
    }

    public ActionForward changeExecutionYearPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionYearBean executionYearBean = (ExecutionYearBean)this.getObjectFromViewState("executionYearBean");
        PartialRegistrationRegimeRequestPR postingRule = PartialRegistrationRegimeRequestPR.readMostRecentPostingRuleForExecutionYear(executionYearBean.getExecutionYear());
        request.setAttribute("postingRule", (Object)postingRule);
        request.setAttribute("executionYearBean", (Object)executionYearBean);
        return mapping.findForward("editPrice");
    }

    public static class ExecutionYearBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ExecutionYear executionYear;

        public ExecutionYearBean(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }

        public ExecutionYear getExecutionYear() {
            return this.executionYear;
        }

        public void setExecutionYear(ExecutionYear executionYear) {
            this.executionYear = executionYear;
        }
    }
}

