/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.candidacy;

import java.util.Arrays;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.converters.EnumConverter;

public class GrantOwnerTypesProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        if (source instanceof PersonalInformationBean) {
            PersonalInformationBean personalInformationBean = (PersonalInformationBean)source;
            Student student = personalInformationBean.getStudent();
            boolean isThirdCycle = false;
            boolean isFirstOrSecondCycle = false;
            isThirdCycle = student.hasActivePhdProgramProcess();
            for (Registration registration : student.getActiveRegistrations()) {
                isThirdCycle |= registration.isDEA();
                isFirstOrSecondCycle |= registration.isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree();
                isFirstOrSecondCycle |= registration.isMasterDegreeOrBolonhaMasterDegree();
            }
            if (isThirdCycle) {
                return GrantOwnerType.getTypesForPhDStudent();
            }
            if (isFirstOrSecondCycle) {
                return GrantOwnerType.getTypesForFirstOrSecondCycle();
            }
        }
        return Arrays.asList(GrantOwnerType.values());
    }

    public Converter getConverter() {
        return new EnumConverter();
    }
}

