/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import java.util.TreeSet;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.interfaces.HasExecutionSemester;
import org.fenixedu.academic.predicate.AcademicPredicates;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ExecutionDegreeForExecutionPeriodAcademicAdminProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        ArrayList executionDegrees = new ArrayList();
        HasExecutionSemester hasExecutionSemester = (HasExecutionSemester)source;
        ExecutionSemester executionPeriod = hasExecutionSemester.getExecutionPeriod();
        if (executionPeriod != null) {
            ExecutionYear executionYear = executionPeriod.getExecutionYear();
            executionDegrees.addAll(executionYear.getExecutionDegreesSet());
        }
        TreeSet<ExecutionDegree> result = new TreeSet<ExecutionDegree>(ExecutionDegree.EXECUTION_DEGREE_COMPARATORY_BY_DEGREE_TYPE_AND_NAME);
        for (ExecutionDegree executionDegree : executionDegrees) {
            if (!AcademicPredicates.MANAGE_EXECUTION_COURSES.evaluate(executionDegree.getDegree())) continue;
            result.add(executionDegree);
        }
        return result;
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

