/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.teacher.evaluation;

import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputHidden;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.struts.util.MessageResources;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.EvaluationConfiguration;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.FinalEvaluation;
import org.fenixedu.academic.domain.FinalMark;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenEvaluationEnrolment;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.InfoRoom;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.IllegalDataAccessException;
import org.fenixedu.academic.service.GOPSendMessageService;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.FenixServiceMultipleException;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.CreateWrittenEvaluation;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.DeleteWrittenEvaluation;
import org.fenixedu.academic.service.services.resourceAllocationManager.exams.EditWrittenEvaluation;
import org.fenixedu.academic.service.services.teacher.EditWrittenEvaluationEnrolmentPeriod;
import org.fenixedu.academic.service.services.teacher.PublishMarks;
import org.fenixedu.academic.service.services.teacher.TeacherEditWrittenTestRooms;
import org.fenixedu.academic.service.services.teacher.WriteMarks;
import org.fenixedu.academic.service.services.teacher.WrittenEvaluationRoomDistribution;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;
import org.fenixedu.academic.ui.faces.bean.teacher.evaluation.EvaluationManagementBackingBean$callable$sendEmailRequestRoom;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.academic.util.Season;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.portal.servlet.PortalLayoutInjector;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.spaces.domain.Space;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class EvaluationManagementBackingBean
extends FenixBackingBean {
    private static final String ENROLMENT_TYPE_FILTER_ALL = "all";
    private static final String ENROLMENT_TYPE_FILTER_NOT_ENROLLED = "not.enrolled";
    protected String executionCourseID;
    private HtmlInputHidden executionCourseIdHidden;
    protected String evaluationID;
    private HtmlInputHidden evaluationIdHidden;
    protected String evaluationTypeClassname;
    protected Integer day;
    protected Integer month;
    protected Integer year;
    protected Integer beginHour;
    protected Integer beginMinute;
    protected Integer endHour;
    protected Integer endMinute;
    protected Integer enrolmentBeginDay;
    protected Integer enrolmentBeginMonth;
    protected Integer enrolmentBeginYear;
    protected Integer enrolmentBeginHour;
    protected Integer enrolmentBeginMinute;
    protected Integer enrolmentEndDay;
    protected Integer enrolmentEndMonth;
    protected Integer enrolmentEndYear;
    protected Integer enrolmentEndHour;
    protected Integer enrolmentEndMinute;
    protected String description;
    private String season;
    protected List<WrittenEvaluationEnrolment> writtenEvaluationEnrolments;
    protected Evaluation evaluation;
    protected String distributeEnroledStudentsOption;
    private boolean resetPosition = false;
    private String publishMarksMessage;
    private Boolean sendSMS;
    private String originPage;
    private String selectedBegin;
    private String selectedEnd;
    protected Map<String, String> marks = new HashMap<String, String>();
    protected String[] attendsIDs;
    protected String submitEvaluationDateTextBoxValue;
    protected HtmlInputText submitEvaluationDateTextBox;
    protected List<FinalMark> alreadySubmitedMarks;
    protected List<Attends> notSubmitedMarks;
    protected Integer[] roomsToDelete;
    protected String[] roomsToAssociate;
    protected Map<String, Boolean> canManageRoomsMap = new HashMap<String, Boolean>();
    protected GradeScale gradeScale;
    protected String enrolmentTypeFilter;
    public static final Advice advice$sendEmailRequestRoom = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public EvaluationManagementBackingBean() {
        this.getAndHoldStringParameter("executionCourseID");
        this.fillLayoutContext();
        this.initializeEnrolmentFilter();
    }

    public void fillLayoutContext() {
        String executionCourseID = this.getExecutionCourseID();
        if (!Strings.isNullOrEmpty((String)executionCourseID)) {
            ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
            Professorship professorship = executionCourse.getProfessorship(AccessControl.getPerson());
            HashMap<String, Object> requestContext = new HashMap<String, Object>();
            requestContext.put("professorship", (Object)professorship);
            requestContext.put("executionCourse", (Object)executionCourse);
            PortalLayoutInjector.addContextExtension(requestContext);
        }
    }

    public String getExecutionCourseID() {
        if (this.executionCourseID == null) {
            if (this.executionCourseIdHidden != null && this.executionCourseIdHidden.getValue() != null) {
                this.executionCourseID = this.executionCourseIdHidden.getValue().toString();
            } else {
                String executionCourseIDString = this.getRequestParameter("executionCourseID");
                if (executionCourseIDString != null && executionCourseIDString.length() > 0) {
                    this.executionCourseID = executionCourseIDString;
                }
            }
        }
        return this.executionCourseID;
    }

    public void setExecutionCourseID(String executionCourseId) {
        this.executionCourseID = executionCourseId;
    }

    public HtmlInputHidden getExecutionCourseIdHidden() {
        if (this.executionCourseIdHidden == null) {
            String executionCourseId = this.getExecutionCourseID();
            this.executionCourseIdHidden = new HtmlInputHidden();
            this.executionCourseIdHidden.setValue((Object)executionCourseId);
            this.executionCourseID = executionCourseId;
        }
        return this.executionCourseIdHidden;
    }

    public void setExecutionCourseIdHidden(HtmlInputHidden executionCourseIdHidden) {
        if (executionCourseIdHidden != null) {
            this.executionCourseID = executionCourseIdHidden.getValue().toString();
            this.setRequestAttribute("executionCourseID", executionCourseIdHidden.getValue());
            this.fillLayoutContext();
        }
        this.executionCourseIdHidden = executionCourseIdHidden;
    }

    public String getEvaluationID() {
        if (this.evaluationID == null) {
            if (this.evaluationIdHidden != null && this.evaluationIdHidden.getValue() != null && !this.evaluationIdHidden.getValue().equals("")) {
                this.evaluationID = this.evaluationIdHidden.getValue().toString();
            } else if (this.getRequestParameter("evaluationID") != null && !this.getRequestParameter("evaluationID").equals("")) {
                this.evaluationID = this.getRequestParameter("evaluationID");
            }
        }
        return this.evaluationID;
    }

    public void setEvaluationID(String evaluationId) {
        this.evaluationID = evaluationId;
    }

    public HtmlInputHidden getEvaluationIdHidden() {
        if (this.evaluationIdHidden == null) {
            String evaluationId = this.getEvaluationID();
            this.evaluationIdHidden = new HtmlInputHidden();
            this.evaluationIdHidden.setValue((Object)evaluationId);
        }
        return this.evaluationIdHidden;
    }

    public void setEvaluationIdHidden(HtmlInputHidden evaluationIdHidden) {
        if (evaluationIdHidden != null && evaluationIdHidden.getValue() != null && !evaluationIdHidden.getValue().toString().equals("")) {
            this.evaluationID = evaluationIdHidden.getValue().toString();
        }
        this.evaluationIdHidden = evaluationIdHidden;
    }

    public Integer getDay() throws FenixServiceException {
        if (this.day == null && this.getEvaluation() != null) {
            this.day = ((WrittenEvaluation)((Object)this.getEvaluation())).getDay().get(5);
        } else if (this.getRequestParameter("day") != null && !this.getRequestParameter("day").equals("")) {
            this.day = Integer.valueOf(this.getRequestParameter("day"));
        }
        return this.day;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getMonth() throws FenixServiceException {
        if (this.month == null && this.getEvaluation() != null) {
            this.month = ((WrittenEvaluation)((Object)this.getEvaluation())).getDay().get(2) + 1;
        } else if (this.getRequestParameter("month") != null && !this.getRequestParameter("month").equals("")) {
            this.month = Integer.valueOf(this.getRequestParameter("month"));
        }
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getYear() throws FenixServiceException {
        if (this.year == null && this.getEvaluation() != null) {
            this.year = ((WrittenEvaluation)((Object)this.getEvaluation())).getDay().get(1);
        } else if (this.getRequestParameter("year") != null && !this.getRequestParameter("year").equals("")) {
            this.year = Integer.valueOf(this.getRequestParameter("year"));
        }
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getBeginHour() throws FenixServiceException {
        if (this.beginHour == null && this.getEvaluation() != null) {
            this.beginHour = ((WrittenEvaluation)((Object)this.getEvaluation())).getBeginning().get(11);
        }
        return this.beginHour;
    }

    public void setBeginHour(Integer beginHour) {
        this.beginHour = beginHour;
    }

    public Integer getBeginMinute() throws FenixServiceException {
        if (this.beginMinute == null && this.getEvaluation() != null) {
            this.beginMinute = ((WrittenEvaluation)((Object)this.getEvaluation())).getBeginning().get(12);
        }
        return this.beginMinute;
    }

    public void setBeginMinute(Integer beginMinute) {
        this.beginMinute = beginMinute;
    }

    public Integer getEndHour() throws FenixServiceException {
        if (this.endHour == null && this.getEvaluation() != null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnd() != null) {
            this.endHour = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnd().get(11);
        }
        return this.endHour;
    }

    public void setEndHour(Integer endHour) {
        this.endHour = endHour;
    }

    public Integer getEndMinute() throws FenixServiceException {
        if (this.endMinute == null && this.getEvaluation() != null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnd() != null) {
            this.endMinute = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnd().get(12);
        }
        return this.endMinute;
    }

    public void setEndMinute(Integer endMinute) {
        this.endMinute = endMinute;
    }

    public String getDescription() throws FenixServiceException {
        if (this.description == null && this.getEvaluation() != null) {
            Evaluation writtenEvaluation = this.getEvaluation();
            if (writtenEvaluation instanceof WrittenTest) {
                this.description = ((WrittenTest)((Object)writtenEvaluation)).getDescription();
            }
        } else if (this.getViewState().getAttribute("description") != null && !this.getViewState().getAttribute("description").equals("")) {
            this.description = (String)this.getViewState().getAttribute("description");
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.getViewState().setAttribute("description", description);
    }

    public Integer getEnrolmentBeginDay() throws FenixServiceException {
        if (this.enrolmentBeginDay == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginDay() != null) {
            this.enrolmentBeginDay = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginDay().get(5);
        }
        return this.enrolmentBeginDay;
    }

    public void setEnrolmentBeginDay(Integer enrolmentBeginDay) {
        this.enrolmentBeginDay = enrolmentBeginDay;
    }

    public Integer getEnrolmentBeginHour() throws FenixServiceException {
        if (this.enrolmentBeginHour == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginTime() != null) {
            this.enrolmentBeginHour = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginTime().get(11);
        }
        return this.enrolmentBeginHour;
    }

    public void setEnrolmentBeginHour(Integer enrolmentBeginHour) {
        this.enrolmentBeginHour = enrolmentBeginHour;
    }

    public Integer getEnrolmentBeginMinute() throws FenixServiceException {
        if (this.enrolmentBeginMinute == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginTime() != null) {
            this.enrolmentBeginMinute = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginTime().get(12);
        }
        return this.enrolmentBeginMinute;
    }

    public void setEnrolmentBeginMinute(Integer enrolmentBeginMinute) {
        this.enrolmentBeginMinute = enrolmentBeginMinute;
    }

    public Integer getEnrolmentBeginMonth() throws FenixServiceException {
        if (this.enrolmentBeginMonth == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginDay() != null) {
            this.enrolmentBeginMonth = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginDay().get(2) + 1;
        }
        return this.enrolmentBeginMonth;
    }

    public void setEnrolmentBeginMonth(Integer enrolmentBeginMonth) {
        this.enrolmentBeginMonth = enrolmentBeginMonth;
    }

    public Integer getEnrolmentBeginYear() throws FenixServiceException {
        if (this.enrolmentBeginYear == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginDay() != null) {
            this.enrolmentBeginYear = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentBeginDay().get(1);
        }
        return this.enrolmentBeginYear;
    }

    public void setEnrolmentBeginYear(Integer enrolmentBeginYear) {
        this.enrolmentBeginYear = enrolmentBeginYear;
    }

    public Integer getEnrolmentEndDay() throws FenixServiceException {
        if (this.enrolmentEndDay == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndDay() != null) {
            this.enrolmentEndDay = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndDay().get(5);
        }
        return this.enrolmentEndDay;
    }

    public void setEnrolmentEndDay(Integer enrolmentEndDay) {
        this.enrolmentEndDay = enrolmentEndDay;
    }

    public Integer getEnrolmentEndHour() throws FenixServiceException {
        if (this.enrolmentEndHour == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndTime() != null) {
            this.enrolmentEndHour = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndTime().get(11);
        }
        return this.enrolmentEndHour;
    }

    public void setEnrolmentEndHour(Integer enrolmentEndHour) {
        this.enrolmentEndHour = enrolmentEndHour;
    }

    public Integer getEnrolmentEndMinute() throws FenixServiceException {
        if (this.enrolmentEndMinute == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndTime() != null) {
            this.enrolmentEndMinute = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndTime().get(12);
        }
        return this.enrolmentEndMinute;
    }

    public void setEnrolmentEndMinute(Integer enrolmentEndMinute) {
        this.enrolmentEndMinute = enrolmentEndMinute;
    }

    public Integer getEnrolmentEndMonth() throws FenixServiceException {
        if (this.enrolmentEndMonth == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndDay() != null) {
            this.enrolmentEndMonth = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndDay().get(2) + 1;
        }
        return this.enrolmentEndMonth;
    }

    public void setEnrolmentEndMonth(Integer enrolmentEndMonth) {
        this.enrolmentEndMonth = enrolmentEndMonth;
    }

    public Integer getEnrolmentEndYear() throws FenixServiceException {
        if (this.enrolmentEndYear == null && ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndDay() != null) {
            this.enrolmentEndYear = ((WrittenEvaluation)((Object)this.getEvaluation())).getEnrollmentEndDay().get(1);
        }
        return this.enrolmentEndYear;
    }

    public void setEnrolmentEndYear(Integer enrolmentEndYear) {
        this.enrolmentEndYear = enrolmentEndYear;
    }

    public String getDistributeEnroledStudentsOption() {
        return this.distributeEnroledStudentsOption == null ? "true" : this.distributeEnroledStudentsOption;
    }

    public void setDistributeEnroledStudentsOption(String distributeEnroledStudentsOption) {
        this.distributeEnroledStudentsOption = distributeEnroledStudentsOption;
    }

    public String getRoomToChangeID() throws FenixServiceException {
        if (this.getViewState().getAttribute("roomToChangeID") == null) {
            this.getViewState().setAttribute("roomToChangeID", this.getElementKeyFor(this.getEvaluationRoomsPositions(), 1));
        }
        return (String)this.getViewState().getAttribute("roomToChangeID");
    }

    public void setRoomToChangeID(String roomToChangeID) {
        this.getViewState().setAttribute("roomToChangeID", roomToChangeID);
    }

    public Integer getNewRoomPosition() throws FenixServiceException {
        if (this.getViewState().getAttribute("newRoomPosition") == null || this.resetPosition) {
            this.getViewState().setAttribute("newRoomPosition", 0);
        }
        return (Integer)this.getViewState().getAttribute("newRoomPosition");
    }

    public void setNewRoomPosition(Integer newRoomPosition) {
        this.getViewState().setAttribute("newRoomPosition", newRoomPosition);
    }

    public List<Exam> getExamList() throws FenixServiceException {
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)this.getExecutionCourseID());
        ArrayList<Exam> examsList = new ArrayList<Exam>(executionCourse.getAssociatedExams());
        Collections.sort(examsList, new BeanComparator("dayDate"));
        return examsList;
    }

    public List<WrittenTest> getWrittenTestList() throws FenixServiceException {
        ExecutionCourse executionCourse = this.getExecutionCourse();
        Teacher teacher = AccessControl.getPerson().getTeacher();
        ArrayList<WrittenTest> writtenTestList = new ArrayList<WrittenTest>();
        for (WrittenTest writtenTest : executionCourse.getAssociatedWrittenTests()) {
            writtenTestList.add(writtenTest);
            this.canManageRoomsMap.put(writtenTest.getExternalId(), writtenTest.canTeacherChooseRoom(executionCourse, teacher));
        }
        Collections.sort(writtenTestList, new BeanComparator("dayDate"));
        return writtenTestList;
    }

    public Evaluation getEvaluation() {
        if (this.evaluation == null) {
            if (this.getEvaluationID() != null) {
                this.evaluation = (Evaluation)FenixFramework.getDomainObject((String)this.getEvaluationID());
            } else {
                return null;
            }
        }
        return this.evaluation;
    }

    private Calendar getEnrolmentBegin() throws FenixServiceException {
        Calendar result = Calendar.getInstance();
        result.set(this.getEnrolmentBeginYear(), this.getEnrolmentBeginMonth() - 1, this.getEnrolmentBeginDay(), this.getEnrolmentBeginHour(), this.getEnrolmentBeginMinute());
        return result;
    }

    private Calendar getEnrolmentEnd() throws FenixServiceException {
        Calendar result = Calendar.getInstance();
        result.set(this.getEnrolmentEndYear(), this.getEnrolmentEndMonth() - 1, this.getEnrolmentEndDay(), this.getEnrolmentEndHour(), this.getEnrolmentEndMinute());
        return result;
    }

    public String editEvaluationEnrolmentPeriod() throws FenixServiceException {
        Calendar enrolmentBeginDay = this.getEnrolmentBegin();
        Calendar enrolmentBeginTime = this.getEnrolmentBegin();
        Calendar enrolmentEndDay = this.getEnrolmentEnd();
        Calendar enrolmentEndTime = this.getEnrolmentEnd();
        try {
            EditWrittenEvaluationEnrolmentPeriod.runEditWrittenEvaluationEnrolmentPeriod(this.getExecutionCourseID(), this.getEvaluationID(), enrolmentBeginDay.getTime(), enrolmentEndDay.getTime(), enrolmentBeginTime.getTime(), enrolmentEndTime.getTime());
        }
        catch (Exception e) {
            this.addErrorMessage(e.getMessage());
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        return ((Object)((Object)this.getEvaluation())).getClass().getSimpleName();
    }

    public String editMarks() throws FenixServiceException, IllegalDataAccessException {
        if (this.getEvaluationID() == null) {
            WriteMarks.writeByAttend(this.getExecutionCourseID(), this.getEvaluationID(), this.buildAttendsMark());
            return "";
        }
        try {
            WriteMarks.writeByAttend(this.getExecutionCourseID(), this.getEvaluationID(), this.buildAttendsMark());
        }
        catch (FenixServiceMultipleException e) {
            for (DomainException domainException : e.getExceptionList()) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ApplicationResources", (String)domainException.getKey(), (String[])domainException.getArgs()));
            }
            return "";
        }
        catch (IllegalDataAccessException idae) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ApplicationResources", (String)"message.teacher.evaluation.editMarks", (String[])new String[]{ExecutionSemester.readActualExecutionSemester().getExecutionYear().getName(), ExecutionSemester.readActualExecutionSemester().getName()}));
            return "";
        }
        return ((Object)((Object)this.getEvaluation())).getClass().getSimpleName();
    }

    private List<WriteMarks.AttendsMark> buildAttendsMark() {
        ArrayList<WriteMarks.AttendsMark> result = new ArrayList<WriteMarks.AttendsMark>();
        for (Map.Entry<String, String> entry : this.marks.entrySet()) {
            result.add(new WriteMarks.AttendsMark(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    public List<WrittenEvaluationEnrolment> getWrittenEvaluationEnrolments() throws FenixServiceException {
        if (this.writtenEvaluationEnrolments == null) {
            this.writtenEvaluationEnrolments = new ArrayList<WrittenEvaluationEnrolment>(((WrittenEvaluation)((Object)this.getEvaluation())).getWrittenEvaluationEnrolmentsSet());
            Collections.sort(this.writtenEvaluationEnrolments, new BeanComparator("student.person.username"));
        }
        return this.writtenEvaluationEnrolments;
    }

    public Calendar getBegin() throws FenixServiceException {
        Calendar result = Calendar.getInstance();
        result.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getBeginHour(), this.getBeginMinute());
        return result;
    }

    public Calendar getEnd() throws FenixServiceException {
        Calendar result = Calendar.getInstance();
        result.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getEndHour(), this.getEndMinute());
        return result;
    }

    public String createWrittenTest() throws FenixServiceException {
        ArrayList<String> executionCourseIDs = new ArrayList<String>();
        executionCourseIDs.add(this.getExecutionCourseID().toString());
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)this.getExecutionCourseID());
        List<String> degreeModuleScopesIDs = this.getDegreeModuleScopeIDs(executionCourse);
        Season season = this.getSeason() != null ? new Season(this.getSeason()) : null;
        try {
            CreateWrittenEvaluation.runCreateWrittenEvaluation(this.getExecutionCourseID(), this.getBegin().getTime(), this.getBegin().getTime(), this.getEnd().getTime(), executionCourseIDs, degreeModuleScopesIDs, null, this.getGradeScale(), season, this.getDescription());
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            if (e instanceof IllegalDataAccessException) {
                errorMessage = "message.error.notAuthorized.create.evaluation.during.exan.period";
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        return WrittenTest.class.getSimpleName();
    }

    public ExecutionCourse getExecutionCourse() {
        return (ExecutionCourse)FenixFramework.getDomainObject((String)this.getExecutionCourseID());
    }

    public String getHackToStoreExecutionCourse() {
        ExecutionCourse course = this.getExecutionCourse();
        this.setRequestAttribute("executionCourse", (Object)course);
        return "";
    }

    public Map<String, String> getMarks() throws FenixServiceException {
        Evaluation evaluation = this.getEvaluation();
        ExecutionCourse executionCourse = this.getExecutionCourse();
        if (executionCourse != null) {
            for (Attends attends : this.getExecutionCourseAttends()) {
                Mark mark = attends.getMarkByEvaluation(evaluation);
                if (mark == null || this.marks.containsKey(attends.getExternalId())) continue;
                this.marks.put(attends.getExternalId(), mark.getMark());
            }
        }
        return this.marks;
    }

    public void setMarks(Map<String, String> marks) {
        this.marks = marks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadMarks() throws FenixServiceException, ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        Part fileItem = httpServletRequest.getPart("theFile");
        InputStream inputStream = null;
        try {
            inputStream = fileItem.getInputStream();
            Map<String, String> marks = this.loadMarks(inputStream);
            WriteMarks.writeByStudent(this.getExecutionCourseID(), this.getEvaluationID(), this.buildStudentMarks(marks));
            String string = "success";
            return string;
        }
        catch (FenixServiceMultipleException e) {
            for (DomainException domainException : e.getExceptionList()) {
                this.addErrorMessage(BundleUtil.getString((String)"resources.ApplicationResources", (String)domainException.getKey(), (String[])domainException.getArgs()));
            }
            String string = "";
            return string;
        }
        catch (IOException e) {
            this.addErrorMessage(BundleUtil.getString((String)"resources.ApplicationResources", (String)e.getMessage(), (String[])new String[0]));
            String string = "";
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private List<WriteMarks.StudentMark> buildStudentMarks(Map<String, String> marks) {
        ArrayList<WriteMarks.StudentMark> result = new ArrayList<WriteMarks.StudentMark>();
        for (Map.Entry<String, String> entry : marks.entrySet()) {
            result.add(new WriteMarks.StudentMark(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private Map<String, String> loadMarks(InputStream inputStream) throws IOException {
        HashMap<String, String> marks = new HashMap<String, String>();
        InputStreamReader input = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        BufferedReader reader = new BufferedReader(input);
        char[] buffer = new char[4096];
        StringBuilder fileContents = new StringBuilder();
        int i = 0;
        while ((i = reader.read(buffer)) != -1) {
            fileContents.append(buffer, 0, i);
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(fileContents.toString());
            while (true) {
                String studentNumber;
                if ((studentNumber = this.getNextToken(stringTokenizer)) == null) {
                    return marks;
                }
                String mark = this.getNextToken(stringTokenizer);
                if (mark == null) {
                    throw new Exception();
                }
                marks.put(studentNumber, mark);
            }
        }
        catch (Exception e) {
            throw new IOException("error.file.badFormat");
        }
    }

    private String getNextToken(StringTokenizer stringTokenizer) {
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            return token;
        }
        return null;
    }

    public String editWrittenTest() throws Exception {
        ArrayList<String> executionCourseIDs = new ArrayList<String>();
        executionCourseIDs.add(this.getExecutionCourseID().toString());
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)this.getExecutionCourseID());
        List<String> degreeModuleScopesIDs = this.getDegreeModuleScopeIDs(executionCourse);
        Season season = this.getSeason() != null ? new Season(this.getSeason()) : null;
        try {
            EditWrittenEvaluation.runEditWrittenEvaluation(this.getExecutionCourseID(), this.getBegin().getTime(), this.getBegin().getTime(), this.getEnd().getTime(), executionCourseIDs, degreeModuleScopesIDs, null, this.evaluationID, season, this.getDescription(), this.getGradeScale());
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            if (e instanceof IllegalDataAccessException) {
                errorMessage = "message.error.notAuthorized.create.evaluation.during.exan.period";
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        String originPage = this.getOriginPage();
        if (originPage != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getApplicationContext());
            stringBuilder.append("/resourceAllocationManager/searchWrittenEvaluationsByDate.do?method=returnToSearchPage&amp;page=0&date=");
            stringBuilder.append(DateFormatUtil.format("yyyy/MM/dd", this.getBegin().getTime()));
            stringBuilder.append("&");
            stringBuilder.append("executionPeriodOID");
            stringBuilder.append("=");
            stringBuilder.append(executionCourse.getExecutionPeriod().getExternalId());
            if (this.selectedBegin != null && this.selectedBegin.length() > 0 && this.selectedBegin.equals("true")) {
                stringBuilder.append("selectedBegin=");
                stringBuilder.append(DateFormatUtil.format("HH:mm", this.getBegin().getTime()));
            }
            if (this.selectedEnd != null && this.selectedEnd.length() > 0 && this.selectedEnd.equals("true")) {
                stringBuilder.append("selectedEnd=");
                stringBuilder.append(DateFormatUtil.format("HH:mm", this.getEnd().getTime()));
            }
            FacesContext.getCurrentInstance().getExternalContext().redirect(stringBuilder.toString());
            return originPage;
        }
        return ((Object)((Object)this.getEvaluation())).getClass().getSimpleName();
    }

    private List<String> getDegreeModuleScopeIDs(ExecutionCourse executionCourse) {
        ArrayList<String> degreeModuleScopesIDs = new ArrayList<String>();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            List<DegreeModuleScope> degreeModuleScopes = curricularCourse.getDegreeModuleScopes();
            for (DegreeModuleScope degreeModuleScope : degreeModuleScopes) {
                if (!degreeModuleScope.getCurricularSemester().equals(executionCourse.getExecutionPeriod().getSemester())) continue;
                degreeModuleScopesIDs.add(degreeModuleScope.getKey());
            }
        }
        return degreeModuleScopesIDs;
    }

    protected String getApplicationContext() {
        return this.getRequest().getContextPath();
    }

    public String deleteWrittenTest() throws FenixServiceException {
        try {
            DeleteWrittenEvaluation.runDeleteWrittenEvaluation(this.getExecutionCourseID(), this.getEvaluationID());
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            if (e instanceof NotAuthorizedException) {
                errorMessage = "message.error.notAuthorized";
            }
            this.setErrorMessage(errorMessage);
            return "";
        }
        return WrittenTest.class.getSimpleName();
    }

    public List<InfoRoom> getEvaluationRooms() throws FenixServiceException {
        Space[] result = new Space[this.getEvaluationRoomsPositions().size()];
        for (Map.Entry<String, Integer> entry : this.getEvaluationRoomsPositions().entrySet()) {
            Space room;
            result[entry.getValue().intValue() - 1] = room = this.getRoom(entry.getKey());
        }
        return Arrays.stream(result).map(s -> new InfoRoom((Space)s)).collect(Collectors.toList());
    }

    private Space getRoom(String roomID) throws FenixServiceException {
        for (WrittenEvaluationSpaceOccupation roomOccupation : ((WrittenEvaluation)((Object)this.getEvaluation())).getWrittenEvaluationSpaceOccupationsSet()) {
            if (!roomOccupation.getRoom().getExternalId().equals(roomID)) continue;
            return roomOccupation.getRoom();
        }
        return null;
    }

    public Map<String, Integer> getEvaluationRoomsPositions() throws FenixServiceException {
        if (this.getViewState().getAttribute("evaluationRooms") == null) {
            Map<String, Integer> evaluationRooms = this.initializeEvaluationRoomsPositions();
            this.getViewState().setAttribute("evaluationRooms", evaluationRooms);
        }
        return (Map)this.getViewState().getAttribute("evaluationRooms");
    }

    public Integer getExamCapacity(Space space) {
        Optional metadata = space.getMetadata("examCapacity");
        return metadata.isPresent() ? (Integer)metadata.get() : Integer.valueOf(0);
    }

    private Map<String, Integer> initializeEvaluationRoomsPositions() throws FenixServiceException {
        TreeMap<String, Integer> evaluationRooms = new TreeMap<String, Integer>();
        WrittenEvaluation writtenEvaluation = (WrittenEvaluation)((Object)this.getEvaluation());
        List roomOccupations = writtenEvaluation.getWrittenEvaluationSpaceOccupationsSet().stream().sorted((o1, o2) -> this.getExamCapacity(o2.getRoom()).compareTo(this.getExamCapacity(o1.getRoom()))).collect(Collectors.toList());
        int count = 0;
        for (WrittenEvaluationSpaceOccupation roomOccupation : roomOccupations) {
            evaluationRooms.put(roomOccupation.getRoom().getExternalId(), ++count);
        }
        return evaluationRooms;
    }

    public void changeRoom(ValueChangeEvent valueChangeEvent) {
        this.resetPosition = true;
    }

    public void changePosition(ValueChangeEvent valueChangeEvent) throws FenixServiceException {
        Integer roomToChangeNewPosition = (Integer)valueChangeEvent.getNewValue();
        if (roomToChangeNewPosition != 0) {
            Integer roomToChangeOldPosition = this.getEvaluationRoomsPositions().get(this.getRoomToChangeID());
            String elementKey = this.getElementKeyFor(this.getEvaluationRoomsPositions(), roomToChangeNewPosition);
            this.getEvaluationRoomsPositions().put(elementKey, roomToChangeOldPosition);
            this.getEvaluationRoomsPositions().put(this.getRoomToChangeID(), roomToChangeNewPosition);
        }
    }

    private String getElementKeyFor(Map<String, Integer> evaluationRooms, Integer roomPosition) {
        for (Map.Entry<String, Integer> entry : evaluationRooms.entrySet()) {
            if (!entry.getValue().equals(roomPosition)) continue;
            return entry.getKey();
        }
        return null;
    }

    public List<SelectItem> getNames() throws FenixServiceException {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(((WrittenEvaluation)((Object)this.getEvaluation())).getWrittenEvaluationSpaceOccupationsSet().size());
        for (WrittenEvaluationSpaceOccupation roomOccupation : ((WrittenEvaluation)((Object)this.getEvaluation())).getWrittenEvaluationSpaceOccupationsSet()) {
            result.add(new SelectItem((Object)roomOccupation.getRoom().getExternalId(), roomOccupation.getRoom().getName()));
        }
        return result;
    }

    public List<SelectItem> getPositions() throws FenixServiceException {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(this.getEvaluationRoomsPositions().size());
        result.add(new SelectItem((Object)0, ""));
        for (Integer value : this.getEvaluationRoomsPositions().values()) {
            result.add(new SelectItem((Object)value, value.toString()));
        }
        Collections.sort(result, new BeanComparator("label"));
        this.resetPosition = true;
        return result;
    }

    public String distributeStudentsByRooms() throws FenixServiceException {
        try {
            Boolean distributeOnlyEnroledStudents = Boolean.valueOf(this.getDistributeEnroledStudentsOption());
            WrittenEvaluationRoomDistribution.runWrittenEvaluationRoomDistribution(this.getExecutionCourseID(), this.getEvaluationID(), this.getRoomIDs(), distributeOnlyEnroledStudents);
            return "enterShowStudentsEnroled";
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return "";
        }
    }

    private List<String> getRoomIDs() throws FenixServiceException {
        List<InfoRoom> rooms = this.getEvaluationRooms();
        ArrayList<String> result = new ArrayList<String>(rooms.size());
        for (InfoRoom room : rooms) {
            result.add(room.getExternalId());
        }
        return result;
    }

    public String checkIfCanDistributeStudentsByRooms() throws FenixServiceException {
        try {
            Evaluation writtenEvaluation = this.getEvaluation();
            ((WrittenEvaluation)((Object)writtenEvaluation)).checkIfCanDistributeStudentsByRooms();
            return "enterDistributeStudentsByRooms";
        }
        catch (DomainException e) {
            this.setErrorMessage(e.getMessage());
            return "";
        }
    }

    public boolean getExistsADistribution() {
        Evaluation writtenEvaluation = this.getEvaluation();
        if (writtenEvaluation != null) {
            return !((WrittenEvaluation)((Object)writtenEvaluation)).getWrittenEvaluationEnrolmentsSet().isEmpty();
        }
        return false;
    }

    public int getNumberOfAttendingStudents() throws FenixServiceException {
        int numberOfAttendingStudents = 0;
        for (ExecutionCourse executionCourse : this.getEvaluation().getAssociatedExecutionCoursesSet()) {
            numberOfAttendingStudents += executionCourse.getAttendsSet().size();
        }
        return numberOfAttendingStudents;
    }

    public FinalEvaluation getFinalEvaluation() {
        for (Evaluation evaluation : this.getExecutionCourse().getAssociatedEvaluationsSet()) {
            if (!(evaluation instanceof FinalEvaluation)) continue;
            return (FinalEvaluation)((Object)evaluation);
        }
        return null;
    }

    public List<Attends> getExecutionCourseAttends() {
        ArrayList<Attends> result = new ArrayList<Attends>();
        String filter = this.getEnrolmentTypeFilter();
        for (Attends attends : this.getExecutionCourse().getAttendsSet()) {
            if (attends.getEnrolment() != null && attends.getEnrolment().isImpossible()) continue;
            if (filter.equals(ENROLMENT_TYPE_FILTER_ALL)) {
                result.add(attends);
                continue;
            }
            if (filter.equals(ENROLMENT_TYPE_FILTER_NOT_ENROLLED)) {
                if (attends.getEnrolment() != null) continue;
                result.add(attends);
                continue;
            }
            if (attends.getEnrolment() == null) continue;
            EvaluationSeason season = (EvaluationSeason)FenixFramework.getDomainObject((String)filter);
            if (!attends.getEnrolment().getEvaluationSeason().equals(season)) continue;
            result.add(attends);
        }
        Collections.sort(result, Attends.COMPARATOR_BY_STUDENT_NUMBER);
        return result;
    }

    public List<Student> getStudentsWithImpossibleEnrolments() {
        ArrayList<Student> result = new ArrayList<Student>();
        for (Attends attends : this.getExecutionCourse().getAttendsSet()) {
            Student student;
            if (attends.getEnrolment() == null || !attends.getEnrolment().isImpossible() || result.contains((Object)(student = attends.getEnrolment().getStudentCurricularPlan().getRegistration().getStudent()))) continue;
            result.add(student);
        }
        return result;
    }

    public String getPublishMarksMessage() {
        return this.publishMarksMessage;
    }

    public void setPublishMarksMessage(String publishMarksMessage) {
        this.publishMarksMessage = publishMarksMessage;
    }

    public Boolean getSendSMS() {
        return this.sendSMS;
    }

    public void setSendSMS(Boolean sendSMS) {
        this.sendSMS = sendSMS;
    }

    public String publishMarks() throws FenixServiceException {
        MessageResources messages = MessageResources.getMessageResources((String)"resources.ApplicationResources");
        String announcementTitle = this.getPublishMarksMessage() != null && this.getPublishMarksMessage().length() > 0 ? messages.getMessage("message.publishment") : null;
        try {
            PublishMarks.runPublishMarks(this.getExecutionCourseID(), this.getEvaluationID(), this.getPublishMarksMessage(), this.getSendSMS(), announcementTitle);
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return "";
        }
        return ((Object)((Object)this.getEvaluation())).getClass().getSimpleName();
    }

    public String getEvaluationTypeClassname() throws FenixServiceException {
        Evaluation evaluation;
        String evaluationTypeClassname = (String)this.getViewState().getAttribute("evaluationTypeClassname");
        if (evaluationTypeClassname == null && (evaluationTypeClassname = this.getRequestParameter("evaluationTypeClassname")) != null) {
            this.setEvaluationTypeClassname(evaluationTypeClassname);
        }
        if (evaluationTypeClassname == null && (evaluation = this.getEvaluation()) != null) {
            evaluationTypeClassname = ((Object)((Object)evaluation)).getClass().getName();
            this.setEvaluationTypeClassname(evaluationTypeClassname);
        }
        return evaluationTypeClassname;
    }

    public void setEvaluationTypeClassname(String evaluationTypeClassname) {
        this.getViewState().setAttribute("evaluationTypeClassname", evaluationTypeClassname);
    }

    public String getSeason() throws FenixServiceException {
        Evaluation evaluation;
        if (this.season == null && (evaluation = this.getEvaluation()) != null && evaluation instanceof Exam) {
            Exam exam = (Exam)((Object)evaluation);
            this.season = exam.getSeason().toString();
        }
        if (this.getViewState().getAttribute("season") != null && !this.getViewState().getAttribute("season").equals("")) {
            this.season = (String)this.getViewState().getAttribute("season");
        }
        return this.season;
    }

    public void setSeason(String season) {
        this.season = season;
        this.getViewState().setAttribute("season", season);
    }

    public String getOriginPage() {
        if (this.originPage == null) {
            this.originPage = this.getRequestParameter("originPage");
        }
        return this.originPage;
    }

    public void setOriginPage(String originPage) {
        this.originPage = originPage;
    }

    public String getSelectedBegin() {
        if (this.selectedBegin == null) {
            this.selectedBegin = this.getRequestParameter("selectedBegin");
        }
        return this.selectedBegin;
    }

    public void setSelectedBegin(String selectedBegin) {
        this.selectedBegin = selectedBegin;
    }

    public String getSelectedEnd() {
        if (this.selectedEnd == null) {
            this.selectedEnd = this.getRequestParameter("selectedEnd");
        }
        return this.selectedEnd;
    }

    public void setSelectedEnd(String selectedEnd) {
        this.selectedEnd = selectedEnd;
    }

    public List<FinalMark> getAlreadySubmitedMarks() throws FenixServiceException {
        if (this.alreadySubmitedMarks == null) {
            FinalEvaluation evaluation = (FinalEvaluation)((Object)this.getEvaluation());
            ExecutionCourse executionCourse = this.getExecutionCourse();
            this.alreadySubmitedMarks = evaluation.getAlreadySubmitedMarks(executionCourse);
            Collections.sort(this.alreadySubmitedMarks, new BeanComparator("attend.aluno.number"));
        }
        return this.alreadySubmitedMarks;
    }

    public List<Attends> getNotSubmitedMarks() throws FenixServiceException {
        if (this.notSubmitedMarks == null) {
            FinalEvaluation evaluation = (FinalEvaluation)((Object)this.getEvaluation());
            ExecutionCourse executionCourse = this.getExecutionCourse();
            this.notSubmitedMarks = evaluation.getNotSubmitedMarkAttends(executionCourse);
            Collections.sort(this.notSubmitedMarks, new BeanComparator("aluno.number"));
        }
        return this.notSubmitedMarks;
    }

    public String submitMarks() {
        HttpServletRequest request = this.getRequest();
        this.attendsIDs = request.getParameterValues("selectedMarks");
        if (this.attendsIDs == null || this.attendsIDs.length == 0) {
            this.setErrorMessage("error.noStudents.selected");
            return "";
        }
        this.getViewState().setAttribute("attendIDs", this.attendsIDs);
        return "enterSubmitMarksList2";
    }

    public String getSubmitEvaluationDateTextBoxValue() throws FenixServiceException {
        List<Exam> exams;
        if (this.submitEvaluationDateTextBoxValue == null && (exams = this.getExamList()) != null && !exams.isEmpty()) {
            Exam exam = exams.get(exams.size() - 1);
            this.submitEvaluationDateTextBoxValue = exam.getDayDateYearMonthDay().toString("dd/MM/yyyy");
        }
        return this.submitEvaluationDateTextBoxValue;
    }

    public void setSubmitEvaluationDateTextBoxValue(String submitEvaluationDateTextBoxValue) {
        this.submitEvaluationDateTextBoxValue = submitEvaluationDateTextBoxValue;
    }

    public HtmlInputText getSubmitEvaluationDateTextBox() {
        return this.submitEvaluationDateTextBox;
    }

    public void setSubmitEvaluationDateTextBox(HtmlInputText submitEvaluationDateTextBox) {
        this.submitEvaluationDateTextBox = submitEvaluationDateTextBox;
    }

    public List<SelectItem> getAvailableRooms() {
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        WrittenTest writtenTest = (WrittenTest)((Object)this.getEvaluation());
        Teacher teacher = AccessControl.getPerson().getTeacher();
        for (Space room : writtenTest.getAvailableRooms()) {
            SelectItem selectItem = new SelectItem((Object)room.getExternalId(), room.getName());
            selectItem.setDisabled(!writtenTest.canTeacherRemoveRoom(this.getExecutionCourse().getExecutionPeriod(), teacher, room));
            result.add(selectItem);
        }
        return result;
    }

    public String[] getRoomsToAssociate() {
        if (this.roomsToAssociate == null) {
            ArrayList<String> roomIds = new ArrayList<String>();
            for (Space room : ((WrittenTest)((Object)this.getEvaluation())).getAssociatedRooms()) {
                roomIds.add(room.getExternalId());
            }
            this.roomsToAssociate = roomIds.toArray(new String[0]);
        }
        return this.roomsToAssociate;
    }

    public void setRoomsToAssociate(String[] roomsToAssociate) {
        this.roomsToAssociate = roomsToAssociate;
    }

    public String editEvaluationRooms() throws FenixServiceException {
        TeacherEditWrittenTestRooms.runTeacherEditWrittenTestRooms(this.getExecutionCourse(), AccessControl.getPerson().getTeacher(), (WrittenTest)((Object)this.getEvaluation()), this.getRooms(this.getRoomsToAssociate()));
        this.setRoomsToAssociate(null);
        return "";
    }

    private List<Space> getRooms(String[] roomsToAssociate) {
        ArrayList<Space> rooms = new ArrayList<Space>();
        for (String roomId : roomsToAssociate) {
            Space space = (Space)FenixFramework.getDomainObject((String)roomId);
            if (space == null) {
                throw new IllegalArgumentException();
            }
            rooms.add(space);
        }
        return rooms;
    }

    public Map<String, Boolean> getCanManageRoomsMap() {
        return this.canManageRoomsMap;
    }

    public void setCanManageRoomsMap(Map<String, Boolean> canManageRoomsMap) {
        this.canManageRoomsMap = canManageRoomsMap;
    }

    public GradeScale getGradeScale() {
        if (this.gradeScale == null && this.getEvaluation() != null) {
            this.gradeScale = this.getEvaluation().getGradeScale();
        }
        return this.gradeScale;
    }

    public void setGradeScale(GradeScale gradeScale) {
        this.gradeScale = gradeScale;
    }

    public List<SelectItem> getGradeScaleOptions() {
        List<GradeScale> scales = GradeScale.getPublicGradeScales();
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (GradeScale s : scales) {
            items.add(new SelectItem((Object)s, BundleUtil.getString((String)"resources.EnumerationResources", (String)s.getName(), (String[])new String[0])));
        }
        return items;
    }

    public String getGradeScaleDescription() {
        GradeScale gradeScale = this.getGradeScale();
        if (gradeScale != null) {
            return this.getGradeScale().getPossibleValueDescription(this.getEvaluation().isFinal());
        }
        return "";
    }

    public void exportStudentsEnroledToExcel() throws FenixServiceException {
        this.exportToExcel();
    }

    private String getFileName(Date date) throws FenixServiceException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        int hour = calendar.get(11);
        int minutes = calendar.get(12);
        return day + "_" + month + "_" + year + "-" + hour + ":" + minutes;
    }

    public void exportToExcel() throws FenixServiceException {
        String filename = BundleUtil.getString((String)"resources.ApplicationResources", (String)"title.enrolments", (String[])new String[0]) + "-" + this.getFileName(Calendar.getInstance().getTime());
        try {
            this.exportToXls(filename.replace(" ", "_"));
        }
        catch (IOException e) {
            throw new FenixServiceException();
        }
    }

    private void exportToXls(String filename) throws IOException, FenixServiceException {
        this.getResponse().setContentType("application/vnd.ms-excel");
        this.getResponse().setHeader("Content-disposition", "attachment; filename=" + filename + ".xls");
        ServletOutputStream outputStream = this.getResponse().getOutputStream();
        String spreadSheetName = BundleUtil.getString((String)"resources.ApplicationResources", (String)"title.enrolments", (String[])new String[0]);
        List<Object> headers = this.getStudentsEnroledListHeaders();
        Spreadsheet spreadsheet = new Spreadsheet(spreadSheetName, headers);
        this.reportInfo(spreadsheet);
        spreadsheet.exportToXLSSheet((OutputStream)outputStream);
        outputStream.flush();
        this.getResponse().flushBuffer();
        FacesContext.getCurrentInstance().responseComplete();
    }

    private List<Object> getStudentsEnroledListHeaders() {
        ArrayList<Object> headers = new ArrayList<Object>();
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.username", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.number", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.room", (String[])new String[0]));
        headers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degree.name", (String[])new String[0]));
        return headers;
    }

    private void reportInfo(Spreadsheet spreadsheet) throws FenixServiceException {
        this.fillStudentsEnroled(spreadsheet);
    }

    private void fillStudentsEnroled(Spreadsheet spreadsheet) throws FenixServiceException {
        for (WrittenEvaluationEnrolment enrolment : this.getWrittenEvaluationEnrolments()) {
            Spreadsheet.Row newRow = spreadsheet.addRow();
            newRow.setCell(enrolment.getStudent().getPerson().getUsername());
            newRow.setCell(enrolment.getStudent().getNumber().toString());
            newRow.setCell(enrolment.getStudent().getPerson().getName());
            newRow.setCell(enrolment.getRoom() != null ? enrolment.getRoom().getName() : "-");
            newRow.setCell(enrolment.getStudent().getDegree().getNameI18N().getContent());
        }
    }

    public boolean getMixedGrades() {
        Evaluation evaluation = this.getEvaluation();
        GradeScale gradeScale = this.getGradeScale();
        if (gradeScale == null) {
            return false;
        }
        try {
            for (String mark : this.getMarks().values()) {
                if (gradeScale.isValid(mark, evaluation.getEvaluationType())) continue;
                return true;
            }
        }
        catch (FenixServiceException fenixServiceException) {
            // empty catch block
        }
        return false;
    }

    public List<SelectItem> getEnrolmentTypeFilterOptions() {
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        options.add(new SelectItem((Object)ENROLMENT_TYPE_FILTER_ALL, BundleUtil.getString((String)"resources.EnumerationResources", (String)"filter.all", (String[])new String[0])));
        for (EvaluationSeason season : EvaluationConfiguration.getInstance().getEvaluationSeasonSet()) {
            options.add(new SelectItem((Object)season.getExternalId(), season.getName().getContent()));
        }
        options.add(new SelectItem((Object)ENROLMENT_TYPE_FILTER_NOT_ENROLLED, BundleUtil.getString((String)"resources.EnumerationResources", (String)"filter.not.enrolled", (String[])new String[0])));
        return options;
    }

    public String getEnrolmentTypeFilter() {
        return this.enrolmentTypeFilter;
    }

    public void setEnrolmentTypeFilter(String filter) {
        this.enrolmentTypeFilter = filter;
    }

    public String filterByEnrolmentType() {
        this.marks.clear();
        return null;
    }

    private UIComponent findComponent(UIComponent c, String id) {
        if (id.equals(c.getId())) {
            return c;
        }
        Iterator childIt = c.getFacetsAndChildren();
        while (childIt.hasNext()) {
            UIComponent found = this.findComponent((UIComponent)childIt.next(), id);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void initializeEnrolmentFilter() {
        Map map = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        UIComponent filterComponent = this.findComponent((UIComponent)FacesContext.getCurrentInstance().getViewRoot(), "enrolmentFilter");
        if (filterComponent != null) {
            String clientId = filterComponent.getClientId(FacesContext.getCurrentInstance());
            this.enrolmentTypeFilter = (String)map.get(clientId);
        } else {
            this.enrolmentTypeFilter = ENROLMENT_TYPE_FILTER_ALL;
        }
    }

    public String sendEmailRequestRoom() {
        return (String)advice$sendEmailRequestRoom.perform((Callable)new EvaluationManagementBackingBean$callable$sendEmailRequestRoom(this));
    }

    static /* synthetic */ String advised$sendEmailRequestRoom(EvaluationManagementBackingBean this_) {
        GOPSendMessageService.requestRoom((WrittenTest)((Object)this_.getEvaluation()));
        return null;
    }
}

