/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3;

import com.google.common.base.Strings;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoLessonInstance;
import org.fenixedu.academic.dto.InfoLessonInstanceAggregation;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlot;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlotContentRenderer;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.LocalDate;

public class ClassTimeTableWithLinksLessonContentRenderer
extends LessonSlotContentRenderer {
    private String application;

    public ClassTimeTableWithLinksLessonContentRenderer(String application) {
        this.setApplication(application);
    }

    @Override
    public StringBuilder render(String context, LessonSlot lessonSlot) {
        StringBuilder strBuffer = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLesson) {
            InfoLesson lesson = (InfoLesson)showOccupation;
            InfoExecutionCourse infoExecutionCourse = lesson.getInfoShift().getInfoDisciplinaExecucao();
            String siteUrl = infoExecutionCourse.getExecutionCourse().getSiteUrl();
            if (Strings.isNullOrEmpty((String)siteUrl)) {
                strBuffer.append(infoExecutionCourse.getSigla());
            } else {
                strBuffer.append("<!-- NO_CHECKSUM -->");
                strBuffer.append("<a href=\"").append(context);
                strBuffer.append(siteUrl);
                strBuffer.append("\">");
                strBuffer.append(infoExecutionCourse.getSigla()).append("</a>");
            }
            strBuffer.append("&nbsp;").append("&nbsp;(").append(lesson.getInfoShift().getShiftTypesCodePrettyPrint()).append(")&nbsp;");
            Space allocatableSpace = lesson.getAllocatableSpace();
            if (allocatableSpace != null) {
                strBuffer.append(allocatableSpace.getName());
            }
            return strBuffer;
        }
        if (showOccupation instanceof InfoLessonInstance) {
            InfoLessonInstance lesson = (InfoLessonInstance)showOccupation;
            InfoExecutionCourse infoExecutionCourse = lesson.getInfoShift().getInfoDisciplinaExecucao();
            String siteUrl = infoExecutionCourse.getExecutionCourse().getSiteUrl();
            if (Strings.isNullOrEmpty((String)siteUrl)) {
                strBuffer.append(infoExecutionCourse.getSigla());
            } else {
                strBuffer.append("<!-- NO_CHECKSUM -->");
                strBuffer.append("<a href=\"").append(context);
                strBuffer.append(siteUrl);
                strBuffer.append("\">");
                strBuffer.append(infoExecutionCourse.getSigla()).append("</a>");
            }
            strBuffer.append("&nbsp;").append("&nbsp;(").append(lesson.getShiftTypeCodesPrettyPrint()).append(")&nbsp;");
            if (lesson.getInfoRoomOccupation() != null) {
                strBuffer.append(lesson.getInfoRoomOccupation().getInfoRoom().getNome());
            }
            return strBuffer;
        }
        if (showOccupation instanceof InfoLessonInstanceAggregation) {
            InfoLessonInstanceAggregation aggregation = (InfoLessonInstanceAggregation)showOccupation;
            ExecutionCourse executionCourse = aggregation.getShift().getExecutionCourse();
            String siteUrl = executionCourse.getSiteUrl();
            if (Strings.isNullOrEmpty((String)siteUrl)) {
                strBuffer.append(executionCourse.getSigla());
            } else {
                strBuffer.append("<!-- NO_CHECKSUM -->");
                strBuffer.append("<a href=\"").append(context);
                strBuffer.append(siteUrl);
                strBuffer.append("\">");
                strBuffer.append(executionCourse.getSigla()).append("</a>");
            }
            strBuffer.append("&nbsp;").append("&nbsp;(").append(aggregation.getShift().getShiftTypesCodePrettyPrint()).append(")&nbsp;");
            Space allocatableSpace = aggregation.getAllocatableSpace();
            if (allocatableSpace != null) {
                strBuffer.append(allocatableSpace.getName());
            }
            return strBuffer;
        }
        return new StringBuilder("");
    }

    @Override
    public String renderSecondLine(String context, LessonSlot lessonSlot) {
        InfoLessonInstanceAggregation infoLessonInstanceAggregation;
        StringBuilder builder = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLessonInstanceAggregation && !(infoLessonInstanceAggregation = (InfoLessonInstanceAggregation)showOccupation).availableInAllWeeks()) {
            builder.append("<span>");
            builder.append(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.weeks", (String[])new String[0]));
            builder.append(": &nbsp;&nbsp;");
            builder.append(infoLessonInstanceAggregation.prettyPrintWeeks());
            builder.append("&nbsp;");
            builder.append("</span>");
        }
        builder.append(super.renderSecondLine(context, lessonSlot));
        return builder.toString();
    }

    @Override
    public String renderTitleText(LessonSlot lessonSlot) {
        StringBuilder builder = new StringBuilder(super.renderTitleText(lessonSlot));
        InfoShowOccupation occupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (occupation instanceof InfoLessonInstanceAggregation) {
            InfoLessonInstanceAggregation aggregation = (InfoLessonInstanceAggregation)occupation;
            for (LocalDate localDate : aggregation.getDates()) {
                builder.append('\n');
                builder.append(localDate.toString("yyyy-MM-dd"));
            }
        }
        return builder.toString();
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }
}

