/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.department;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.dto.department.DegreeCourseStatisticsDTO;
import org.fenixedu.academic.service.services.department.ComputeCourseStatistics;
import org.fenixedu.academic.service.services.department.ComputeDegreeCourseStatistics$callable$runComputeDegreeCourseStatistics;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ComputeDegreeCourseStatistics
extends ComputeCourseStatistics {
    private static final ComputeDegreeCourseStatistics serviceInstance;
    public static final Advice advice$runComputeDegreeCourseStatistics;

    public List<DegreeCourseStatisticsDTO> run(CompetenceCourse competenceCourse, ExecutionSemester executionSemester) throws FenixServiceException {
        Map<Degree, List<CurricularCourse>> groupedCourses = competenceCourse.getAssociatedCurricularCoursesGroupedByDegree();
        ArrayList<DegreeCourseStatisticsDTO> results = new ArrayList<DegreeCourseStatisticsDTO>();
        for (Degree degree : groupedCourses.keySet()) {
            ArrayList<Enrolment> enrollments = new ArrayList<Enrolment>();
            List<CurricularCourse> curricularCourses = groupedCourses.get(degree);
            for (CurricularCourse curricularCourse : curricularCourses) {
                enrollments.addAll(curricularCourse.getActiveEnrollments(executionSemester));
            }
            DegreeCourseStatisticsDTO degreeCourseStatistics = new DegreeCourseStatisticsDTO();
            degreeCourseStatistics.setExternalId(degree.getExternalId());
            degreeCourseStatistics.setName(degree.getSigla());
            this.createCourseStatistics(degreeCourseStatistics, enrollments);
            results.add(degreeCourseStatistics);
        }
        return results;
    }

    public static List<DegreeCourseStatisticsDTO> runComputeDegreeCourseStatistics(CompetenceCourse competenceCourse, ExecutionSemester executionSemester) throws FenixServiceException {
        return (List)advice$runComputeDegreeCourseStatistics.perform((Callable)new ComputeDegreeCourseStatistics$callable$runComputeDegreeCourseStatistics(competenceCourse, executionSemester));
    }

    static /* synthetic */ List<DegreeCourseStatisticsDTO> advised$runComputeDegreeCourseStatistics(CompetenceCourse competenceCourse, ExecutionSemester executionSemester) throws FenixServiceException {
        return serviceInstance.run(competenceCourse, executionSemester);
    }

    static {
        advice$runComputeDegreeCourseStatistics = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        serviceInstance = new ComputeDegreeCourseStatistics();
    }
}

