/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter;

import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.SummariesManagementBean;
import org.fenixedu.academic.service.filter.AuthorizationByRoleFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixframework.FenixFramework;

public class ExecutionCourseLecturingTeacherAuthorizationFilter
extends AuthorizationByRoleFilter {
    public static final ExecutionCourseLecturingTeacherAuthorizationFilter instance = new ExecutionCourseLecturingTeacherAuthorizationFilter();

    @Override
    protected RoleType getRoleType() {
        return RoleType.TEACHER;
    }

    public void execute(String executionCourseCode) throws NotAuthorizedException {
        this.execute(this.getExecutionCourse(executionCourseCode));
    }

    public void execute(SummariesManagementBean executionCourseCode) throws NotAuthorizedException {
        this.execute(this.getExecutionCourse(executionCourseCode));
    }

    public void execute(ExecutionCourse executionCourse) throws NotAuthorizedException {
        User id = Authenticate.getUser();
        try {
            if (id == null || !this.lecturesExecutionCourse(id, executionCourse)) {
                throw new NotAuthorizedException();
            }
        }
        catch (RuntimeException e) {
            throw new NotAuthorizedException();
        }
    }

    private boolean lecturesExecutionCourse(User id, ExecutionCourse executionCourse) {
        if (executionCourse == null) {
            return false;
        }
        Person person = id.getPerson();
        if (person == null) {
            return false;
        }
        for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
            if (professorship.getPerson() != id.getPerson()) continue;
            return true;
        }
        return false;
    }

    private ExecutionCourse getExecutionCourse(Object argument) {
        if (argument == null) {
            return null;
        }
        if (argument instanceof ExecutionCourse) {
            return (ExecutionCourse)((Object)argument);
        }
        if (argument instanceof InfoExecutionCourse) {
            InfoExecutionCourse infoExecutionCourse = (InfoExecutionCourse)argument;
            return (ExecutionCourse)FenixFramework.getDomainObject((String)infoExecutionCourse.getExternalId());
        }
        if (argument instanceof String) {
            String executionCourseID = (String)argument;
            return (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
        }
        if (argument instanceof SummariesManagementBean) {
            return ((SummariesManagementBean)argument).getExecutionCourse();
        }
        return null;
    }
}

