/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.filter;

import java.util.Iterator;
import org.fenixedu.academic.domain.BibliographicReference;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.service.filter.AuthorizationByRoleFilter;
import org.fenixedu.academic.service.services.exceptions.NotAuthorizedException;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixframework.FenixFramework;

public class ExecutionCourseAndBibliographicReferenceLecturingTeacherAuthorizationFilter
extends AuthorizationByRoleFilter {
    public static final ExecutionCourseAndBibliographicReferenceLecturingTeacherAuthorizationFilter instance = new ExecutionCourseAndBibliographicReferenceLecturingTeacherAuthorizationFilter();

    @Override
    protected RoleType getRoleType() {
        return RoleType.TEACHER;
    }

    public void execute(String bibliographicReferenceID) throws NotAuthorizedException {
        User id = Authenticate.getUser();
        if (id == null || !this.getRoleType().isMember(id.getPerson().getUser()) || !this.bibliographicReferenceBelongsToTeacherExecutionCourse(id, bibliographicReferenceID)) {
            throw new NotAuthorizedException();
        }
    }

    private boolean bibliographicReferenceBelongsToTeacherExecutionCourse(User id, String bibliographicReferenceID) {
        if (bibliographicReferenceID == null) {
            return false;
        }
        boolean result = false;
        BibliographicReference bibliographicReference = (BibliographicReference)FenixFramework.getDomainObject((String)bibliographicReferenceID);
        Teacher teacher = Teacher.readTeacherByUsername(id.getUsername());
        if (bibliographicReference != null && teacher != null) {
            ExecutionCourse executionCourse = bibliographicReference.getExecutionCourse();
            Iterator<Professorship> associatedProfessorships = teacher.getProfessorshipsIterator();
            while (associatedProfessorships.hasNext()) {
                Professorship professorship = associatedProfessorships.next();
                if (!professorship.getExecutionCourse().equals((Object)executionCourse)) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

