/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.factoryExecutors;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.CourseGroupChangeRequest;
import org.fenixedu.academic.domain.serviceRequests.CustomServiceRequestRequest;
import org.fenixedu.academic.domain.serviceRequests.DuplicateRequest;
import org.fenixedu.academic.domain.serviceRequests.EquivalencePlanRequest;
import org.fenixedu.academic.domain.serviceRequests.EquivalencePlanRevisionRequest;
import org.fenixedu.academic.domain.serviceRequests.ExtraExamRequest;
import org.fenixedu.academic.domain.serviceRequests.FreeSolicitationAcademicRequest;
import org.fenixedu.academic.domain.serviceRequests.PartialRegistrationRegimeRequest;
import org.fenixedu.academic.domain.serviceRequests.SpecialSeasonRequest;
import org.fenixedu.academic.domain.serviceRequests.StudentReingressionRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.PhotocopyRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;
import org.fenixedu.academic.service.factoryExecutors.RegistrationAcademicServiceRequestCreator$callable$execute;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class RegistrationAcademicServiceRequestCreator
extends RegistrationAcademicServiceRequestCreateBean
implements FactoryExecutor {
    public static final Advice advice$execute = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public RegistrationAcademicServiceRequestCreator(Registration registration) {
        super(registration);
    }

    @Override
    public Object execute() {
        return advice$execute.perform((Callable)new RegistrationAcademicServiceRequestCreator$callable$execute(this));
    }

    static /* synthetic */ Object advised$execute(RegistrationAcademicServiceRequestCreator this_) {
        Object result;
        if (!this_.getChosenServiceRequestType().isLegacy()) {
            result = CustomServiceRequestRequest.create(this_);
        } else {
            switch (this_.getChosenServiceRequestType().getAcademicServiceRequestType()) {
                case REINGRESSION: {
                    result = new StudentReingressionRequest(this_);
                    break;
                }
                case EQUIVALENCE_PLAN: {
                    result = new EquivalencePlanRequest(this_);
                    break;
                }
                case REVISION_EQUIVALENCE_PLAN: {
                    result = new EquivalencePlanRevisionRequest(this_);
                    break;
                }
                case COURSE_GROUP_CHANGE_REQUEST: {
                    this_.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
                    result = new CourseGroupChangeRequest(this_);
                    break;
                }
                case EXTRA_EXAM_REQUEST: {
                    this_.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
                    result = new ExtraExamRequest(this_);
                    break;
                }
                case FREE_SOLICITATION_ACADEMIC_REQUEST: {
                    result = new FreeSolicitationAcademicRequest(this_);
                    break;
                }
                case SPECIAL_SEASON_REQUEST: {
                    result = new SpecialSeasonRequest(this_);
                    break;
                }
                case PHOTOCOPY_REQUEST: {
                    this_.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
                    result = new PhotocopyRequest(this_);
                    break;
                }
                case PARTIAL_REGIME_REQUEST: {
                    result = new PartialRegistrationRegimeRequest(this_);
                    break;
                }
                case DUPLICATE_REQUEST: {
                    result = new DuplicateRequest(this_);
                    break;
                }
                default: {
                    throw new DomainException("error.RegistrationAcademicServiceRequestCreator.no.executor", new String[0]);
                }
            }
        }
        Signal.emit((String)"ACADEMIC_SERVICE_REQUEST_NEW_SITUATION_EVENT", (Object)new DomainObjectEvent((DomainObject)result));
        return result;
    }
}

