/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.transactions;

import org.fenixedu.academic.domain.transactions.GratuityTransaction;
import org.fenixedu.academic.domain.transactions.InsuranceTransaction;
import org.fenixedu.academic.domain.transactions.PaymentTransaction;
import org.fenixedu.academic.domain.transactions.Transaction;
import org.fenixedu.academic.dto.InfoGuideEntry;
import org.fenixedu.academic.dto.transactions.InfoGratuityTransaction;
import org.fenixedu.academic.dto.transactions.InfoInsuranceTransaction;
import org.fenixedu.academic.dto.transactions.InfoTransaction;

public abstract class InfoPaymentTransaction
extends InfoTransaction {
    private InfoGuideEntry infoGuideEntry;

    public static InfoPaymentTransaction newInfoFromDomain(PaymentTransaction paymentTransaction) {
        if (paymentTransaction == null) {
            return null;
        }
        InfoPaymentTransaction infoPaymentTransaction = null;
        if (paymentTransaction instanceof GratuityTransaction) {
            infoPaymentTransaction = InfoGratuityTransaction.newInfoFromDomain((GratuityTransaction)((Object)paymentTransaction));
        } else if (paymentTransaction instanceof InsuranceTransaction) {
            infoPaymentTransaction = InfoInsuranceTransaction.newInfoFromDomain((InsuranceTransaction)((Object)paymentTransaction));
        }
        return infoPaymentTransaction;
    }

    protected void copyFromDomain(PaymentTransaction paymentTransaction) {
        super.copyFromDomain((Transaction)((Object)paymentTransaction));
        InfoGuideEntry infoGuideEntry = null;
        if (paymentTransaction.getGuideEntry() != null) {
            infoGuideEntry = InfoGuideEntry.newInfoFromDomain(paymentTransaction.getGuideEntry());
        }
        this.infoGuideEntry = infoGuideEntry;
    }

    public InfoGuideEntry getInfoGuideEntry() {
        return this.infoGuideEntry;
    }

    public void setInfoGuideEntry(InfoGuideEntry infoGuideEntry) {
        this.infoGuideEntry = infoGuideEntry;
    }
}

