/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.person;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.service.services.person.PersonSearcher;

public class SimpleSearchPersonWithStudentBean
implements Serializable {
    private String name;
    private String username;
    private String documentIdNumber;
    private IDDocumentType idDocumentType;
    private Integer studentNumber;
    private String paymentCode;

    public String getDocumentIdNumber() {
        return this.documentIdNumber;
    }

    public void setDocumentIdNumber(String documentIdNumber) {
        this.documentIdNumber = documentIdNumber;
    }

    public IDDocumentType getIdDocumentType() {
        return this.idDocumentType;
    }

    public void setIdDocumentType(IDDocumentType idDocumentType) {
        this.idDocumentType = idDocumentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(Integer studentNumber) {
        this.studentNumber = studentNumber;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPaymentCode() {
        return this.paymentCode;
    }

    public void setPaymentCode(String paymentCode) {
        this.paymentCode = paymentCode;
    }

    public Collection<Person> search() {
        Student student;
        if (this.studentNumber != null && (student = Student.readStudentByNumber(this.studentNumber)) != null) {
            return Stream.of(student.getPerson()).collect(Collectors.toSet());
        }
        Stream<Person> stream = new PersonSearcher().name(this.name).username(this.username).documentIdNumber(this.documentIdNumber).documentIdType(this.idDocumentType).search();
        if (!Strings.isNullOrEmpty((String)this.paymentCode)) {
            stream = stream.filter(p -> p.getPaymentCodeBy(this.paymentCode) != null);
        }
        return stream.collect(Collectors.toSet());
    }
}

