/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.administrativeOffice.dismissal;

import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;

public class InternalSubstitutionDismissalBean
extends DismissalBean {
    private static final long serialVersionUID = 1L;

    @Override
    public Collection<? extends CurricularCourse> getAllCurricularCoursesToDismissal() {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        StudentCurricularPlan scp = this.getStudentCurricularPlan();
        Collection<CycleType> cyclesToEnrol = scp.getDegreeType().getSupportedCyclesToEnrol();
        if (cyclesToEnrol.isEmpty()) {
            for (CurricularCourse curricularCourse : scp.getDegreeCurricularPlan().getCurricularCoursesSet()) {
                if (!curricularCourse.isActive(this.getExecutionPeriod()) || this.isApproved(scp, curricularCourse)) continue;
                result.add(curricularCourse);
            }
        } else {
            for (CycleType cycleType : cyclesToEnrol) {
                CourseGroup courseGroup = this.getCourseGroupWithCycleTypeToCollectCurricularCourses(scp, cycleType);
                if (courseGroup == null) continue;
                for (CurricularCourse curricularCourse : courseGroup.getAllCurricularCourses(this.getExecutionPeriod())) {
                    if (this.isApproved(scp, curricularCourse)) continue;
                    result.add(curricularCourse);
                }
            }
        }
        return result;
    }

    private boolean isApproved(StudentCurricularPlan studentCurricularPlan, CurricularCourse curricularCourse) {
        for (Enrolment enrolment : studentCurricularPlan.getEnrolmentsSet()) {
            if (!enrolment.getCurricularCourse().isEquivalent(curricularCourse) || !enrolment.isApproved()) continue;
            return true;
        }
        return false;
    }

    private CourseGroup getCourseGroupWithCycleTypeToCollectCurricularCourses(StudentCurricularPlan studentCurricularPlan, CycleType cycleType) {
        CycleCurriculumGroup curriculumGroup = studentCurricularPlan.getCycle(cycleType);
        return curriculumGroup != null ? curriculumGroup.getDegreeModule() : studentCurricularPlan.getDegreeCurricularPlan().getCycleCourseGroup(cycleType);
    }
}

