/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Calendar;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.dto.InfoObject;

public class InfoPeriod
extends InfoObject {
    protected Calendar startDate;
    protected Calendar endDate;
    protected InfoPeriod nextPeriod;

    public InfoPeriod() {
    }

    public InfoPeriod(Calendar startSeason1, Calendar endSeason2) {
        this.setStartDate(startSeason1);
        this.setEndDate(endSeason2);
    }

    public InfoPeriod getNextPeriod() {
        return this.nextPeriod;
    }

    public void setNextPeriod(InfoPeriod nextPeriod) {
        this.nextPeriod = nextPeriod;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public void copyFromDomain(OccupationPeriod period) {
        if (period != null) {
            this.setStartDate(period.getStartDate());
            this.setEndDate(period.getEndDate());
            this.setExternalId(period.getExternalId());
            if (period.getNextPeriod() != null) {
                InfoPeriod infoPeriod = new InfoPeriod();
                infoPeriod.copyFromDomain(period.getNextPeriod());
                this.setNextPeriod(infoPeriod);
            }
        }
    }

    public static InfoPeriod newInfoFromDomain(OccupationPeriod period) {
        InfoPeriod infoPeriod = null;
        if (period != null) {
            infoPeriod = new InfoPeriod();
            infoPeriod.copyFromDomain(period);
        }
        return infoPeriod;
    }

    public Calendar endDateOfComposite() {
        Calendar end = this.endDate;
        for (InfoPeriod period = this.nextPeriod; period != null; period = period.getNextPeriod()) {
            end = period.getEndDate();
        }
        return end;
    }
}

