/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.curriculum.CurricularCourseType;
import org.fenixedu.academic.domain.degreeStructure.RegimeType;
import org.fenixedu.academic.dto.InfoBranch;
import org.fenixedu.academic.dto.InfoCurricularCourseScope;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoUniversity;
import org.fenixedu.academic.util.CurricularCourseExecutionScope;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixframework.DomainObject;

public class InfoCurricularCourse
extends InfoObject
implements Comparable {
    public static final Comparator<InfoCurricularCourse> COMPARATOR_BY_NAME_AND_ID = new Comparator<InfoCurricularCourse>(){

        @Override
        public int compare(InfoCurricularCourse o1, InfoCurricularCourse o2) {
            int result = Collator.getInstance().compare(o1.getName(), o2.getName());
            return result == 0 ? o1.getExternalId().compareTo(o2.getExternalId()) : result;
        }
    };
    private final CurricularCourse curricularCourse;
    private final boolean showEnVersion = I18N.getLocale().equals(MultiLanguageString.en);
    private List<InfoCurricularCourseScope> infoScopes;
    private List infoAssociatedExecutionCourses;
    private InfoUniversity infoUniversity;
    private String chosen;

    public InfoCurricularCourse(CurricularCourse curricularCourse) {
        this.curricularCourse = curricularCourse;
    }

    public CurricularCourse getCurricularCourse() {
        return this.curricularCourse;
    }

    public Boolean getBasic() {
        return this.getCurricularCourse().getBasic();
    }

    public String getOwnershipType() {
        return this.getBasic() == null ? "" : (this.getBasic() != false ? "B\u00e1sica" : "N\u00e3o B\u00e1sica");
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof InfoCurricularCourse && this.getCurricularCourse() == ((InfoCurricularCourse)obj).getCurricularCourse();
    }

    public String toString() {
        return this.getCurricularCourse().toString();
    }

    public String getCode() {
        return this.getCurricularCourse().getCode();
    }

    public Double getCredits() {
        return this.getCurricularCourse().getCredits();
    }

    public Double getLabHours() {
        return this.getCurricularCourse().getLabHours();
    }

    public Double getPraticalHours() {
        return this.getCurricularCourse().getPraticalHours();
    }

    public Double getTheoPratHours() {
        return this.getCurricularCourse().getTheoPratHours();
    }

    public Double getTheoreticalHours() {
        return this.getCurricularCourse().getTheoreticalHours();
    }

    public Double getFieldWorkHours() {
        return this.getCurricularCourse().getFieldWorkHours();
    }

    public Double getProblemsHours() {
        return this.getCurricularCourse().getProblemsHours();
    }

    public Double getSeminaryHours() {
        return this.getCurricularCourse().getSeminaryHours();
    }

    public Double getTrainingPeriodHours() {
        return this.getCurricularCourse().getTrainingPeriodHours();
    }

    public Double getTutorialOrientationHours() {
        return this.getCurricularCourse().getTutorialOrientationHours();
    }

    public Double getTotalLabHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.LABORATORIAL, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public Double getTotalPraticalHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.PRATICA, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public Double getTotalTheoPratHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.TEORICO_PRATICA, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public Double getTotalTheoreticalHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.TEORICA, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public Double getTotalFieldWorkHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.FIELD_WORK, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public Double getTotalProblemsHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.PROBLEMS, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public Double getTotalSeminaryHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.SEMINARY, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public Double getTotalTrainingPeriodHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.TRAINING_PERIOD, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public Double getTotalTutorialOrientationHours() {
        BigDecimal totalHours = this.getCurricularCourse().getTotalHoursByShiftType(ShiftType.TUTORIAL_ORIENTATION, null);
        return totalHours != null ? totalHours.doubleValue() : 0.0;
    }

    public InfoDegreeCurricularPlan getInfoDegreeCurricularPlan() {
        return InfoDegreeCurricularPlan.newInfoFromDomain(this.getCurricularCourse().getDegreeCurricularPlan());
    }

    public List<InfoCurricularCourseScope> getInfoScopes() {
        return this.infoScopes;
    }

    public void setInfoScopes(List<InfoCurricularCourseScope> infoScopes) {
        this.infoScopes = infoScopes;
    }

    public CurricularCourseType getType() {
        return this.getCurricularCourse().getType();
    }

    public CurricularCourseExecutionScope getCurricularCourseExecutionScope() {
        return this.getCurricularCourse().getCurricularCourseExecutionScope();
    }

    public Boolean getMandatory() {
        return this.getCurricularCourse().getMandatory();
    }

    public boolean infoCurricularCourseIsMandatory() {
        return this.getMandatory();
    }

    public InfoCurricularCourseScope getInfoCurricularCourseScope(InfoBranch infoBranch, Integer semester) {
        InfoCurricularCourseScope infoCurricularCourseScope = null;
        for (InfoCurricularCourseScope infoCurricularCourseScope2 : this.getInfoScopes()) {
            if (!infoCurricularCourseScope2.getInfoBranch().equals(infoBranch) || !infoCurricularCourseScope2.getInfoCurricularSemester().getSemester().equals(semester)) continue;
            infoCurricularCourseScope = infoCurricularCourseScope2;
            break;
        }
        return infoCurricularCourseScope;
    }

    public InfoUniversity getInfoUniversity() {
        return this.infoUniversity;
    }

    public void setInfoUniversity(InfoUniversity university) {
        this.infoUniversity = university;
    }

    public int compareTo(Object arg0) {
        int result = 0;
        if (this.getMinScope() < ((InfoCurricularCourse)arg0).getMinScope()) {
            result = -1;
        } else if (this.getMinScope() > ((InfoCurricularCourse)arg0).getMinScope()) {
            return 1;
        }
        return result;
    }

    private int getMinScope() {
        int minScope = 0;
        List<InfoCurricularCourseScope> scopes = this.getInfoScopes();
        for (InfoCurricularCourseScope infoScope : scopes) {
            if (minScope != 0 && minScope <= infoScope.getInfoCurricularSemester().getInfoCurricularYear().getYear()) continue;
            minScope = infoScope.getInfoCurricularSemester().getInfoCurricularYear().getYear();
        }
        return minScope;
    }

    public List getInfoAssociatedExecutionCourses() {
        return this.infoAssociatedExecutionCourses;
    }

    public void setInfoAssociatedExecutionCourses(List infoAssociatedExecutionCourses) {
        this.infoAssociatedExecutionCourses = infoAssociatedExecutionCourses;
    }

    public String getChosen() {
        return this.chosen;
    }

    public void setChosen(String chosen) {
        this.chosen = chosen;
    }

    public Double getEctsCredits() {
        return this.getCurricularCourse().getEctsCredits();
    }

    public Integer getEnrollmentWeigth() {
        return this.getCurricularCourse().getEnrollmentWeigth();
    }

    public Integer getMaximumValueForAcumulatedEnrollments() {
        return this.getCurricularCourse().getMaximumValueForAcumulatedEnrollments();
    }

    public Integer getMinimumValueForAcumulatedEnrollments() {
        return this.getCurricularCourse().getMinimumValueForAcumulatedEnrollments();
    }

    public Double getWeigth() {
        return this.getCurricularCourse().getWeigth();
    }

    public Boolean getMandatoryEnrollment() {
        return this.getCurricularCourse().getMandatoryEnrollment();
    }

    public Boolean getEnrollmentAllowed() {
        return this.getCurricularCourse().getEnrollmentAllowed();
    }

    public String getAcronym() {
        return this.getCurricularCourse().getAcronym();
    }

    public static InfoCurricularCourse newInfoFromDomain(CurricularCourse curricularCourse) {
        InfoCurricularCourse infoCurricularCourse = null;
        if (curricularCourse != null) {
            infoCurricularCourse = new InfoCurricularCourse(curricularCourse);
            infoCurricularCourse.copyFromDomain((DomainObject)curricularCourse);
        }
        return infoCurricularCourse;
    }

    public String getName() {
        return this.showEnVersion && this.getCurricularCourse().getNameEn() != null && this.getCurricularCourse().getNameEn().length() > 0 ? this.getCurricularCourse().getNameEn() : this.getCurricularCourse().getName();
    }

    public String getNameEn() {
        return this.getCurricularCourse().getNameEn();
    }

    public String getNameAndCode() {
        return this.getCode() + " - " + this.getName();
    }

    public GradeScale getGradeScale() {
        return this.getCurricularCourse().getGradeScale();
    }

    @Override
    public String getExternalId() {
        return this.getCurricularCourse().getExternalId();
    }

    public RegimeType getRegimeType() {
        return this.getCurricularCourse().getRegimeType();
    }
}

