/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.time.chronologies;

import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicCalendarRootEntry;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicSemesterCE;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicTrimesterCE;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicYearCE;
import org.fenixedu.academic.domain.time.chronologies.dateTimeFields.AcademicSemesterDateTimeField;
import org.fenixedu.academic.domain.time.chronologies.dateTimeFields.AcademicSemesterOfAcademicYearDateTimeField;
import org.fenixedu.academic.domain.time.chronologies.dateTimeFields.AcademicTrimesterDateTimeField;
import org.fenixedu.academic.domain.time.chronologies.dateTimeFields.AcademicYearDateTimeField;
import org.fenixedu.academic.domain.time.chronologies.dateTimeFields.DayOfAcademicSemesterDateTimeField;
import org.fenixedu.academic.domain.time.chronologies.durationFields.AcademicSemestersDurationField;
import org.fenixedu.academic.domain.time.chronologies.durationFields.AcademicTrimesterDurationField;
import org.fenixedu.academic.domain.time.chronologies.durationFields.AcademicYearsDurationField;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.ISOChronology;

public class AcademicChronology
extends AssembledChronology {
    private transient AcademicCalendarRootEntry academicCalendar;
    private transient DurationField acAcademicYearsField;
    private transient DurationField acAcademicSemestersField;
    private transient DurationField acAcademicTrimestersField;
    private transient DateTimeField acAcademicYear;
    private transient DateTimeField acAcademicSemester;
    private transient DateTimeField acAcademicSemesterOfAcademicYear;
    private transient DateTimeField acDayOfAcademicSemester;
    private transient DateTimeField acAcademicTrimester;
    private static final ISOChronology ISO_INSTANCE = ISOChronology.getInstance();

    public AcademicChronology(AcademicCalendarRootEntry academicCalendar) {
        super((Chronology)ISO_INSTANCE, null);
        this.academicCalendar = academicCalendar;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.acAcademicYearsField == null) {
            this.acAcademicYearsField = new AcademicYearsDurationField(this);
            this.acAcademicYear = new AcademicYearDateTimeField((Chronology)this);
            this.acAcademicTrimester = new AcademicTrimesterDateTimeField((Chronology)this);
            this.acAcademicTrimestersField = new AcademicTrimesterDurationField((Chronology)this);
            this.acAcademicSemester = new AcademicSemesterDateTimeField((Chronology)this);
            this.acAcademicSemestersField = new AcademicSemestersDurationField(this);
            this.acAcademicSemesterOfAcademicYear = new AcademicSemesterOfAcademicYearDateTimeField((Chronology)this);
            this.acDayOfAcademicSemester = new DayOfAcademicSemesterDateTimeField((Chronology)this);
        }
    }

    public Chronology withUTC() {
        return ISOChronology.getInstanceUTC();
    }

    public Chronology withZone(DateTimeZone zone) {
        return ISO_INSTANCE.withZone(zone);
    }

    public String toString() {
        String str = "AcademicChronology";
        DateTimeZone zone = this.getZone();
        if (zone != null) {
            str = str + '[' + zone.getID() + ']';
        }
        return str;
    }

    public DateTimeField academicYear() {
        return this.acAcademicYear;
    }

    public DateTimeField academicSemester() {
        return this.acAcademicSemester;
    }

    public DateTimeField academicTrimester() {
        return this.acAcademicTrimester;
    }

    public DateTimeField academicSemesterOfAcademicYear() {
        return this.acAcademicSemesterOfAcademicYear;
    }

    public DateTimeField dayOfAcademicSemester() {
        return this.acDayOfAcademicSemester;
    }

    public DurationField academicYears() {
        return this.acAcademicYearsField;
    }

    public DurationField academicSemesters() {
        return this.acAcademicSemestersField;
    }

    public DurationField academicTrimesters() {
        return this.acAcademicTrimestersField;
    }

    public AcademicSemesterCE getAcademicSemesterIn(int index) {
        return (AcademicSemesterCE)((Object)this.academicCalendar.getEntryByIndex(index, AcademicSemesterCE.class, AcademicYearCE.class));
    }

    public AcademicYearCE getAcademicYearIn(int index) {
        return (AcademicYearCE)((Object)this.academicCalendar.getEntryByIndex(index, AcademicYearCE.class, AcademicCalendarRootEntry.class));
    }

    public int getAcademicTrimester(long instant) {
        Integer entryValueByInstant = this.academicCalendar.getEntryIndexByInstant(instant, AcademicTrimesterCE.class, AcademicSemesterCE.class);
        if (entryValueByInstant != null) {
            return entryValueByInstant;
        }
        return 0;
    }

    public int getAcademicSemester(long instant) {
        Integer entryValueByInstant = this.academicCalendar.getEntryIndexByInstant(instant, AcademicSemesterCE.class, AcademicYearCE.class);
        if (entryValueByInstant != null) {
            return entryValueByInstant;
        }
        return 0;
    }

    public int getAcademicYear(long instant) {
        Integer entryValueByInstant = this.academicCalendar.getEntryIndexByInstant(instant, AcademicYearCE.class, AcademicCalendarRootEntry.class);
        if (entryValueByInstant != null) {
            return entryValueByInstant;
        }
        return 0;
    }

    public int getDayOfAcademicSemester(long instant) {
        AcademicCalendarEntry entryByInstant = this.academicCalendar.getEntryByInstant(instant, AcademicSemesterCE.class, AcademicYearCE.class);
        if (entryByInstant != null) {
            DateTime instantDateTime = new DateTime(instant);
            Interval interval = new Interval((ReadableInstant)entryByInstant.getBegin(), (ReadableInstant)instantDateTime);
            int days = interval.toPeriod().getDays();
            if (days > 0) {
                return days;
            }
        }
        return 0;
    }

    public int getAcademicSemesterOfAcademicYear(long instant) {
        AcademicSemesterCE entryByInstant = (AcademicSemesterCE)((Object)this.academicCalendar.getEntryByInstant(instant, AcademicSemesterCE.class, AcademicYearCE.class));
        return entryByInstant.getAcademicSemesterOfAcademicYear(this);
    }

    public int getMaximumValueForAcademicSemesterOfAcademicYear(long instant) {
        int academicSemesterOfAcademicYear = this.getAcademicSemesterOfAcademicYear(instant);
        if (academicSemesterOfAcademicYear == 0) {
            return this.getMaximumValueForAcademicSemesterOfAcademicYear();
        }
        return this.getMaximumValueForAcademicSemesterOfAcademicYear() - academicSemesterOfAcademicYear;
    }

    public int getMaximumValueForAcademicSemesterOfAcademicYear() {
        return 2;
    }

    public AcademicCalendarEntry findSameEntry(AcademicCalendarEntry entry) {
        return entry.getEntryForCalendar(this.academicCalendar);
    }
}

