/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.events.AccountingEventsManager;
import org.fenixedu.academic.domain.accounting.events.AdministrativeOfficeFeeAndInsuranceEvent;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.PersonalInformationBean;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithInvocationResult;
import org.fenixedu.academic.domain.log.CurriculumLineLog;
import org.fenixedu.academic.domain.messaging.ExecutionCourseForum;
import org.fenixedu.academic.domain.messaging.Forum;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.ResidenceCandidacies;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student$callable$acceptRegistrationsFromOtherStudent;
import org.fenixedu.academic.domain.student.StudentDataByExecutionYear;
import org.fenixedu.academic.domain.student.StudentDataShareAuthorization;
import org.fenixedu.academic.domain.student.StudentDataShareStudentsAssociationAuthorization;
import org.fenixedu.academic.domain.student.StudentNumber;
import org.fenixedu.academic.domain.student.StudentNumber_Base;
import org.fenixedu.academic.domain.student.StudentStatute;
import org.fenixedu.academic.domain.student.Student_Base;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.academic.dto.student.StudentStatuteBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.StudentPredicates;
import org.fenixedu.academic.util.InvocationResult;
import org.fenixedu.academic.util.StudentPersonalDataAuthorizationChoice;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.UserLoginPeriod;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Student
extends Student_Base {
    public static final Comparator<Student> NAME_COMPARATOR;
    public static final Comparator<Student> NUMBER_COMPARATOR;
    public static final Advice advice$acceptRegistrationsFromOtherStudent;

    public Student(Person person, Integer number) {
        this.setPerson(person);
        if (number == null || Student.readStudentByNumber(number) != null) {
            number = Student.generateStudentNumber();
        }
        this.setNumber(number);
        this.setRootDomainObject(Bennu.getInstance());
    }

    public static Student createStudentWithCustomNumber(Person person, Integer number) {
        if (number == null) {
            return new Student(person, null);
        }
        if (Student.readStudentByNumber(number) != null) {
            throw new DomainException("error.custom.student.creation.student.number.already.set", new String[0]);
        }
        if (number >= Student.generateStudentNumber()) {
            throw new DomainException("error.custom.student.creation.student.number.higher.than.generated", new String[0]);
        }
        Student student = new Student(person, number);
        student.setNumber(number);
        return student;
    }

    public Student(Person person) {
        this(person, null);
    }

    public static Student readStudentByNumber(Integer number) {
        return Bennu.getInstance().getStudentNumbersSet().stream().filter(sn -> sn.getNumber().equals(number)).map(StudentNumber_Base::getStudent).findAny().orElse(null);
    }

    public String getName() {
        return this.getPerson().getName();
    }

    public Collection<Registration> getRegistrationsMatchingDegreeType(java.util.function.Predicate<DegreeType> predicate) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!predicate.test(registration.getDegreeType())) continue;
            result.add(registration);
        }
        return result;
    }

    public boolean hasAnyRegistration(DegreeType degreeType) {
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.getDegreeType().equals(degreeType)) continue;
            return true;
        }
        return false;
    }

    public Registration readRegistrationByDegreeCurricularPlan(DegreeCurricularPlan degreeCurricularPlan) {
        for (Registration registration : this.getRegistrationsSet()) {
            StudentCurricularPlan studentCurricularPlan = registration.getStudentCurricularPlan(degreeCurricularPlan);
            if (studentCurricularPlan == null) continue;
            return registration;
        }
        return null;
    }

    public Registration readRegistrationByDegree(Degree degree) {
        for (Registration registration : this.getRegistrationsSet()) {
            if (registration.getDegree() != degree) continue;
            return registration;
        }
        return null;
    }

    public Collection<Registration> getRegistrationsByDegreeTypeAndExecutionPeriod(DegreeType degreeType, ExecutionSemester executionSemester) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.getDegreeType().equals(degreeType) || !registration.hasStudentCurricularPlanInExecutionPeriod(executionSemester)) continue;
            result.add(registration);
        }
        return result;
    }

    public Collection<Registration> getRegistrationsByDegreeTypes(DegreeType ... degreeTypes) {
        List<DegreeType> degreeTypesList = Arrays.asList(degreeTypes);
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!degreeTypesList.contains(registration.getDegreeType())) continue;
            result.add(registration);
        }
        return result;
    }

    public List<Registration> getActiveRegistrations() {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.isActive()) continue;
            result.add(registration);
        }
        return result;
    }

    public List<Registration> getConcludedRegistrations() {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.isRegistrationConclusionProcessed()) continue;
            result.add(registration);
        }
        return result;
    }

    public List<Registration> getActiveRegistrationsIn(ExecutionSemester executionSemester) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.hasActiveLastState(executionSemester)) continue;
            result.add(registration);
        }
        return result;
    }

    public Registration getLastActiveRegistration() {
        List<Registration> activeRegistrations = this.getActiveRegistrations();
        return activeRegistrations.isEmpty() ? null : Collections.max(activeRegistrations, Registration.COMPARATOR_BY_START_DATE);
    }

    public Registration getLastConcludedRegistration() {
        List<Registration> concludedRegistrations = this.getConcludedRegistrations();
        return concludedRegistrations.isEmpty() ? null : Collections.max(concludedRegistrations, Registration.COMPARATOR_BY_START_DATE);
    }

    public Registration getLastRegistration() {
        Set<Registration> activeRegistrations = this.getRegistrationsSet();
        return activeRegistrations.isEmpty() ? null : Collections.max(activeRegistrations, Registration.COMPARATOR_BY_START_DATE);
    }

    public boolean hasActiveRegistrationForDegreeType(DegreeType degreeType, ExecutionYear executionYear) {
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.hasAnyEnrolmentsIn(executionYear) || registration.getDegreeType() != degreeType) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyRegistrationInState(RegistrationStateType stateType) {
        for (Registration registration : this.getRegistrationsSet()) {
            if (registration.getActiveStateType() != stateType) continue;
            return true;
        }
        return false;
    }

    public boolean hasSpecialSeasonEnrolments(ExecutionSemester executionSemester) {
        for (Registration registration : this.getRegistrationsSet()) {
            if (!executionSemester.getExecutionYear().isAfter(registration.getStartExecutionYear()) || !registration.getStudentCurricularPlan(executionSemester).isEnroledInSpecialSeason(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public static Integer generateStudentNumber() {
        int nextNumber = 0;
        for (StudentNumber studentNumber : Bennu.getInstance().getStudentNumbersSet()) {
            if (studentNumber.getNumber() <= nextNumber) continue;
            nextNumber = studentNumber.getNumber();
        }
        return nextNumber + 1;
    }

    public ResidenceCandidacies getResidenceCandidacyForCurrentExecutionYear() {
        if (this.getActualExecutionYearStudentData() == null) {
            return null;
        }
        return this.getActualExecutionYearStudentData().getResidenceCandidacy();
    }

    public void setResidenceCandidacyForCurrentExecutionYear(String observations) {
        this.createCurrentYearStudentData();
        this.getActualExecutionYearStudentData().setResidenceCandidacy(new ResidenceCandidacies(observations));
    }

    public void setResidenceCandidacy(ResidenceCandidacies residenceCandidacy) {
        ExecutionYear executionYear = ExecutionYear.getExecutionYearByDate(residenceCandidacy.getCreationDateDateTime().toYearMonthDay());
        StudentDataByExecutionYear studentData = this.getStudentDataByExecutionYear(executionYear);
        if (studentData == null) {
            studentData = this.createStudentDataForExecutionYear(executionYear);
        }
        studentData.setResidenceCandidacy(residenceCandidacy);
    }

    public boolean getWorkingStudentForCurrentExecutionYear() {
        if (this.getActualExecutionYearStudentData() == null) {
            return false;
        }
        return this.getActualExecutionYearStudentData().getWorkingStudent();
    }

    public void setWorkingStudentForCurrentExecutionYear() {
        this.createCurrentYearStudentData();
        this.getActualExecutionYearStudentData().setWorkingStudent(true);
    }

    public StudentPersonalDataAuthorizationChoice getPersonalDataAuthorization() {
        return this.getActivePersonalDataAuthorization() == null ? null : this.getActivePersonalDataAuthorization().getAuthorizationChoice();
    }

    public void setPersonalDataAuthorization(StudentPersonalDataAuthorizationChoice authorization) {
        new StudentDataShareAuthorization(this, authorization);
    }

    public void setStudentPersonalDataStudentsAssociationAuthorization(StudentPersonalDataAuthorizationChoice authorization) {
        new StudentDataShareStudentsAssociationAuthorization(this, authorization);
    }

    public StudentDataShareStudentsAssociationAuthorization getStudentPersonalDataStudentsAssociationAuthorization() {
        for (StudentDataShareAuthorization shareAuthorization : this.getStudentDataShareAuthorizationSet()) {
            if (!(shareAuthorization instanceof StudentDataShareStudentsAssociationAuthorization)) continue;
            return (StudentDataShareStudentsAssociationAuthorization)((Object)shareAuthorization);
        }
        return null;
    }

    public boolean hasFilledAuthorizationInformationInCurrentExecutionYear() {
        return this.getActivePersonalDataAuthorization() != null && this.getActivePersonalDataAuthorization().getSince().isAfter((ReadableInstant)this.getCurrentExecutionYearDate().getBeginDateYearMonthDay().toDateTimeAtMidnight());
    }

    private ExecutionYear getCurrentExecutionYearDate() {
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (currentExecutionYear.getBeginDateYearMonthDay().isAfter((ReadablePartial)new LocalDate())) {
            return currentExecutionYear.getPreviousExecutionYear();
        }
        return currentExecutionYear;
    }

    public StudentDataShareAuthorization getActivePersonalDataAuthorization() {
        return this.getPersonalDataAuthorizationAt(new DateTime());
    }

    public StudentDataShareAuthorization getPersonalDataAuthorizationAt(DateTime when) {
        StudentDataShareAuthorization target = null;
        for (StudentDataShareAuthorization authorization : this.getStudentDataShareAuthorizationSet()) {
            if (!authorization.isStudentDataShareAuthorization() || !authorization.getSince().isBefore((ReadableInstant)when) || target != null && !authorization.getSince().isAfter((ReadableInstant)target.getSince())) continue;
            target = authorization;
        }
        return target;
    }

    public Boolean hasPersonalDataAuthorizationForProfessionalPurposesAt() {
        StudentDataShareAuthorization authorization = this.getPersonalDataAuthorizationAt(new DateTime());
        return authorization != null && (authorization.getAuthorizationChoice().equals((Object)StudentPersonalDataAuthorizationChoice.PROFESSIONAL_ENDS) || authorization.getAuthorizationChoice().equals((Object)StudentPersonalDataAuthorizationChoice.ALL_ENDS) || authorization.getAuthorizationChoice().equals((Object)StudentPersonalDataAuthorizationChoice.SEVERAL_ENDS));
    }

    private void createCurrentYearStudentData() {
        if (this.getActualExecutionYearStudentData() == null) {
            new StudentDataByExecutionYear(this);
        }
    }

    private StudentDataByExecutionYear createStudentDataForExecutionYear(ExecutionYear executionYear) {
        if (this.getStudentDataByExecutionYear(executionYear) == null) {
            return new StudentDataByExecutionYear(this, executionYear);
        }
        return this.getStudentDataByExecutionYear(executionYear);
    }

    public StudentDataByExecutionYear getActualExecutionYearStudentData() {
        for (StudentDataByExecutionYear studentData : this.getStudentDataByExecutionYearSet()) {
            if (!studentData.getExecutionYear().isCurrent()) continue;
            return studentData;
        }
        return null;
    }

    public StudentDataByExecutionYear getStudentDataByExecutionYear(ExecutionYear executionYear) {
        for (StudentDataByExecutionYear studentData : this.getStudentDataByExecutionYearSet()) {
            if (!studentData.getExecutionYear().equals(executionYear)) continue;
            return studentData;
        }
        return null;
    }

    public boolean isWorkingStudent() {
        for (StudentStatute statute : this.getStudentStatutesSet()) {
            if (!statute.getType().isWorkingStudentStatute()) continue;
            return true;
        }
        return false;
    }

    public List<Registration> getRegistrationsFor(AdministrativeOffice administrativeOffice) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.isForOffice(administrativeOffice)) continue;
            result.add(registration);
        }
        return result;
    }

    public boolean hasActiveRegistrationForOffice(Unit office) {
        Set<Registration> registrations = this.getRegistrationsSet();
        for (Registration registration : registrations) {
            if (!registration.isActiveForOffice(office)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRegistrationForOffice(AdministrativeOffice administrativeOffice) {
        Set<Registration> registrations = this.getRegistrationsSet();
        for (Registration registration : registrations) {
            if (!registration.isForOffice(administrativeOffice)) continue;
            return true;
        }
        return false;
    }

    public boolean attends(ExecutionCourse executionCourse) {
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.attends(executionCourse)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyActiveRegistration() {
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.isActive()) continue;
            return true;
        }
        return false;
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        while (!this.getStudentDataByExecutionYearSet().isEmpty()) {
            ((StudentDataByExecutionYear)((Object)this.getStudentDataByExecutionYearSet().iterator().next())).delete();
        }
        while (!this.getRegistrationsSet().isEmpty()) {
            this.getRegistrationsSet().iterator().next().delete();
        }
        this.setNumber(null);
        this.setPerson(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public Set<ExecutionSemester> getEnroledExecutionPeriods() {
        TreeSet<ExecutionSemester> result = new TreeSet<ExecutionSemester>(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR);
        for (Registration registration : this.getRegistrationsSet()) {
            result.addAll(registration.getEnrolmentsExecutionPeriods());
        }
        return result;
    }

    public Collection<StudentStatuteBean> getCurrentStatutes() {
        return this.getStatutes(ExecutionSemester.readActualExecutionSemester());
    }

    public Collection<StudentStatuteBean> getStatutes(ExecutionSemester executionSemester) {
        ArrayList<StudentStatuteBean> result = new ArrayList<StudentStatuteBean>();
        for (StudentStatute statute : this.getStudentStatutesSet()) {
            if (!statute.isValidInExecutionPeriod(executionSemester)) continue;
            result.add(new StudentStatuteBean(statute, executionSemester));
        }
        if (this.isHandicapped()) {
            result.add(new StudentStatuteBean(StatuteType.findHandicappedStatuteType().orElse(null), executionSemester));
        }
        return result;
    }

    public Collection<StatuteType> getStatutesTypesValidOnAnyExecutionSemesterFor(ExecutionYear executionYear) {
        ArrayList<StatuteType> result = new ArrayList<StatuteType>();
        for (StudentStatute statute : this.getStudentStatutesSet()) {
            if (!statute.isValidOnAnyExecutionPeriodFor(executionYear)) continue;
            result.add(statute.getType());
        }
        if (this.isHandicapped()) {
            result.add(StatuteType.findHandicappedStatuteType().orElse(null));
        }
        return result;
    }

    public Collection<StudentStatuteBean> getAllStatutes() {
        ArrayList<StudentStatuteBean> result = new ArrayList<StudentStatuteBean>();
        for (StudentStatute statute : this.getStudentStatutesSet()) {
            result.add(new StudentStatuteBean(statute));
        }
        if (this.isHandicapped()) {
            result.add(new StudentStatuteBean(StatuteType.findHandicappedStatuteType().orElse(null)));
        }
        return result;
    }

    public Collection<StudentStatuteBean> getAllStatutesSplittedByExecutionPeriod() {
        ArrayList<StudentStatuteBean> result = new ArrayList<StudentStatuteBean>();
        for (ExecutionSemester executionSemester : this.getEnroledExecutionPeriods()) {
            result.addAll(this.getStatutes(executionSemester));
        }
        return result;
    }

    public boolean isSenior(ExecutionYear executionYear) {
        for (StudentStatute statute : this.getStudentStatutesSet()) {
            if (!statute.isValidOn(executionYear) || !statute.getType().isSeniorStatute()) continue;
            return true;
        }
        return false;
    }

    public boolean isSeniorForCurrentExecutionYear() {
        return this.isSenior(ExecutionYear.readCurrentExecutionYear());
    }

    public void addApprovedEnrolments(Collection<Enrolment> enrolments) {
        for (Registration registration : this.getRegistrationsSet()) {
            registration.addApprovedEnrolments(enrolments);
        }
    }

    public Set<Enrolment> getApprovedEnrolments() {
        HashSet<Enrolment> aprovedEnrolments = new HashSet<Enrolment>();
        for (Registration registration : this.getRegistrationsSet()) {
            aprovedEnrolments.addAll(registration.getApprovedEnrolments());
        }
        return aprovedEnrolments;
    }

    public List<Enrolment> getApprovedEnrolments(AdministrativeOffice administrativeOffice) {
        ArrayList<Enrolment> aprovedEnrolments = new ArrayList<Enrolment>();
        for (Registration registration : this.getRegistrationsFor(administrativeOffice)) {
            aprovedEnrolments.addAll(registration.getApprovedEnrolments());
        }
        return aprovedEnrolments;
    }

    public Set<Enrolment> getDismissalApprovedEnrolments() {
        HashSet<Enrolment> aprovedEnrolments = new HashSet<Enrolment>();
        for (Registration registration : this.getRegistrationsSet()) {
            for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                aprovedEnrolments.addAll(studentCurricularPlan.getDismissalApprovedEnrolments());
            }
        }
        return aprovedEnrolments;
    }

    public boolean isHandicapped() {
        for (Registration registration : this.getRegistrationsSet()) {
            if (registration.getIngressionType() == null || !registration.getIngressionType().isHandicappedContingent()) continue;
            return true;
        }
        return false;
    }

    public boolean getHasAnyBolonhaRegistration() {
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.getDegreeType().isBolonhaType()) continue;
            return true;
        }
        return false;
    }

    public Collection<StudentCurricularPlan> getAllStudentCurricularPlans() {
        HashSet<StudentCurricularPlan> result = new HashSet<StudentCurricularPlan>();
        for (Registration registration : this.getRegistrationsSet()) {
            result.addAll(registration.getStudentCurricularPlansSet());
        }
        return result;
    }

    public Attends readAttendByExecutionCourse(ExecutionCourse executionCourse) {
        for (Registration registration : this.getRegistrationsSet()) {
            Attends attends = registration.readRegistrationAttendByExecutionCourse(executionCourse);
            if (attends == null) continue;
            return attends;
        }
        return null;
    }

    public SortedSet<Attends> getAttendsForExecutionPeriod(ExecutionSemester executionSemester) {
        TreeSet<Attends> attends = new TreeSet<Attends>(Attends.ATTENDS_COMPARATOR_BY_EXECUTION_COURSE_NAME);
        for (Registration registration : this.getRegistrationsSet()) {
            attends.addAll(registration.getAttendsForExecutionPeriod(executionSemester));
        }
        return attends;
    }

    public List<Registration> getRegistrationsToEnrolByStudent() {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.isEnrolmentByStudentAllowed()) continue;
            result.add(registration);
        }
        return result;
    }

    public List<Registration> getRegistrationsToEnrolInShiftByStudent() {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.isEnrolmentByStudentInShiftsAllowed()) continue;
            result.add(registration);
        }
        return result;
    }

    public boolean isCurrentlyEnroled(DegreeCurricularPlan degreeCurricularPlan) {
        for (Registration registration : this.getRegistrationsSet()) {
            StudentCurricularPlan lastStudentCurricularPlan;
            RegistrationState registrationState = registration.getActiveState();
            if (!registration.isActive() && registrationState.getStateType() != RegistrationStateType.TRANSITED || (lastStudentCurricularPlan = registration.getLastStudentCurricularPlan()) == null || lastStudentCurricularPlan.getDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return true;
        }
        return false;
    }

    public Set<Enrolment> getDissertationEnrolments() {
        TreeSet<Enrolment> result = new TreeSet<Enrolment>(Enrolment.COMPARATOR_BY_REVERSE_EXECUTION_PERIOD_AND_NAME_AND_ID);
        for (Registration registration : this.getRegistrationsSet()) {
            for (StudentCurricularPlan studentCurricularPlan : registration.getStudentCurricularPlansSet()) {
                result.addAll(studentCurricularPlan.getDissertationEnrolments());
            }
        }
        return result;
    }

    public final Enrolment getDissertationEnrolment() {
        return this.getDissertationEnrolment(null);
    }

    public final TreeSet<Enrolment> getDissertationEnrolments(DegreeCurricularPlan degreeCurricularPlan) {
        TreeSet<Enrolment> enrolments = new TreeSet<Enrolment>(Enrolment.COMPARATOR_BY_EXECUTION_PERIOD_AND_NAME_AND_ID);
        for (Registration registration : this.getRegistrationsSet()) {
            enrolments.addAll(registration.getDissertationEnrolments(degreeCurricularPlan));
        }
        return enrolments;
    }

    public final Enrolment getDissertationEnrolment(DegreeCurricularPlan degreeCurricularPlan, final ExecutionYear executionYear) {
        TreeSet<Enrolment> enrolments = this.getDissertationEnrolments(degreeCurricularPlan);
        CollectionUtils.filter(enrolments, (Predicate)new Predicate(){

            public boolean evaluate(Object enrolment) {
                return ((Enrolment)enrolment).getExecutionYear().equals(executionYear);
            }
        });
        return enrolments.isEmpty() ? null : enrolments.last();
    }

    public final Enrolment getDissertationEnrolment(DegreeCurricularPlan degreeCurricularPlan) {
        TreeSet<Enrolment> enrolments = this.getDissertationEnrolments(degreeCurricularPlan);
        return enrolments.isEmpty() ? null : enrolments.last();
    }

    public Collection<Registration> getAllRegistrations() {
        return Collections.unmodifiableCollection(super.getRegistrationsSet());
    }

    public Set<Registration> getRegistrationsSet() {
        HashSet<Registration> result = new HashSet<Registration>();
        for (Registration registration : super.getRegistrationsSet()) {
            if (registration.isTransition()) continue;
            result.add(registration);
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean hasTransitionRegistrations() {
        for (Registration registration : super.getRegistrationsSet()) {
            if (!registration.isTransition()) continue;
            return true;
        }
        return false;
    }

    public List<Registration> getTransitionRegistrations() {
        AccessControl.check(this, StudentPredicates.checkIfLoggedPersonIsStudentOwnerOrManager);
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : super.getRegistrationsSet()) {
            if (!registration.isTransition()) continue;
            result.add(registration);
        }
        return result;
    }

    public List<Registration> getTransitionRegistrationsForDegreeCurricularPlansManagedByCoordinator(Person coordinator) {
        AccessControl.check(this, StudentPredicates.checkIfLoggedPersonIsCoordinator);
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : super.getRegistrationsSet()) {
            if (!registration.isTransition() || !coordinator.isCoordinatorFor(registration.getLastDegreeCurricularPlan(), ExecutionYear.readCurrentExecutionYear())) continue;
            result.add(registration);
        }
        return result;
    }

    public List<Registration> getTransitedRegistrations() {
        AccessControl.check(this, StudentPredicates.checkIfLoggedPersonIsStudentOwnerOrManager);
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : super.getRegistrationsSet()) {
            if (!registration.isTransited()) continue;
            result.add(registration);
        }
        return result;
    }

    private boolean isAnyTuitionInDebt(ExecutionYear executionYear) {
        for (Registration registration : super.getRegistrationsSet()) {
            if (!registration.hasAnyNotPayedGratuityEventsForPreviousYears(executionYear)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyGratuityOrAdministrativeOfficeFeeAndInsuranceInDebt() {
        return this.isAnyGratuityOrAdministrativeOfficeFeeAndInsuranceInDebt(ExecutionYear.readCurrentExecutionYear());
    }

    public boolean isAnyGratuityOrAdministrativeOfficeFeeAndInsuranceInDebt(ExecutionYear executionYear) {
        return this.isAnyTuitionInDebt(executionYear) || this.isAnyAdministrativeOfficeFeeAndInsuranceInDebtUntil(executionYear);
    }

    private boolean isAnyAdministrativeOfficeFeeAndInsuranceInDebtUntil(ExecutionYear executionYear) {
        for (Event event : this.getPerson().getEventsSet()) {
            if (!(event instanceof AdministrativeOfficeFeeAndInsuranceEvent) || !((AdministrativeOfficeFeeAndInsuranceEvent)((Object)event)).getExecutionYear().isBefore(executionYear) || !event.isOpen()) continue;
            return true;
        }
        return false;
    }

    public List<Registration> getRegistrationsFor(DegreeCurricularPlan degreeCurricularPlan) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        block0: for (Registration registration : super.getRegistrationsSet()) {
            for (DegreeCurricularPlan degreeCurricularPlanToTest : registration.getDegreeCurricularPlans()) {
                if (!degreeCurricularPlanToTest.equals((Object)degreeCurricularPlan)) continue;
                result.add(registration);
                continue block0;
            }
        }
        return result;
    }

    public boolean hasRegistrationFor(DegreeCurricularPlan degreeCurricularPlan) {
        return !this.getRegistrationsFor(degreeCurricularPlan).isEmpty();
    }

    public Registration getMostRecentRegistration(DegreeCurricularPlan degreeCurricularPlan) {
        List<Registration> registrations = this.getRegistrationsFor(degreeCurricularPlan);
        return registrations.isEmpty() ? null : Collections.max(registrations, Registration.COMPARATOR_BY_START_DATE);
    }

    public List<Registration> getRegistrationsFor(Degree degree) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        for (Registration registration : super.getRegistrationsSet()) {
            if (registration.getDegree() != degree) continue;
            result.add(registration);
        }
        return result;
    }

    public boolean hasRegistrationFor(Degree degree) {
        return !this.getRegistrationsFor(degree).isEmpty();
    }

    public Registration getActiveRegistrationFor(DegreeCurricularPlan degreeCurricularPlan) {
        for (Registration registration : this.getActiveRegistrations()) {
            if (registration.getLastDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return registration;
        }
        return null;
    }

    public boolean hasActiveRegistrationFor(DegreeCurricularPlan degreeCurricularPlan) {
        return this.getActiveRegistrationFor(degreeCurricularPlan) != null;
    }

    public Registration getActiveRegistrationFor(Degree degree) {
        for (Registration registration : this.getActiveRegistrations()) {
            if (registration.getLastDegree() != degree) continue;
            return registration;
        }
        return null;
    }

    public boolean hasActiveRegistrationFor(Degree degree) {
        return this.getActiveRegistrationFor(degree) != null;
    }

    public boolean hasActiveRegistrations() {
        for (Registration registration : super.getRegistrationsSet()) {
            RegistrationStateType registrationStateType;
            RegistrationState registrationState = registration.getActiveState();
            if (registrationState == null || (registrationStateType = registrationState.getStateType()) == RegistrationStateType.TRANSITION || !registrationStateType.isActive()) continue;
            return true;
        }
        return false;
    }

    public Registration getTransitionRegistrationFor(DegreeCurricularPlan degreeCurricularPlan) {
        for (Registration registration : this.getTransitionRegistrations()) {
            if (registration.getLastDegreeCurricularPlan() != degreeCurricularPlan) continue;
            return registration;
        }
        return null;
    }

    public boolean isGrantOwner(ExecutionYear executionYear) {
        for (StudentStatute studentStatute : this.getStudentStatutesSet()) {
            if (!studentStatute.isGrantOwnerStatute() || !studentStatute.isValidOn(executionYear)) continue;
            return true;
        }
        return false;
    }

    public SortedSet<ExternalEnrolment> getSortedExternalEnrolments() {
        TreeSet<ExternalEnrolment> result = new TreeSet<ExternalEnrolment>(ExternalEnrolment.COMPARATOR_BY_NAME);
        for (Registration registration : this.getRegistrationsSet()) {
            result.addAll(registration.getExternalEnrolmentsSet());
        }
        return result;
    }

    public Collection<? extends Forum> getForuns(ExecutionSemester executionSemester) {
        HashSet<ExecutionCourseForum> res = new HashSet<ExecutionCourseForum>();
        for (Registration registration : this.getRegistrationsSet()) {
            for (Attends attends : registration.getAssociatedAttendsSet()) {
                if (attends.getExecutionPeriod() != executionSemester) continue;
                res.addAll(attends.getExecutionCourse().getForuns());
            }
        }
        return res;
    }

    public void createGratuityEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        AccountingEventsManager manager = new AccountingEventsManager();
        InvocationResult result = manager.createGratuityEvent(studentCurricularPlan, executionYear);
        if (!result.isSuccess()) {
            throw new DomainExceptionWithInvocationResult(result);
        }
    }

    public void createAdministrativeOfficeFeeEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        AccountingEventsManager manager = new AccountingEventsManager();
        InvocationResult result = manager.createAdministrativeOfficeFeeAndInsuranceEvent(studentCurricularPlan, executionYear);
        if (!result.isSuccess()) {
            throw new DomainExceptionWithInvocationResult(result);
        }
    }

    public void createEnrolmentOutOfPeriodEvent(StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester, Integer numberOfDelayDays) {
        new AccountingEventsManager().createEnrolmentOutOfPeriodEvent(studentCurricularPlan, executionSemester, numberOfDelayDays);
    }

    public void createInsuranceEvent(StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        AccountingEventsManager manager = new AccountingEventsManager();
        InvocationResult result = manager.createInsuranceEvent(studentCurricularPlan, executionYear);
        if (!result.isSuccess()) {
            throw new DomainExceptionWithInvocationResult(result);
        }
    }

    public Collection<CurriculumLineLog> getCurriculumLineLogs(ExecutionSemester executionSemester) {
        HashSet<CurriculumLineLog> res = new HashSet<CurriculumLineLog>();
        for (Registration registration : this.getRegistrationsSet()) {
            res.addAll(registration.getCurriculumLineLogs(executionSemester));
        }
        return res;
    }

    public boolean hasActiveStatuteInPeriod(StatuteType statuteType, ExecutionSemester executionSemester) {
        for (StudentStatute studentStatute : this.getStudentStatutesSet()) {
            if (studentStatute.getType() != statuteType || !studentStatute.isValidInExecutionPeriod(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWorkingStudentStatuteInPeriod(ExecutionSemester executionSemester) {
        for (StudentStatute studentStatute : this.getStudentStatutesSet()) {
            if (!studentStatute.getType().isWorkingStudentStatute() || !studentStatute.isValidInExecutionPeriod(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnrolments(Enrolment enrolment) {
        if (enrolment == null) {
            return false;
        }
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.hasEnrolments(enrolment)) continue;
            return true;
        }
        return false;
    }

    public boolean learnsAt(Space campus) {
        for (Registration registration : this.getActiveRegistrations()) {
            if (registration.getCampus() != campus) continue;
            return true;
        }
        return false;
    }

    public ExecutionYear getFirstRegistrationExecutionYear() {
        ExecutionYear firstYear = null;
        for (Registration registration : this.getRegistrationsSet()) {
            if (firstYear == null) {
                firstYear = registration.getStartExecutionYear();
                continue;
            }
            if (!registration.getStartExecutionYear().isBefore(firstYear)) continue;
            firstYear = registration.getStartExecutionYear();
        }
        return firstYear;
    }

    public Collection<? extends AcademicServiceRequest> getAcademicServiceRequests(Class<? extends AcademicServiceRequest> clazz) {
        HashSet<? extends AcademicServiceRequest> result = new HashSet<AcademicServiceRequest>();
        for (Registration registration : this.getRegistrationsSet()) {
            result.addAll(registration.getAcademicServiceRequests(clazz));
        }
        return result;
    }

    public Collection<ExecutionYear> getEnrolmentsExecutionYears() {
        HashSet<ExecutionYear> executionYears = new HashSet<ExecutionYear>();
        for (Registration registration : this.getRegistrationsSet()) {
            executionYears.addAll(registration.getEnrolmentsExecutionYears());
        }
        return executionYears;
    }

    public boolean getActiveAlumni() {
        return this.getAlumni() != null;
    }

    public Attends getAttends(ExecutionCourse executionCourse) {
        Attends result = null;
        for (Registration registration : this.getRegistrationsSet()) {
            for (Attends attends : registration.getAssociatedAttendsSet()) {
                if (!attends.isFor(executionCourse)) continue;
                if (result != null) {
                    throw new DomainException("error.found.multiple.attends.for.student.in.execution.course", executionCourse.getNome(), executionCourse.getExecutionPeriod().getQualifiedName());
                }
                result = attends;
            }
        }
        return result;
    }

    public boolean hasAttends(ExecutionCourse executionCourse) {
        for (Registration registration : this.getRegistrationsSet()) {
            for (Attends attends : registration.getAssociatedAttendsSet()) {
                if (attends.getExecutionCourse() != executionCourse) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAnyMissingPersonalInformation() {
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.isValidForRAIDES() || !registration.hasMissingPersonalInformation(currentExecutionYear)) continue;
            return true;
        }
        for (PhdIndividualProgramProcess phdProcess : this.getPerson().getPhdIndividualProgramProcessesSet()) {
            if (!this.isValidAndActivePhdProcess(phdProcess) || !phdProcess.hasMissingPersonalInformation(currentExecutionYear)) continue;
            return true;
        }
        return false;
    }

    public boolean hasActivePhdProgramProcess() {
        for (PhdIndividualProgramProcess phdProcess : this.getPerson().getPhdIndividualProgramProcessesSet()) {
            if (!this.isValidAndActivePhdProcess(phdProcess)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidAndActivePhdProcess(PhdIndividualProgramProcess phdProcess) {
        return FenixEduAcademicConfiguration.getConfiguration().getRaidesRequestInfo() != false && phdProcess.isProcessActive() && this.hasValidInsuranceEvent();
    }

    public boolean hasValidInsuranceEvent() {
        return this.getPerson().getInsuranceEventFor(ExecutionYear.readCurrentExecutionYear()) != null && !this.getPerson().getInsuranceEventFor(ExecutionYear.readCurrentExecutionYear()).isCancelled();
    }

    public List<PersonalInformationBean> getPersonalInformationsWithMissingInformation() {
        ArrayList<PersonalInformationBean> result = new ArrayList<PersonalInformationBean>();
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (Registration registration : this.getRegistrationsSet()) {
            if (!registration.isValidForRAIDES() || !registration.hasMissingPersonalInformation(currentExecutionYear)) continue;
            result.add(registration.getPersonalInformationBean(currentExecutionYear));
        }
        for (PhdIndividualProgramProcess phdProcess : this.getPerson().getPhdIndividualProgramProcessesSet()) {
            if (!this.isValidAndActivePhdProcess(phdProcess) || !phdProcess.hasMissingPersonalInformation(currentExecutionYear)) continue;
            result.add(phdProcess.getPersonalInformationBean(currentExecutionYear));
        }
        Collections.sort(result, PersonalInformationBean.COMPARATOR_BY_DESCRIPTION);
        return result;
    }

    public void setNumber(Integer number) {
        super.setNumber(number);
        if (this.getStudentNumber() != null) {
            if (number != null) {
                this.getStudentNumber().setNumber(number);
            } else {
                this.getStudentNumber().delete();
            }
        } else if (number != null) {
            new StudentNumber(this);
        }
    }

    public void acceptRegistrationsFromOtherStudent(Collection<Registration> collection) {
        Object object = advice$acceptRegistrationsFromOtherStudent.perform((Callable)new Student$callable$acceptRegistrationsFromOtherStudent(this, collection));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$acceptRegistrationsFromOtherStudent(Student this_, Collection otherRegistrations) {
        Set registrations = super.getRegistrationsSet();
        registrations.addAll(otherRegistrations);
    }

    private boolean isEnroledOnSecondCycle(Registration registration) {
        if (registration.getLastStudentCurricularPlan().getSecondCycle() == null) {
            return false;
        }
        CycleCurriculumGroup secondCycle = registration.getLastStudentCurricularPlan().getSecondCycle();
        return secondCycle.hasAnyEnrolments();
    }

    private boolean isMasterDegreeOnly(Registration registration) {
        return registration.getDegree().getDegreeType().isBolonhaMasterDegree();
    }

    private boolean isIntegratedMasterDegree(Registration registration) {
        return registration.getDegree().getDegreeType().isIntegratedMasterDegree();
    }

    private boolean hasConcludedFirstCycle(Registration registration) {
        if (registration.getLastStudentCurricularPlan().getFirstCycle() == null) {
            return false;
        }
        return registration.getLastStudentCurricularPlan().getFirstCycle().isConcluded();
    }

    public void updateStudentRole() {
        if (this.shouldHaveStudentRole()) {
            UserLoginPeriod.createOpenPeriod((User)this.getPerson().getUser());
        }
    }

    public boolean shouldHaveStudentRole() {
        for (Registration registration : this.getRegistrationsSet()) {
            RegistrationStateType stateType = registration.getLastStateType();
            if (stateType == null || (!stateType.isActive() || stateType == RegistrationStateType.SCHOOLPARTCONCLUDED) && stateType != RegistrationStateType.FLUNKED && stateType != RegistrationStateType.INTERRUPTED && stateType != RegistrationStateType.MOBILITY) continue;
            return true;
        }
        for (PhdIndividualProgramProcess process2 : this.getPerson().getPhdIndividualProgramProcessesSet()) {
            PhdIndividualProgramProcessState state = process2.getActiveState();
            if ((!state.isActive() || state == PhdIndividualProgramProcessState.CONCLUDED) && state != PhdIndividualProgramProcessState.SUSPENDED && state != PhdIndividualProgramProcessState.FLUNKED) continue;
            return true;
        }
        return false;
    }

    public PersonalIngressionData getLatestPersonalIngressionData() {
        TreeSet<PersonalIngressionData> personalInformations = new TreeSet<PersonalIngressionData>(Collections.reverseOrder(PersonalIngressionData.COMPARATOR_BY_EXECUTION_YEAR));
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        for (PersonalIngressionData pid : this.getPersonalIngressionsDataSet()) {
            if (pid.getExecutionYear().isAfter(currentExecutionYear)) continue;
            personalInformations.add(pid);
        }
        if (personalInformations.isEmpty()) {
            return null;
        }
        return personalInformations.iterator().next();
    }

    public PersonalIngressionData getPersonalIngressionDataByExecutionYear(ExecutionYear executionYear) {
        for (PersonalIngressionData pid : this.getPersonalIngressionsDataSet()) {
            if (pid.getExecutionYear() != executionYear) continue;
            return pid;
        }
        return null;
    }

    static {
        advice$acceptRegistrationsFromOtherStudent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        NAME_COMPARATOR = new Comparator<Student>(){

            @Override
            public int compare(Student o1, Student o2) {
                return o1.getPerson().getName().compareTo(o2.getPerson().getName());
            }
        };
        NUMBER_COMPARATOR = new Comparator<Student>(){

            @Override
            public int compare(Student o1, Student o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        };
    }
}

