/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.student;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeState;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.events.AccountingEventsManager;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEventWithPaymentPlan;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithInvocationResult;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationRegime;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.academic.domain.studentCurriculum.Credits;
import org.fenixedu.academic.domain.studentCurriculum.CreditsDismissal;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroupFactory;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.EnrolmentWrapper;
import org.fenixedu.academic.domain.studentCurriculum.Equivalence;
import org.fenixedu.academic.domain.studentCurriculum.ExtraCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.OptionalDismissal;
import org.fenixedu.academic.domain.studentCurriculum.Substitution;
import org.fenixedu.academic.domain.studentCurriculum.TemporarySubstitution;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.util.InvocationResult;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class SeparationCyclesManagement {
    private static final Predicate<DegreeType> ACCEPTED_DEGREE_TYPES = DegreeType.oneOf(DegreeType::isBolonhaDegree, DegreeType::isIntegratedMasterDegree);

    public Registration separateSecondCycle(StudentCurricularPlan studentCurricularPlan) {
        this.checkIfCanSeparateSecondCycle(studentCurricularPlan);
        return this.createNewSecondCycle(studentCurricularPlan);
    }

    protected void checkIfCanSeparateSecondCycle(StudentCurricularPlan studentCurricularPlan) {
        if (!studentCurricularPlan.isBolonhaDegree()) {
            throw new DomainException("error.SeparationCyclesManagement.not.bolonha.degree", new String[0]);
        }
        if (!studentCurricularPlan.isActive() && !studentCurricularPlan.getRegistration().isConcluded()) {
            throw new DomainException("error.SeparationCyclesManagement.not.active.or.concluded", studentCurricularPlan.getName());
        }
        if (studentCurricularPlan.isConclusionProcessed()) {
            throw new DomainException("error.SeparationCyclesManagement.conclusion.processed", new String[0]);
        }
        if (!ACCEPTED_DEGREE_TYPES.test(studentCurricularPlan.getDegreeType())) {
            throw new DomainException("error.SeparationCyclesManagement.invalid.degreeType", new String[0]);
        }
        CycleCurriculumGroup secondCycle = studentCurricularPlan.getSecondCycle();
        if (secondCycle == null || !secondCycle.isExternal()) {
            throw new DomainException("error.SeparationCyclesManagement.invalid.secondCycle", new String[0]);
        }
        CycleCurriculumGroup firstCycle = studentCurricularPlan.getFirstCycle();
        if (firstCycle == null || !firstCycle.isConcluded()) {
            throw new DomainException("error.SeparationCyclesManagement.invalid.firstCycle", new String[0]);
        }
        if (this.studentAlreadyHasNewRegistration(studentCurricularPlan)) {
            DegreeCurricularPlan degreeCurricularPlan = secondCycle.getDegreeCurricularPlanOfDegreeModule();
            throw new DomainException("error.SeparationCyclesManagement.already.has.registration", degreeCurricularPlan.getName());
        }
    }

    private boolean studentAlreadyHasNewRegistration(StudentCurricularPlan studentCurricularPlan) {
        Student student = studentCurricularPlan.getRegistration().getStudent();
        return student.hasRegistrationFor(studentCurricularPlan.getSecondCycle().getDegreeCurricularPlanOfDegreeModule());
    }

    protected Registration createNewSecondCycle(StudentCurricularPlan oldStudentCurricularPlan) {
        Student student = oldStudentCurricularPlan.getRegistration().getStudent();
        CycleCurriculumGroup oldSecondCycle = oldStudentCurricularPlan.getSecondCycle();
        DegreeCurricularPlan degreeCurricularPlan = oldSecondCycle.getDegreeCurricularPlanOfDegreeModule();
        Registration newRegistration = this.createRegistration(student, oldStudentCurricularPlan);
        StudentCurricularPlan newStudentCurricularPlan = this.createStudentCurricularPlan(newRegistration, degreeCurricularPlan, oldSecondCycle.getCycleType());
        CycleCurriculumGroup newSecondCycle = newStudentCurricularPlan.getSecondCycle();
        this.copyCycleCurriculumGroupsInformation(oldSecondCycle, newSecondCycle);
        this.moveExtraCurriculumGroupInformation(oldStudentCurricularPlan, newStudentCurricularPlan);
        this.moveExtraAttends(oldStudentCurricularPlan, newStudentCurricularPlan);
        this.tryRemoveOldSecondCycle(oldSecondCycle);
        this.moveGratuityEventsInformation(oldStudentCurricularPlan, newStudentCurricularPlan);
        this.createAdministrativeOfficeFeeAndInsurance(newStudentCurricularPlan);
        this.markOldRegistrationWithConcludedState(oldStudentCurricularPlan);
        return newRegistration;
    }

    private void moveExtraAttends(StudentCurricularPlan oldStudentCurricularPlan, StudentCurricularPlan newStudentCurricularPlan) {
        HashSet<Attends> attends = new HashSet<Attends>();
        for (Attends attend : oldStudentCurricularPlan.getRegistration().getAssociatedAttendsSet()) {
            if (this.belongsTo(oldStudentCurricularPlan, attend) || !this.isToMoveAttendsFrom(oldStudentCurricularPlan, newStudentCurricularPlan, attend)) continue;
            attends.add(attend);
        }
        for (Attends attend : attends) {
            if (newStudentCurricularPlan.getRegistration().attends(attend.getExecutionCourse())) continue;
            attend.setRegistration(newStudentCurricularPlan.getRegistration());
        }
    }

    private boolean belongsTo(StudentCurricularPlan studentCurricularPlan, Attends attend) {
        for (CurricularCourse curricularCourse : attend.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
            if (!studentCurricularPlan.getDegreeCurricularPlan().hasDegreeModule((DegreeModule)((Object)curricularCourse))) continue;
            return true;
        }
        return false;
    }

    private boolean isToMoveAttendsFrom(StudentCurricularPlan oldStudentCurricularPlan, StudentCurricularPlan newStudentCurricularPlan, Attends attend) {
        if (attend.getEnrolment() != null) {
            return !oldStudentCurricularPlan.hasEnrolments(attend.getEnrolment()) && newStudentCurricularPlan.hasEnrolments(attend.getEnrolment());
        }
        return !attend.getExecutionPeriod().isBefore(newStudentCurricularPlan.getStartExecutionPeriod());
    }

    private Registration createRegistration(Student student, StudentCurricularPlan sourceStudentCurricularPlan) {
        CycleCurriculumGroup oldSecondCycle = sourceStudentCurricularPlan.getSecondCycle();
        Registration registration = student.getActiveRegistrationFor(oldSecondCycle.getDegreeCurricularPlanOfDegreeModule());
        if (registration != null) {
            return registration;
        }
        Degree degree = oldSecondCycle.getDegreeCurricularPlanOfDegreeModule().getDegree();
        registration = new Registration(student.getPerson(), student.getNumber(), degree);
        StudentCandidacy studentCandidacy = this.createStudentCandidacy(student, oldSecondCycle);
        registration.setStudentCandidacy(studentCandidacy);
        PersonalIngressionData personalIngressionData = student.getPersonalIngressionDataByExecutionYear(registration.getRegistrationYear());
        if (personalIngressionData == null) {
            new PersonalIngressionData(student, registration.getRegistrationYear(), studentCandidacy.getPrecedentDegreeInformation());
        } else {
            personalIngressionData.addPrecedentDegreesInformations(studentCandidacy.getPrecedentDegreeInformation());
        }
        registration.addPrecedentDegreesInformations(studentCandidacy.getPrecedentDegreeInformation());
        registration.setStartDate(this.getBeginDate(sourceStudentCurricularPlan, this.getExecutionPeriod()));
        RegistrationState activeState = registration.getActiveState();
        activeState.setStateDate(this.getBeginDate(sourceStudentCurricularPlan, this.getExecutionPeriod()));
        activeState.setResponsiblePerson(null);
        registration.setSourceRegistration(sourceStudentCurricularPlan.getRegistration());
        registration.setRegistrationProtocol(sourceStudentCurricularPlan.getRegistration().getRegistrationProtocol());
        return registration;
    }

    private YearMonthDay getBeginDate(StudentCurricularPlan sourceStudentCurricularPlan, ExecutionSemester executionSemester) {
        if (!sourceStudentCurricularPlan.getRegistration().hasConcluded()) {
            throw new DomainException("error.SeparationCyclesManagement.source.studentCurricularPlan.is.not.concluded", new String[0]);
        }
        YearMonthDay conclusionDate = sourceStudentCurricularPlan.getFirstCycle().calculateConclusionDate();
        YearMonthDay stateDate = conclusionDate != null ? conclusionDate.plusDays(1) : new YearMonthDay().plusDays(1);
        return executionSemester.getBeginDateYearMonthDay().isBefore((ReadablePartial)stateDate) ? stateDate : executionSemester.getBeginDateYearMonthDay();
    }

    private StudentCandidacy createStudentCandidacy(Student student, CycleCurriculumGroup oldSecondCycle) {
        DegreeCurricularPlan dcp = oldSecondCycle.getDegreeCurricularPlanOfDegreeModule();
        return StudentCandidacy.createStudentCandidacy(dcp.getExecutionDegreeByYear(this.getExecutionYear()), student.getPerson());
    }

    private StudentCurricularPlan createStudentCurricularPlan(Registration registration, DegreeCurricularPlan degreeCurricularPlan, CycleType cycleType) {
        StudentCurricularPlan result = registration.getStudentCurricularPlan(degreeCurricularPlan);
        if (result != null) {
            return result;
        }
        result = StudentCurricularPlan.createWithEmptyStructure(registration, degreeCurricularPlan, cycleType, registration.getStartDate());
        registration.setIngressionType(IngressionType.findByPredicate(IngressionType::isDirectAccessFrom1stCycle).orElse(null));
        return result;
    }

    private void copyCycleCurriculumGroupsInformation(CycleCurriculumGroup oldSecondCycle, CycleCurriculumGroup newSecondCycle) {
        for (CurriculumModule curriculumModule : oldSecondCycle.getCurriculumModulesSet()) {
            if (curriculumModule.isLeaf()) {
                this.copyCurricumLineInformation((CurriculumLine)((Object)curriculumModule), (CurriculumGroup)((Object)newSecondCycle));
                continue;
            }
            this.copyCurriculumGroupsInformation((CurriculumGroup)((Object)curriculumModule), (CurriculumGroup)((Object)newSecondCycle));
        }
    }

    private void copyCurriculumGroupsInformation(CurriculumGroup source, CurriculumGroup parent) {
        if (!this.groupIsStillValid(source)) {
            return;
        }
        CurriculumGroup destination = parent.hasChildDegreeModule((DegreeModule)((Object)source.getDegreeModule())) ? (CurriculumGroup)((Object)parent.getChildCurriculumModule((DegreeModule)((Object)source.getDegreeModule()))) : CurriculumGroupFactory.createGroup(parent, source.getDegreeModule());
        for (CurriculumModule curriculumModule : source.getCurriculumModulesSet()) {
            if (curriculumModule.isLeaf()) {
                this.copyCurricumLineInformation((CurriculumLine)((Object)curriculumModule), destination);
                continue;
            }
            this.copyCurriculumGroupsInformation((CurriculumGroup)((Object)curriculumModule), destination);
        }
    }

    private boolean groupIsStillValid(CurriculumGroup source) {
        ExecutionYear nowadays = ExecutionYear.readCurrentExecutionYear();
        if (source.getDegreeModule().getValidChildContexts(nowadays).size() > 0) {
            return true;
        }
        for (CurriculumGroup childGroup : source.getChildCurriculumGroups()) {
            if (!this.groupIsStillValid(childGroup)) continue;
            return true;
        }
        return false;
    }

    private void copyCurricumLineInformation(CurriculumLine curriculumLine, CurriculumGroup parent) {
        if (curriculumLine.isEnrolment()) {
            Enrolment enrolment = (Enrolment)((Object)curriculumLine);
            if (enrolment.getExecutionPeriod().isAfterOrEquals(this.getExecutionPeriod())) {
                this.moveEnrolment(enrolment, parent);
            } else if (enrolment.isApproved()) {
                this.createSubstitutionForEnrolment((Enrolment)((Object)curriculumLine), parent);
            }
        } else if (curriculumLine.isDismissal()) {
            if (curriculumLine.hasExecutionPeriod() && curriculumLine.getExecutionPeriod().isAfterOrEquals(this.getExecutionPeriod())) {
                this.moveDismissal((Dismissal)((Object)curriculumLine), parent);
            } else {
                this.createDismissal((Dismissal)((Object)curriculumLine), parent);
            }
        } else {
            throw new DomainException("error.unknown.curriculumLine", new String[0]);
        }
    }

    private void moveEnrolment(Enrolment enrolment, CurriculumGroup parent) {
        Enrolment childEnrolment;
        CurriculumModule child = parent.getChildCurriculumModule(enrolment.getDegreeModule());
        if (child != null && child.isEnrolment() && (childEnrolment = (Enrolment)((Object)child)).getExecutionPeriod() == enrolment.getExecutionPeriod()) {
            throw new DomainException("error.SeparationCyclesManagement.enrolment.should.not.exist.for.same.executionPeriod", new String[0]);
        }
        Registration registration = parent.getStudentCurricularPlan().getRegistration();
        enrolment.setCurriculumGroup(parent);
        for (Attends attend : enrolment.getAttendsSet()) {
            if (registration.attends(attend.getExecutionCourse())) continue;
            attend.setRegistration(registration);
        }
    }

    private void moveDismissal(Dismissal dismissal, CurriculumGroup parent) {
        if (!dismissal.getUsedInSeparationCycle().booleanValue()) {
            if (!this.curriculumGroupHasSimilarDismissal(parent, dismissal)) {
                dismissal.setCurriculumGroup(parent);
                dismissal.getCredits().setStudentCurricularPlan(parent.getStudentCurricularPlan());
            } else {
                dismissal.setUsedInSeparationCycle(true);
            }
        }
    }

    private void createSubstitutionForEnrolment(Enrolment enrolment, CurriculumGroup parent) {
        if (enrolment.getUsedInSeparationCycle().booleanValue() || parent.hasChildDegreeModule(enrolment.getDegreeModule())) {
            enrolment.setUsedInSeparationCycle(true);
            return;
        }
        enrolment.setUsedInSeparationCycle(true);
        if (enrolment.isOptional()) {
            OptionalEnrolment optional = (OptionalEnrolment)((Object)enrolment);
            if (parent.hasChildDegreeModule((DegreeModule)((Object)optional.getOptionalCurricularCourse()))) {
                return;
            }
            Substitution substitution = this.createSubstitution(enrolment, parent);
            this.createNewOptionalDismissal((Credits)((Object)substitution), parent, (CurriculumLine)((Object)enrolment), optional.getOptionalCurricularCourse(), optional.getEctsCredits());
        } else {
            this.createNewDismissal((Credits)((Object)this.createSubstitution(enrolment, parent)), parent, (CurriculumLine)((Object)enrolment));
        }
    }

    private Substitution createSubstitution(Enrolment enrolment, CurriculumGroup parent) {
        Substitution substitution = new Substitution();
        substitution.setStudentCurricularPlan(parent.getStudentCurricularPlan());
        substitution.setExecutionPeriod(this.getExecutionPeriod());
        EnrolmentWrapper.create((Credits)((Object)substitution), enrolment);
        return substitution;
    }

    private Dismissal createNewDismissal(Credits credits, CurriculumGroup parent, CurriculumLine curriculumLine) {
        CurricularCourse curricularCourse = curriculumLine.getCurricularCourse();
        if (!this.hasCurricularCourseToDismissal(parent, curricularCourse) && !this.hasResponsibleForCreation(curriculumLine)) {
            throw new DomainException("error.SeparationCyclesManagement.parent.doesnot.have.curricularCourse.to.dismissal", new String[0]);
        }
        Dismissal dismissal = new Dismissal();
        dismissal.setCredits(credits);
        dismissal.setCurriculumGroup(parent);
        dismissal.setCurricularCourse(curricularCourse);
        return dismissal;
    }

    private OptionalDismissal createNewOptionalDismissal(Credits credits, CurriculumGroup parent, CurriculumLine curriculumLine, OptionalCurricularCourse curricularCourse, Double ectsCredits) {
        if (ectsCredits == null || ectsCredits == 0.0) {
            throw new DomainException("error.OptionalDismissal.invalid.credits", new String[0]);
        }
        if (!this.hasCurricularCourseToDismissal(parent, (CurricularCourse)((Object)curricularCourse)) && !this.hasResponsibleForCreation(curriculumLine)) {
            throw new DomainException("error.SeparationCyclesManagement.parent.doesnot.have.curricularCourse.to.dismissal", new String[0]);
        }
        OptionalDismissal dismissal = new OptionalDismissal();
        dismissal.setCredits(credits);
        dismissal.setCurriculumGroup(parent);
        dismissal.setCurricularCourse((CurricularCourse)((Object)curricularCourse));
        dismissal.setEctsCredits(ectsCredits);
        return dismissal;
    }

    private boolean hasResponsibleForCreation(CurriculumLine line) {
        return line.hasCreatedBy();
    }

    private boolean hasCurricularCourseToDismissal(CurriculumGroup curriculumGroup, CurricularCourse curricularCourse) {
        CourseGroup degreeModule = curriculumGroup.getDegreeModule();
        for (Context context : degreeModule.getChildContexts(CurricularCourse.class)) {
            CurricularCourse each = (CurricularCourse)((Object)context.getChildDegreeModule());
            if (!each.isEquivalent(curricularCourse) || curriculumGroup.hasChildDegreeModule((DegreeModule)((Object)degreeModule))) continue;
            return true;
        }
        return false;
    }

    private void createDismissal(Dismissal dismissal, CurriculumGroup parent) {
        Object newCredits;
        if (dismissal.getUsedInSeparationCycle().booleanValue() || this.curriculumGroupHasSimilarDismissal(parent, dismissal)) {
            dismissal.setUsedInSeparationCycle(true);
            return;
        }
        dismissal.setUsedInSeparationCycle(true);
        Credits credits = dismissal.getCredits();
        if (credits.isTemporary()) {
            newCredits = new TemporarySubstitution();
        } else if (credits.isSubstitution()) {
            newCredits = new Substitution();
        } else if (credits.isEquivalence()) {
            Equivalence equivalence = (Equivalence)((Object)credits);
            Equivalence newEquivalence = new Equivalence();
            newEquivalence.setGrade(equivalence.getGrade());
            newCredits = newEquivalence;
        } else {
            newCredits = new Credits();
        }
        newCredits.setStudentCurricularPlan(parent.getStudentCurricularPlan());
        newCredits.setExecutionPeriod(this.getExecutionPeriod());
        newCredits.setGivenCredits(credits.getGivenCredits());
        for (IEnrolment enrolment : credits.getIEnrolments()) {
            EnrolmentWrapper.create((Credits)((Object)newCredits), enrolment);
        }
        if (dismissal.hasCurricularCourse()) {
            if (dismissal instanceof OptionalDismissal) {
                OptionalDismissal optionalDismissal = (OptionalDismissal)((Object)dismissal);
                this.createNewOptionalDismissal((Credits)((Object)newCredits), parent, (CurriculumLine)((Object)dismissal), optionalDismissal.getCurricularCourse(), optionalDismissal.getEctsCredits());
            } else {
                this.createNewDismissal((Credits)((Object)newCredits), parent, (CurriculumLine)((Object)dismissal));
            }
        } else if (dismissal.isCreditsDismissal()) {
            CreditsDismissal creditsDismissal = (CreditsDismissal)((Object)dismissal);
            new CreditsDismissal((Credits)((Object)newCredits), parent, creditsDismissal.getNoEnrolCurricularCoursesSet());
        } else {
            throw new DomainException("error.unknown.dismissal.type", new String[0]);
        }
    }

    private boolean curriculumGroupHasSimilarDismissal(CurriculumGroup curriculumGroup, Dismissal dismissal) {
        for (Dismissal each : curriculumGroup.getChildDismissals()) {
            if (!each.isSimilar(dismissal)) continue;
            return true;
        }
        return false;
    }

    private void moveExtraCurriculumGroupInformation(StudentCurricularPlan oldStudentCurricularPlan, StudentCurricularPlan newStudentCurricularPlan) {
        ExtraCurriculumGroup oldExtraCurriculumGroup = oldStudentCurricularPlan.getExtraCurriculumGroup();
        if (oldExtraCurriculumGroup != null) {
            ExtraCurriculumGroup newExtraCurriculumGroup = newStudentCurricularPlan.getExtraCurriculumGroup();
            if (newExtraCurriculumGroup == null) {
                throw new DomainException("error.invalid.newExtraCurriculumGroup", new String[0]);
            }
            for (CurriculumModule curriculumModule : oldExtraCurriculumGroup.getCurriculumModulesSet()) {
                CurriculumLine curriculumLine;
                if (curriculumModule.isCurriculumLine() && (!(curriculumLine = (CurriculumLine)((Object)curriculumModule)).hasExecutionPeriod() || curriculumLine.getExecutionPeriod().isBefore(this.getExecutionPeriod()))) continue;
                curriculumModule.setCurriculumGroup((CurriculumGroup)((Object)newExtraCurriculumGroup));
            }
            for (CurriculumLine curriculumLine : newExtraCurriculumGroup.getAllCurriculumLines()) {
                if (!curriculumLine.isDismissal()) continue;
                Dismissal dismissal = (Dismissal)((Object)curriculumLine);
                dismissal.getCredits().setStudentCurricularPlan(newStudentCurricularPlan);
            }
        }
    }

    private void tryRemoveOldSecondCycle(CycleCurriculumGroup oldSecondCycle) {
        if (this.canRemoveOldSecondCycle(oldSecondCycle)) {
            this.deleteCurriculumModules((CurriculumModule)((Object)oldSecondCycle));
        }
    }

    protected void deleteCurriculumModules(CurriculumModule curriculumModule) {
        if (curriculumModule == null) {
            return;
        }
        if (!curriculumModule.isLeaf()) {
            CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)curriculumModule);
            while (!curriculumGroup.getCurriculumModulesSet().isEmpty()) {
                this.deleteCurriculumModules((CurriculumModule)((Object)curriculumGroup.getCurriculumModulesSet().iterator().next()));
            }
            curriculumGroup.delete();
        } else if (curriculumModule.isDismissal()) {
            curriculumModule.delete();
        } else {
            throw new DomainException("error.can.only.remove.groups.and.dismissals", new String[0]);
        }
    }

    private boolean canRemoveOldSecondCycle(CycleCurriculumGroup oldSecondCycle) {
        for (CurriculumLine curriculumLine : oldSecondCycle.getAllCurriculumLines()) {
            if (curriculumLine.isEnrolment()) {
                return false;
            }
            if (curriculumLine.isDismissal()) continue;
            throw new DomainException("error.unknown.curriculum.line", new String[0]);
        }
        return true;
    }

    private void markOldRegistrationWithConcludedState(StudentCurricularPlan oldStudentCurricularPlan) {
        if (oldStudentCurricularPlan.getRegistration().hasState(RegistrationStateType.CONCLUDED)) {
            return;
        }
        LocalDate stateDate = new LocalDate();
        if (stateDate.isAfter((ReadablePartial)this.getExecutionYear().getEndDateYearMonthDay())) {
            stateDate = this.getExecutionYear().getEndDateYearMonthDay().toLocalDate();
        }
        RegistrationState state = RegistrationState.createRegistrationState(oldStudentCurricularPlan.getRegistration(), null, stateDate.toDateTimeAtStartOfDay(), RegistrationStateType.CONCLUDED);
        state.setResponsiblePerson(null);
    }

    private void moveGratuityEventsInformation(StudentCurricularPlan oldStudentCurricularPlan, StudentCurricularPlan newStudentCurricularPlan) {
        if (!oldStudentCurricularPlan.hasGratuityEvent(this.getExecutionYear(), GratuityEventWithPaymentPlan.class) || oldStudentCurricularPlan.getGratuityEvent(this.getExecutionYear(), GratuityEventWithPaymentPlan.class).isCancelled()) {
            return;
        }
        if (!newStudentCurricularPlan.hasGratuityEvent(this.getExecutionYear(), GratuityEventWithPaymentPlan.class)) {
            this.correctRegistrationRegime(oldStudentCurricularPlan, newStudentCurricularPlan);
            this.createGratuityEvent(newStudentCurricularPlan);
        }
        Object firstEvent = oldStudentCurricularPlan.getGratuityEvent(this.getExecutionYear(), GratuityEventWithPaymentPlan.class);
        Object secondEvent = newStudentCurricularPlan.getGratuityEvent(this.getExecutionYear(), GratuityEventWithPaymentPlan.class);
        if (!((GratuityEvent)((Object)firstEvent)).isGratuityEventWithPaymentPlan() || !((GratuityEvent)((Object)secondEvent)).isGratuityEventWithPaymentPlan()) {
            throw new DomainException("error.SeparationCyclesManagement.unexpected.event.types", new String[0]);
        }
        this.movePayments((GratuityEventWithPaymentPlan)((Object)firstEvent), (GratuityEventWithPaymentPlan)((Object)secondEvent));
    }

    private void createGratuityEvent(StudentCurricularPlan newStudentCurricularPlan) {
        InvocationResult result = new AccountingEventsManager().createGratuityEvent(newStudentCurricularPlan, this.getExecutionYear(), false);
        if (!result.isSuccess()) {
            throw new DomainExceptionWithInvocationResult(result);
        }
    }

    private void movePayments(GratuityEventWithPaymentPlan firstEvent, GratuityEventWithPaymentPlan secondEvent) {
        if (this.mustConfigurateToDefault(secondEvent)) {
            secondEvent.configurateDefaultPaymentPlan();
        }
        if (firstEvent.hasCustomGratuityPaymentPlan()) {
            return;
        }
        if (!firstEvent.hasAnyPayments()) {
            firstEvent.cancel(this.getNoPaymentsReason((GratuityEvent)((Object)secondEvent)));
            return;
        }
        Money amountLessPenalty = firstEvent.getPayedAmountLessPenalty();
        firstEvent.configurateCustomPaymentPlan();
        this.createInstallment((GratuityEvent)((Object)firstEvent), firstEvent.getGratuityPaymentPlan(), firstEvent.getPayedAmount());
        for (PaymentCode paymentCode : firstEvent.getNonProcessedPaymentCodes()) {
            paymentCode.setState(PaymentCodeState.INVALID);
        }
        firstEvent.recalculateState(new DateTime());
        Money originalTotalAmount = secondEvent.getGratuityPaymentPlan().calculateOriginalTotalAmount();
        secondEvent.addDiscount(this.getPerson(), Money.min(amountLessPenalty, originalTotalAmount));
        secondEvent.recalculateState(new DateTime());
    }

    private boolean mustConfigurateToDefault(GratuityEventWithPaymentPlan secondEvent) {
        return !secondEvent.getRegistration().isPartialRegime(this.getExecutionYear());
    }

    private void correctRegistrationRegime(StudentCurricularPlan oldStudentCurricularPlan, StudentCurricularPlan newStudentCurricularPlan) {
        if (oldStudentCurricularPlan.getRegistration().isPartialRegime(this.getExecutionYear()) && !newStudentCurricularPlan.getRegistration().isPartialRegime(this.getExecutionYear())) {
            new RegistrationRegime(newStudentCurricularPlan.getRegistration(), this.getExecutionYear(), RegistrationRegimeType.PARTIAL_TIME);
        }
    }

    private Person getPerson() {
        return AccessControl.getPerson();
    }

    private void createInstallment(GratuityEvent event, PaymentPlan paymentPlan, Money amount) {
        new Installment(paymentPlan, amount, event.getStartDate().toYearMonthDay(), event.getLastPaymentDate().toYearMonthDay());
    }

    private String getNoPaymentsReason(GratuityEvent second) {
        String message = BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.SeparationCyclesManagement.noPayments.reason", (String[])new String[0]);
        return MessageFormat.format(message, second.getStudentCurricularPlan().getName());
    }

    private void createAdministrativeOfficeFeeAndInsurance(StudentCurricularPlan newStudentCurricularPlan) {
        if (!newStudentCurricularPlan.getPerson().hasAdministrativeOfficeFeeInsuranceEventFor(this.getExecutionYear()) && newStudentCurricularPlan.hasEnrolments(this.getExecutionYear())) {
            new AccountingEventsManager().createAdministrativeOfficeFeeAndInsuranceEvent(newStudentCurricularPlan, this.getExecutionYear(), false);
        }
    }

    protected ExecutionSemester getExecutionPeriod() {
        return ExecutionSemester.readActualExecutionSemester();
    }

    private ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod().getExecutionYear();
    }
}

