/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DeclarationRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.EnrolmentDeclarationRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.GenericDeclarationRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IRSDeclarationRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.SchoolRegistrationDeclarationRequest;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;

public abstract class DeclarationRequest
extends DeclarationRequest_Base {
    protected DeclarationRequest() {
        super.setNumberOfPages(Integer.valueOf(0));
    }

    protected final void init(DocumentRequestCreateBean bean) {
        super.init((RegistrationAcademicServiceRequestCreateBean)bean);
        super.checkParameters(bean);
        super.setDocumentPurposeTypeInstance(bean.getChosenDocumentPurposeType());
        super.setDocumentPurposeType(this.getDocumentPurposeTypeInstance() != null ? this.getDocumentPurposeTypeInstance().getDocumentPurposeType() : null);
        super.setOtherDocumentPurposeTypeDescription(bean.getOtherPurpose());
    }

    public static final DeclarationRequest create(DocumentRequestCreateBean bean) {
        DocumentRequestType requestType = bean.getChosenServiceRequestType().getDocumentRequestType();
        switch (requestType) {
            case SCHOOL_REGISTRATION_DECLARATION: {
                return new SchoolRegistrationDeclarationRequest(bean);
            }
            case ENROLMENT_DECLARATION: {
                return new EnrolmentDeclarationRequest(bean);
            }
            case IRS_DECLARATION: {
                return new IRSDeclarationRequest(bean);
            }
            case GENERIC_DECLARATION: {
                return new GenericDeclarationRequest(bean);
            }
        }
        return null;
    }

    public final void setDocumentPurposeType(DocumentPurposeType documentPurposeType) {
        throw new DomainException("error.serviceRequests.documentRequests.DeclarationRequest.cannot.modify.documentPurposeType", new String[0]);
    }

    public final void setOtherDocumentPurposeTypeDescription(String otherDocumentTypeDescription) {
        throw new DomainException("error.serviceRequests.documentRequests.DeclarationRequest.cannot.modify.otherDocumentTypeDescription", new String[0]);
    }

    public final Boolean getUrgentRequest() {
        return Boolean.FALSE;
    }

    public final void edit(DocumentRequestBean documentRequestBean) {
        IAcademicServiceRequestAndAcademicTaxTreasuryEvent event = TreasuryBridgeAPIFactory.implementation().academicTreasuryEventForAcademicServiceRequest((AcademicServiceRequest)((Object)this));
        if (this.isPayable() && event != null && !this.getNumberOfPages().equals(documentRequestBean.getNumberOfPages())) {
            throw new DomainException("error.serviceRequests.documentRequests.cannot.change.numberOfPages.on.payed.documents", new String[0]);
        }
        super.edit((AcademicServiceRequestBean)documentRequestBean);
        super.setNumberOfPages(documentRequestBean.getNumberOfPages());
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToConclude() && this.getServiceRequestType().isPayable() && (this.getNumberOfPages() == null || this.getNumberOfPages() == 0)) {
            throw new DomainException("error.serviceRequests.documentRequests.numberOfPages.must.be.set", new String[0]);
        }
    }

    public final boolean isFree() {
        if (this.getDocumentPurposeType() == DocumentPurposeType.PPRE) {
            return false;
        }
        return super.isFree() || this.hasFreeDeclarationRequests();
    }

    protected abstract boolean hasFreeDeclarationRequests();

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isPagedDocument() {
        return true;
    }

    public boolean isToPrint() {
        return true;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return false;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return false;
    }

    public boolean hasPersonalInfo() {
        return false;
    }
}

