/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.meeting.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.PhdMeetingSchedulingActivity;
import org.fenixedu.bennu.core.domain.User;

public class SkipScheduleFirstThesisMeeting
extends PhdMeetingSchedulingActivity {
    @Override
    protected void activityPreConditions(PhdMeetingSchedulingProcess process2, User userView) {
        if (!process2.getThesisProcess().getActiveState().equals(PhdThesisProcessStateType.WAITING_FOR_THESIS_MEETING_SCHEDULING)) {
            throw new PreConditionNotValidException();
        }
        if (!process2.getActiveState().equals(PhdMeetingSchedulingProcessStateType.WAITING_FIRST_THESIS_MEETING_SCHEDULE)) {
            throw new PreConditionNotValidException();
        }
        if (process2.isAllowedToManageProcess(userView)) {
            return;
        }
        if (!process2.getThesisProcess().isPresidentJuryElement(userView.getPerson())) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdMeetingSchedulingProcess executeActivity(PhdMeetingSchedulingProcess process2, User userView, Object object) {
        PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
        PhdThesisProcess thesisProcess = process2.getThesisProcess();
        thesisProcess.setMeetingDate(bean.getScheduledDate());
        thesisProcess.setMeetingPlace(bean.getScheduledPlace());
        thesisProcess.createState(PhdThesisProcessStateType.WAITING_FOR_THESIS_DISCUSSION_DATE_SCHEDULING, userView.getPerson(), bean.getRemarks());
        process2.addMeeting(PhdMeeting.create(process2, bean.getScheduledDate(), bean.getScheduledPlace()));
        process2.createState(PhdMeetingSchedulingProcessStateType.WITHOUT_THESIS_MEETING_REQUEST, userView.getPerson(), bean.getRemarks());
        return process2;
    }
}

