/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.thesis.meeting;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.caseHandling.Activity;
import org.fenixedu.academic.domain.caseHandling.StartActivity;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcessBean;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcessState;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcessStateType;
import org.fenixedu.academic.domain.phd.thesis.meeting.PhdMeetingSchedulingProcess_Base;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.PhdMeetingSchedulingActivity;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleFirstThesisMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleFirstThesisMeetingRequest;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleThesisMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.ScheduleThesisMeetingRequest;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.SkipScheduleFirstThesisMeeting;
import org.fenixedu.academic.domain.phd.thesis.meeting.activities.SubmitThesisMeetingMinutes;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class PhdMeetingSchedulingProcess
extends PhdMeetingSchedulingProcess_Base {
    private static List<Activity> activities = new ArrayList<Activity>();

    public boolean isAllowedToManageProcess(User userView) {
        return this.getIndividualProgramProcess().isAllowedToManageProcess(userView);
    }

    public PhdMeetingSchedulingProcess(PhdThesisProcess process2) {
        super.setThesisProcess(process2);
    }

    public void setThesisProcess(PhdThesisProcess thesisProcess) {
        throw new DomainException("error.phd.thesis.meeting.cannot.set.thesis.process", new String[0]);
    }

    protected Person getPerson() {
        return this.getIndividualProgramProcess().getPerson();
    }

    public List<Activity> getActivities() {
        return activities;
    }

    public boolean canExecuteActivity(User userView) {
        return false;
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    public PhdMeetingSchedulingProcessStateType getActiveState() {
        return (PhdMeetingSchedulingProcessStateType)super.getActiveState();
    }

    protected PhdIndividualProgramProcess getIndividualProgramProcess() {
        return this.getThesisProcess().getIndividualProgramProcess();
    }

    public void createState(PhdMeetingSchedulingProcessStateType type, Person person, String remarks) {
        PhdMeetingSchedulingProcessState.createWithInferredStateDate(this, type, person, remarks);
    }

    public void addMeeting(PhdMeeting meeting) {
        this.getMeetingsSet().add(meeting);
    }

    public boolean isAnyMinutesDocumentMissing() {
        for (PhdMeeting meeting : this.getMeetingsSet()) {
            if (!meeting.getDocumentsSet().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PhdMeetingSchedulingProcessState getMostRecentState() {
        return (PhdMeetingSchedulingProcessState)((Object)super.getMostRecentState());
    }

    public Set<PhdMeetingSchedulingProcessState> getStates() {
        return this.getStatesSet();
    }

    public boolean hasAnyStates() {
        return !this.getStatesSet().isEmpty();
    }

    static {
        activities.add(new ScheduleFirstThesisMeetingRequest());
        activities.add(new ScheduleFirstThesisMeeting());
        activities.add(new ScheduleThesisMeetingRequest());
        activities.add(new ScheduleThesisMeeting());
        activities.add(new SubmitThesisMeetingMinutes());
        activities.add(new SkipScheduleFirstThesisMeeting());
    }

    @StartActivity
    public static class StartThesisMeetings
    extends PhdMeetingSchedulingActivity {
        @Override
        protected void activityPreConditions(PhdMeetingSchedulingProcess process2, User userView) {
        }

        @Override
        protected PhdMeetingSchedulingProcess executeActivity(PhdMeetingSchedulingProcess process2, User userView, Object object) {
            PhdThesisProcessBean bean = (PhdThesisProcessBean)object;
            PhdMeetingSchedulingProcess result = new PhdMeetingSchedulingProcess(bean.getThesisProcess());
            result.createState(PhdMeetingSchedulingProcessStateType.WAITING_FIRST_THESIS_MEETING_REQUEST, userView.getPerson(), bean.getRemarks());
            return result;
        }
    }
}

