/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.individualProcess.activities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.phd.ManageEnrolmentsBean;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.alert.AlertService;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.bennu.core.domain.User;

public class RejectEnrolments
extends PhdIndividualProgramProcessActivity {
    @Override
    public void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
        if (!process2.isCoordinatorForPhdProgram(userView.getPerson())) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess process2, User userView, Object object) {
        ManageEnrolmentsBean bean = (ManageEnrolmentsBean)object;
        StudentCurricularPlan scp = process2.getRegistration().getLastStudentCurricularPlan();
        String mailBody = this.buildBody(bean);
        scp.enrol(bean.getSemester(), Collections.emptySet(), this.getCurriculumModules(bean.getEnrolmentsToValidate()), CurricularRuleLevel.ENROLMENT_WITH_RULES);
        AlertService.alertStudent(process2, AlertService.AlertMessage.create(bean.getMailSubject(), new Object[0]).isKey(false), AlertService.AlertMessage.create(mailBody, new Object[0]).isKey(false));
        return process2;
    }

    private String buildBody(ManageEnrolmentsBean bean) {
        StringBuilder sb = new StringBuilder();
        sb.append(AlertService.getMessageFromResource("label.phd.rejected.enrolments")).append("\n");
        for (Enrolment enrolment : bean.getEnrolmentsToValidate()) {
            sb.append("- ").append(enrolment.getPresentationName()).append(enrolment.getExecutionPeriod().getQualifiedName()).append("\n");
        }
        return sb.toString();
    }

    private List<CurriculumModule> getCurriculumModules(List<Enrolment> enrolmentsToValidate) {
        return new ArrayList<Enrolment>(enrolmentsToValidate);
    }
}

