/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd;

import java.security.SecureRandom;
import java.util.Collection;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.ExternalPhdParticipant;
import org.fenixedu.academic.domain.phd.InternalPhdParticipant;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.PhdParticipant_Base;
import org.fenixedu.academic.domain.phd.access.PhdProcessAccessType;
import org.fenixedu.academic.domain.phd.access.PhdProcessAccessTypeList;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestElement;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisProcess;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public abstract class PhdParticipant
extends PhdParticipant_Base {
    protected PhdParticipant() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setWhenCreated(new DateTime());
        this.setAccessTypes(PhdProcessAccessTypeList.EMPTY);
    }

    protected void init(PhdIndividualProgramProcess individualProcess) {
        String[] args = new String[]{};
        if (individualProcess == null) {
            throw new DomainException("error.PhdParticipant.individualProcess.cannot.be.null", args);
        }
        super.setIndividualProcess(individualProcess);
    }

    private void delete() {
        this.disconnect();
        this.deleteDomainObject();
    }

    protected void disconnect() {
        this.setIndividualProcess(null);
        this.setProcessForGuiding(null);
        this.setProcessForAssistantGuiding(null);
        this.setRootDomainObject(null);
        this.setAcceptanceLetter(null);
    }

    public abstract String getName();

    public abstract String getQualification();

    public abstract String getAddress();

    public abstract String getEmail();

    public abstract String getPhone();

    public abstract boolean isTeacher();

    public String getNameWithTitle() {
        return StringUtils.isEmpty((String)this.getTitle()) ? this.getName() : this.getTitle() + " " + this.getName();
    }

    public boolean isFor(Person person) {
        return false;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isFor(PhdIndividualProgramProcess process2) {
        return this.getIndividualProcess().equals((Object)process2);
    }

    public void addAccessType(PhdProcessAccessType ... types) {
        this.ensureExternalAccess();
        this.setAccessTypes(this.getAccessTypes().addAccessTypes(types));
    }

    public void ensureExternalAccess() {
        if (StringUtils.isEmpty((String)this.getAccessHashCode())) {
            super.setAccessHashCode(UUID.randomUUID().toString());
            super.setPassword(RandomStringUtils.random((int)15, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)new SecureRandom()));
        }
    }

    public void checkAccessCredentials(String email, String password) {
        if (StringUtils.isEmpty((String)email) || StringUtils.isEmpty((String)password) || !this.hasAccessHashCode()) {
            throw new DomainException("error.PhdParticipant.credential.not.valid", new String[0]);
        }
        if (!this.getEmail().equals(email) || !this.getPassword().equals(password)) {
            throw new DomainException("error.PhdParticipant.credential.not.valid", new String[0]);
        }
    }

    private boolean hasAccessHashCode() {
        return !StringUtils.isEmpty((String)this.getAccessHashCode());
    }

    public void tryDelete() {
        if (this.getDeletionBlockers().isEmpty()) {
            this.delete();
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getThesisJuryElementsSet().isEmpty() || this.getProcessForGuiding() != null || this.getProcessForAssistantGuiding() != null || !this.getCandidacyFeedbackRequestElementsSet().isEmpty() || this.isParticipantCoordinator()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.cannotdeletePhdParticipant", (String[])new String[0]));
        }
    }

    private boolean isParticipantCoordinator() {
        if (!this.isInternal()) {
            return false;
        }
        InternalPhdParticipant internalParticipant = (InternalPhdParticipant)((Object)this);
        return this.getIndividualProcess().getPhdProgram().isCoordinatorFor(internalParticipant.getPerson(), this.getIndividualProcess().getExecutionYear());
    }

    public boolean isGuidingOrAssistantGuiding() {
        return this.getProcessForGuiding() != null || this.getProcessForAssistantGuiding() != null;
    }

    public ThesisJuryElement getThesisJuryElement(PhdThesisProcess process2) {
        for (ThesisJuryElement element : this.getThesisJuryElementsSet()) {
            if (!element.isFor(process2)) continue;
            return element;
        }
        return null;
    }

    public PhdCandidacyFeedbackRequestElement getPhdCandidacyFeedbackRequestElement(PhdCandidacyFeedbackRequestProcess process2) {
        for (PhdCandidacyFeedbackRequestElement element : this.getCandidacyFeedbackRequestElementsSet()) {
            if (!element.isFor(process2)) continue;
            return element;
        }
        return null;
    }

    private boolean hasAccessHashCode(String hash) {
        return !StringUtils.isEmpty((String)this.getAccessHashCode()) && this.getAccessHashCode().equals(hash);
    }

    public static PhdParticipant getUpdatedOrCreate(PhdIndividualProgramProcess process2, PhdParticipantBean bean) {
        if (bean.hasParticipant()) {
            bean.getParticipant().updateTitleIfNecessary(bean);
            return bean.getParticipant();
        }
        if (bean.isInternal()) {
            return new InternalPhdParticipant(process2, bean);
        }
        return new ExternalPhdParticipant(process2, bean);
    }

    private void updateTitleIfNecessary(PhdParticipantBean bean) {
        if (StringUtils.isEmpty((String)this.getTitle())) {
            this.setTitle(bean.getTitle());
        }
    }

    public void edit(PhdParticipantBean bean) {
        this.setTitle(bean.getTitle());
        this.setCategory(bean.getCategory());
        this.setWorkLocation(bean.getWorkLocation());
        this.setInstitution(bean.getInstitution());
    }

    public static PhdParticipant readByAccessHashCode(String hash) {
        for (PhdParticipant participant : Bennu.getInstance().getPhdParticipantsSet()) {
            if (!participant.hasAccessHashCode(hash)) continue;
            return participant;
        }
        return null;
    }
}

