/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curriculum;

import java.math.BigDecimal;
import java.util.List;
import org.fenixedu.academic.domain.curriculum.GradeFactory;
import org.fenixedu.academic.domain.curriculum.IGrade;

public enum GradeType {
    GRADETWENTY{

        @Override
        public IGrade average(List<IGrade> grades) {
            long sum = this.numericSum(grades);
            BigDecimal divider = new BigDecimal(sum).divide(new BigDecimal(grades.size()), 6);
            return GradeFactory.getInstance().getGrade((int)divider.longValue());
        }
    }
    ,
    GRADEFIVE{

        @Override
        public IGrade average(List<IGrade> grades) {
            long sum = this.numericSum(grades);
            BigDecimal divider = new BigDecimal(sum).divide(new BigDecimal(grades.size()), 6);
            return GradeFactory.getInstance().getGrade((int)divider.longValue());
        }
    }
    ,
    GRADEAP{

        @Override
        public IGrade average(List<IGrade> grades) {
            return GradeFactory.getInstance().getGrade("AP");
        }
    }
    ,
    GRADERE{

        @Override
        public IGrade average(List<IGrade> grades) {
            return GradeFactory.getInstance().getGrade("RE");
        }
    }
    ,
    GRADENA{

        @Override
        public IGrade average(List<IGrade> grades) {
            return GradeFactory.getInstance().getGrade("NA");
        }
    };


    protected long numericSum(List<IGrade> grades) {
        long sum = 0L;
        for (IGrade grade : grades) {
            sum += (long)((Integer)grade.getGradeValue()).intValue();
        }
        return sum;
    }

    public abstract IGrade average(List<IGrade> var1);
}

