/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.NationalIdCardAvoidanceQuestion;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.StorkAttributesList;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityAgreement;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityQuota;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityStudentDataBean;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.MobilityApplicationPeriod;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;

public class MobilityIndividualApplicationProcessBean
extends IndividualCandidacyProcessBean {
    private static final long serialVersionUID = 1L;
    private Set<CurricularCourse> selectedCurricularCourses;
    private Degree degree;
    ExecutionYear executionYear;
    private MobilityStudentDataBean mobilityStudentDataBean;
    private boolean toAccessFenix;
    private Boolean validatedByGri;
    private Boolean validatedByErasmusCoordinator;
    private String alertSubject;
    private String alertBody;
    private Boolean createAlert;
    private Boolean sendEmail;
    private StorkAttributesList personalFieldsFromStork;
    private NationalIdCardAvoidanceQuestion nationalIdCardAvoidanceQuestion;
    private String idCardAvoidanceOtherReason;

    public MobilityIndividualApplicationProcessBean() {
        this.setCandidacyDate(new LocalDate());
        this.initializeDocumentUploadBeans();
        this.setSelectedCurricularCourses(new HashSet<CurricularCourse>());
        this.setSendEmail(false);
        this.toAccessFenix = false;
    }

    public MobilityIndividualApplicationProcessBean(CandidacyProcess candidacyProcess) {
        this();
        MobilityApplicationProcess map = (MobilityApplicationProcess)((Object)candidacyProcess);
        this.setCandidacyProcess((CandidacyProcess)((Object)map));
        this.setMobilityStudentDataBean(new MobilityStudentDataBean(this.getCandidacyProcess(), map.getForSemester()));
    }

    public MobilityIndividualApplicationProcessBean(MobilityIndividualApplicationProcess process2) {
        this.setIndividualCandidacyProcess((IndividualCandidacyProcess)((Object)process2));
        this.setCandidacyProcess(process2.getCandidacyProcess());
        this.setSelectedCurricularCourses(new HashSet<CurricularCourse>(process2.getCandidacy().getCurricularCoursesSet()));
        this.setMobilityStudentDataBean(new MobilityStudentDataBean(process2.getCandidacy().getMobilityStudentData()));
        this.setCandidacyDate(process2.getCandidacyDate());
        this.setObservations(process2.getCandidacy().getObservations());
        this.setDegree(process2.getCandidacySelectedDegree());
        this.setValidatedByErasmusCoordinator(process2.getValidatedByMobilityCoordinator());
        this.setValidatedByGri(process2.getValidatedByGri());
        this.setNationalIdCardAvoidanceQuestion(process2.getCandidacy().getNationalIdCardAvoidanceQuestion());
        this.setIdCardAvoidanceOtherReason(process2.getCandidacy().getIdCardAvoidanceOtherReason());
    }

    @Override
    protected void initializeDocumentUploadBeans() {
        this.setPhotoDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.PHOTO));
    }

    public Set<CurricularCourse> getSelectedCurricularCourses() {
        return this.selectedCurricularCourses;
    }

    public void setSelectedCurricularCourses(Set<CurricularCourse> selectedCurricularCourses) {
        this.selectedCurricularCourses = selectedCurricularCourses;
    }

    public MobilityStudentDataBean getMobilityStudentDataBean() {
        return this.mobilityStudentDataBean;
    }

    public void setMobilityStudentDataBean(MobilityStudentDataBean mobilityStudentDataBean) {
        this.mobilityStudentDataBean = mobilityStudentDataBean;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public void addCurricularCourse(CurricularCourse curricularCourse) {
        for (CurricularCourse course : this.getSelectedCurricularCourses()) {
            if (!curricularCourse.isEquivalent(course)) continue;
            return;
        }
        this.getSelectedCurricularCourses().add(curricularCourse);
    }

    public void removeCurricularCourse(CurricularCourse curricularCourse) {
        this.getSelectedCurricularCourses().remove((Object)curricularCourse);
    }

    public List<CurricularCourse> getSortedSelectedCurricularCourses() {
        ArrayList<CurricularCourse> curricularCourses = new ArrayList<CurricularCourse>(this.getSelectedCurricularCourses());
        Collections.sort(curricularCourses, CurricularCourse.COMPARATOR_BY_NAME);
        return curricularCourses;
    }

    public boolean isToAccessFenix() {
        return this.toAccessFenix;
    }

    public void willAccessFenix() {
        this.toAccessFenix = true;
    }

    public Boolean getValidatedByGri() {
        return this.validatedByGri;
    }

    public void setValidatedByGri(Boolean validatedByGri) {
        this.validatedByGri = validatedByGri;
    }

    public Boolean getValidatedByErasmusCoordinator() {
        return this.validatedByErasmusCoordinator;
    }

    public void setValidatedByErasmusCoordinator(Boolean validatedByErasmusCoordinator) {
        this.validatedByErasmusCoordinator = validatedByErasmusCoordinator;
    }

    public String getAlertSubject() {
        return this.alertSubject;
    }

    public void setAlertSubject(String alertSubject) {
        this.alertSubject = alertSubject;
    }

    public String getAlertBody() {
        return this.alertBody;
    }

    public void setAlertBody(String alertBody) {
        this.alertBody = alertBody;
    }

    public Boolean getCreateAlert() {
        return this.createAlert;
    }

    public void setCreateAlert(Boolean createAlert) {
        this.createAlert = createAlert;
    }

    public Boolean getSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(Boolean sendEmail2) {
        this.sendEmail = sendEmail2;
    }

    public StorkAttributesList getPersonalFieldsFromStork() {
        return this.personalFieldsFromStork;
    }

    public void setPersonalFieldsFromStork(StorkAttributesList value) {
        this.personalFieldsFromStork = value;
    }

    public NationalIdCardAvoidanceQuestion getNationalIdCardAvoidanceQuestion() {
        return this.nationalIdCardAvoidanceQuestion;
    }

    public void setNationalIdCardAvoidanceQuestion(NationalIdCardAvoidanceQuestion nationalIdCardAvoidanceQuestion) {
        this.nationalIdCardAvoidanceQuestion = nationalIdCardAvoidanceQuestion;
    }

    public String getIdCardAvoidanceOtherReason() {
        return this.idCardAvoidanceOtherReason;
    }

    public void setIdCardAvoidanceOtherReason(String idCardAvoidanceOtherReason) {
        this.idCardAvoidanceOtherReason = idCardAvoidanceOtherReason;
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public MobilityQuota determineMobilityQuota() {
        MobilityApplicationPeriod period = (MobilityApplicationPeriod)((Object)this.getCandidacyProcess().getCandidacyPeriod());
        MobilityAgreement agreement = this.getMobilityStudentDataBean().getMobilityAgreement();
        Degree selectedDegree = null;
        if (this.getDegree() == null) {
            selectedDegree = this.getSelectedCurricularCourses() != null && !this.getSelectedCurricularCourses().isEmpty() ? this.getMostDominantDegreeFromCourses() : null;
        } else if (this.getSelectedCurricularCourses() == null || this.getSelectedCurricularCourses().isEmpty() || !this.getSelectedCurricularCourses().isEmpty() && this.getDegree() == this.getMostDominantDegreeFromCourses() || this.getMobilityStudentDataBean().getSelectedMobilityProgram().getRegistrationProtocol().isOnlyAllowedDegreeEnrolment()) {
            selectedDegree = this.getDegree();
        } else {
            throw new DomainException("error.mobility.application.process.courses.and.degree.selection.dont.match", new String[0]);
        }
        MobilityQuota quota = period.getAssociatedOpening(selectedDegree, agreement);
        if (quota == null) {
            throw new DomainException("error.mobility.application.process.no.courses.from.one.degree.selected", new String[0]);
        }
        return quota;
    }

    private Degree getMostDominantDegreeFromCourses() {
        HashMap coursesMappedByDegree = new HashMap();
        for (CurricularCourse curricularCourse : this.getSelectedCurricularCourses()) {
            if (!coursesMappedByDegree.containsKey(curricularCourse.getDegree())) {
                coursesMappedByDegree.put(curricularCourse.getDegree(), new ArrayList());
            }
            ((List)coursesMappedByDegree.get(curricularCourse.getDegree())).add(curricularCourse);
        }
        ArrayList<Degree> candidateDegrees = new ArrayList<Degree>();
        int max = 0;
        for (Degree degree : coursesMappedByDegree.keySet()) {
            if (((List)coursesMappedByDegree.get(degree)).size() > max) {
                candidateDegrees = new ArrayList();
                candidateDegrees.add(degree);
                max = ((List)coursesMappedByDegree.get(degree)).size();
                continue;
            }
            if (((List)coursesMappedByDegree.get(degree)).size() != max) continue;
            candidateDegrees.add(degree);
        }
        if (candidateDegrees.size() == 0) {
            return null;
        }
        if (candidateDegrees.size() > 1) {
            throw new DomainException("error.mobility.application.process.invalid.dominant.degree", new String[0]);
        }
        return (Degree)candidateDegrees.iterator().next();
    }

    public List<Degree> getPossibleDegreesFromSelectedUniversity() {
        if (this.getMobilityStudentDataBean().getSelectedUniversity() == null) {
            return new ArrayList<Degree>();
        }
        MobilityApplicationPeriod period = (MobilityApplicationPeriod)((Object)this.getCandidacyProcess().getCandidacyPeriod());
        return period.getPossibleDegreesAssociatedToAgreement(this.getMobilityStudentDataBean().getMobilityAgreement());
    }

    public String getSelectedCourseNameForView() {
        try {
            MobilityQuota quota = this.determineMobilityQuota();
            return quota.getDegree().getNameI18N().getContent();
        }
        catch (DomainException e) {
            return BundleUtil.getString((String)"resources.CandidateResources", (String)e.getMessage(), (String[])new String[0]);
        }
    }

    @Override
    public boolean isErasmus() {
        return true;
    }
}

