/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.accounting.paymentCodes.IndividualCandidacyPaymentCode;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessState;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess_Base;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyState;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.CandidacyProcessCandidacyPeriod;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.person.ChoosePersonBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;

public abstract class IndividualCandidacyProcess
extends IndividualCandidacyProcess_Base {
    public static final Comparator<IndividualCandidacyProcess> COMPARATOR_BY_CANDIDACY_PERSON = new Comparator<IndividualCandidacyProcess>(){

        @Override
        public int compare(IndividualCandidacyProcess o1, IndividualCandidacyProcess o2) {
            return IndividualCandidacyPersonalDetails.COMPARATOR_BY_NAME_AND_ID.compare(o1.getPersonalDetails(), o2.getPersonalDetails());
        }
    };

    protected IndividualCandidacyProcess() {
        this.setAccessHash(RandomStringUtils.random((int)16, (boolean)true, (boolean)true));
        this.setProcessChecked(Boolean.FALSE);
    }

    protected void init(IndividualCandidacyProcessBean bean) {
        this.checkParameters(bean.getCandidacyProcess());
        if (bean.getPublicCandidacyHashCode() == null) {
            throw new DomainException("error.IndividualCandidacy.hash.code.is.null", new String[0]);
        }
        if (this.existsIndividualCandidacyProcessForDocumentId(bean.getCandidacyProcess(), bean.getPersonBean().getIdDocumentType(), bean.getPersonBean().getDocumentIdNumber())) {
            throw new DomainException("error.IndividualCandidacy.exists.for.same.document.id", new String[0]);
        }
        this.setCandidacyProcess(bean.getCandidacyProcess());
        this.createIndividualCandidacy(bean);
        this.setCandidacyHashCode(bean.getPublicCandidacyHashCode());
        this.setCandidacyDocumentFiles(bean);
        this.setProcessCodeForThisIndividualCandidacy(bean.getCandidacyProcess());
    }

    protected boolean existsIndividualCandidacyProcessForDocumentId(CandidacyProcess process2, IDDocumentType documentType, String identification) {
        return process2.getOpenChildProcessByDocumentId(documentType, identification) != null;
    }

    protected void setProcessCodeForThisIndividualCandidacy(CandidacyProcess process2) {
        CandidacyProcessCandidacyPeriod period = process2.getCandidacyPeriod();
        String beginExecutionYear = String.valueOf(period.getExecutionInterval().getBeginDateYearMonthDay().get(DateTimeFieldType.year())).substring(2, 4);
        String endExecutionYear = String.valueOf(period.getExecutionInterval().getEndDateYearMonthDay().get(DateTimeFieldType.year())).substring(2, 4);
        this.setProcessCode(beginExecutionYear + endExecutionYear + this.getExternalId());
    }

    protected void setCandidacyDocumentFiles(IndividualCandidacyProcessBean bean) {
        if (bean.getPhotoDocument() != null) {
            this.bindIndividualCandidacyDocumentFile(bean.getPhotoDocument());
        }
    }

    protected abstract void checkParameters(CandidacyProcess var1);

    protected abstract void createIndividualCandidacy(IndividualCandidacyProcessBean var1);

    public ExecutionInterval getCandidacyExecutionInterval() {
        return this.getCandidacyProcess() != null ? this.getCandidacyProcess().getCandidacyExecutionInterval() : null;
    }

    public boolean isFor(ExecutionInterval executionInterval) {
        return this.getCandidacyExecutionInterval() == executionInterval;
    }

    public DateTime getCandidacyStart() {
        return this.getCandidacyProcess() != null ? this.getCandidacyProcess().getCandidacyStart() : null;
    }

    public DateTime getCandidacyEnd() {
        return this.getCandidacyProcess() != null ? this.getCandidacyProcess().getCandidacyEnd() : null;
    }

    public LocalDate getCandidacyDate() {
        return this.getCandidacy().getCandidacyDate();
    }

    public boolean hasOpenCandidacyPeriod() {
        return this.getCandidacyProcess() != null && this.getCandidacyProcess().hasOpenCandidacyPeriod();
    }

    public boolean hasOpenCandidacyPeriod(DateTime date) {
        return this.getCandidacyProcess() != null && this.getCandidacyProcess().hasOpenCandidacyPeriod(date);
    }

    public CandidacyProcessState getState() {
        return this.getCandidacyProcess() != null ? this.getCandidacyProcess().getState() : null;
    }

    public boolean isInStandBy() {
        return this.getCandidacyProcess() != null && this.getCandidacyProcess().isInStandBy();
    }

    public boolean isSentToJury() {
        return this.getCandidacyProcess() != null && this.getCandidacyProcess().isSentToJury();
    }

    public boolean isSentToCoordinator() {
        return this.getCandidacyProcess() != null && this.getCandidacyProcess().isSentToCoordinator();
    }

    public boolean isSentToScientificCouncil() {
        return this.getCandidacyProcess() != null && this.getCandidacyProcess().isSentToScientificCouncil();
    }

    public boolean isPublished() {
        return this.getCandidacyProcess() != null && this.getCandidacyProcess().isPublished();
    }

    protected boolean hasAnyPaymentForCandidacy() {
        return this.getCandidacy().hasAnyPayment();
    }

    protected void cancelCandidacy(Person person) {
        this.getCandidacy().cancel(person);
    }

    protected void rejectCandidacy(Person person) {
        this.getCandidacy().reject(person);
    }

    protected void revertToStandBy(Person person) {
        this.getCandidacy().revertToStandBy(person);
    }

    public IndividualCandidacyState getCandidacyState() {
        return this.getCandidacy().getState();
    }

    public boolean isCandidacyValid() {
        return !this.isCandidacyCancelled() && (this.isEventCanceledOrNoEvent() || this.isCandidacyDebtPayed());
    }

    private boolean isEventCanceledOrNoEvent() {
        return this.getCandidacy().getEvent() == null || this.getCandidacy().getEvent().isCancelled();
    }

    public boolean isCandidacyInStandBy() {
        return this.getCandidacy().isInStandBy();
    }

    public boolean isCandidacyAccepted() {
        return this.getCandidacy().isAccepted();
    }

    public boolean isCandidacyNotAccepted() {
        return this.getCandidacy().isNotAccepted();
    }

    public boolean isCandidacyRejected() {
        return this.getCandidacy().isRejected();
    }

    public boolean isCandidacyCancelled() {
        return this.getCandidacy().isCancelled();
    }

    public boolean isCandidacyDebtPayed() {
        return this.getCandidacy().isDebtPayed();
    }

    public IndividualCandidacyPersonalDetails getPersonalDetails() {
        return this.getCandidacy().getPersonalDetails();
    }

    public boolean hasCandidacyPerson() {
        return this.getPersonalDetails() != null;
    }

    public Student getCandidacyStudent() {
        return this.getPersonalDetails().getStudent();
    }

    public boolean hasCandidacyStudent() {
        return this.getCandidacyStudent() != null;
    }

    public Registration getCandidacyRegistration() {
        return this.getCandidacy().getRegistration();
    }

    public boolean hasRegistrationForCandidacy() {
        return this.getCandidacy().getRegistration() != null;
    }

    public String getDisplayName() {
        return BundleUtil.getString((String)"resources.CaseHandlingResources", (String)((Object)((Object)this)).getClass().getSimpleName(), (String[])new String[0]);
    }

    protected void editPersonalCandidacyInformation(PersonBean personBean) {
        this.getCandidacy().editPersonalCandidacyInformationPublic(personBean);
    }

    protected void editPersonalCandidacyInformationPublic(PersonBean personBean) {
        this.getCandidacy().editPersonalCandidacyInformationPublic(personBean);
    }

    public static IndividualCandidacyProcess findIndividualCandidacyProcess(Class<? extends IndividualCandidacyProcess> individualCandidacyProcessClass, String email, String accessHash) {
        if (StringUtils.isEmpty((String)email) || StringUtils.isEmpty((String)accessHash)) {
            return null;
        }
        Set<IndividualCandidacyProcess> candidacies = IndividualCandidacyProcess.getAllInstancesOf(individualCandidacyProcessClass);
        for (IndividualCandidacyProcess individualCandidacyProcess : candidacies) {
            if (!email.equals(individualCandidacyProcess.getPersonalDetails().getEmail()) || !accessHash.equals(individualCandidacyProcess.getAccessHash())) continue;
            return individualCandidacyProcess;
        }
        return null;
    }

    public static <T extends IndividualCandidacyProcess> T findIndividualCandidacyProcessByCode(Class<T> individualCandidacyProcessClass, String processCode) {
        Set<IndividualCandidacyProcess> candidacies = IndividualCandidacyProcess.getAllInstancesOf(individualCandidacyProcessClass);
        for (IndividualCandidacyProcess process2 : candidacies) {
            if (!processCode.equals(process2.getProcessCode())) continue;
            return (T)((Object)process2);
        }
        return null;
    }

    public IndividualCandidacyDocumentFile getPhoto() {
        IndividualCandidacyDocumentFile photo = this.getActiveFileForType(IndividualCandidacyDocumentFileType.PHOTO);
        return photo;
    }

    public IndividualCandidacyDocumentFile getActiveFileForType(IndividualCandidacyDocumentFileType type) {
        for (IndividualCandidacyDocumentFile document : this.getCandidacy().getDocumentsSet()) {
            if (!document.getCandidacyFileType().equals((Object)type) || !document.getCandidacyFileActive().booleanValue()) continue;
            return document;
        }
        return null;
    }

    public List<IndividualCandidacyDocumentFile> getAllFilesForType(IndividualCandidacyDocumentFileType type) {
        ArrayList<IndividualCandidacyDocumentFile> files = new ArrayList<IndividualCandidacyDocumentFile>();
        for (IndividualCandidacyDocumentFile document : this.getCandidacy().getDocumentsSet()) {
            if (!document.getCandidacyFileType().equals((Object)type)) continue;
            files.add(document);
        }
        return files;
    }

    public void bindIndividualCandidacyDocumentFile(CandidacyProcessDocumentUploadBean uploadBean) {
        if (uploadBean.getDocumentFile() != null) {
            this.executeOperationsBeforeDocumentFileBinding(uploadBean.getDocumentFile());
            uploadBean.getDocumentFile().addIndividualCandidacy(this.getCandidacy());
        }
    }

    protected abstract void executeOperationsBeforeDocumentFileBinding(IndividualCandidacyDocumentFile var1);

    public abstract List<IndividualCandidacyDocumentFileType> getMissingRequiredDocumentFiles();

    public List<ExecutionCourse> getMissingShifts() {
        HashSet<ExecutionCourse> missingShifts = new HashSet<ExecutionCourse>();
        for (Attends attends : this.getCandidacy().getPersonalDetails().getPerson().getCurrentAttends()) {
            if (attends.hasAllShiftEnrolments()) continue;
            missingShifts.add(attends.getExecutionCourse());
        }
        return new ArrayList<ExecutionCourse>(missingShifts);
    }

    public boolean isProcessMissingRequiredDocumentFiles() {
        return !this.getMissingRequiredDocumentFiles().isEmpty();
    }

    public List<IndividualCandidacyDocumentFile> getActiveDocumentFiles() {
        ArrayList<IndividualCandidacyDocumentFile> documentList = new ArrayList<IndividualCandidacyDocumentFile>();
        CollectionUtils.select((Collection)this.getCandidacy().getDocumentsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                IndividualCandidacyDocumentFile file = (IndividualCandidacyDocumentFile)((Object)arg0);
                return file.getCandidacyFileActive();
            }
        }, documentList);
        return documentList;
    }

    public Boolean getAllRequiredFilesUploaded() {
        return this.getMissingRequiredDocumentFiles().isEmpty();
    }

    public Boolean getCandidacyHasVatDocument() {
        return this.getActiveFileForType(IndividualCandidacyDocumentFileType.VAT_CARD_DOCUMENT) != null;
    }

    public abstract Boolean isCandidacyProcessComplete();

    public Boolean isCandidacyInternal() {
        return this.getCandidacy().isCandidacyInternal();
    }

    public Boolean getIsCandidacyInternal() {
        return this.isCandidacyInternal();
    }

    public void bindPerson(ChoosePersonBean choosePersonBean) {
        this.getCandidacy().bindPerson(choosePersonBean);
    }

    public IndividualCandidacyPaymentCode getAssociatedPaymentCode() {
        if (this.getCandidacy().getEvent() != null) {
            return (IndividualCandidacyPaymentCode)((Object)(this.getCandidacy().getEvent().getAllPaymentCodes().isEmpty() ? null : (AccountingEventPaymentCode)((Object)this.getCandidacy().getEvent().getAllPaymentCodes().iterator().next())));
        }
        return null;
    }

    public Boolean getIsCandidateWithRoles() {
        return this.getCandidacy().getPersonalDetails().hasAnyRole();
    }

    protected void editCandidacyHabilitations(IndividualCandidacyProcessBean bean) {
        this.getCandidacy().editFormationEntries(bean.getFormationConcludedBeanList(), bean.getFormationNonConcludedBeanList());
    }

    protected void editPrecedentDegreeInformation(IndividualCandidacyProcessBean bean) {
        this.getCandidacy().editPrecedentDegreeInformation(bean);
    }

    private static Set<IndividualCandidacyProcess> getAllInstancesOf(Class<? extends IndividualCandidacyProcess> type) {
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Bennu.getInstance().getProcessesSet(), type));
    }
}

