/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.workflow;

import java.util.Set;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.candidacy.degree.ShiftDistributionEntry;
import org.fenixedu.academic.domain.candidacy.workflow.CandidacyOperation;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import org.joda.time.YearMonthDay;
import pt.ist.fenixframework.DomainObject;

public class RegistrationOperation
extends CandidacyOperation {
    private static final long serialVersionUID = 1L;

    public RegistrationOperation(Set<RoleType> roleTypes, Candidacy candidacy) {
        super(roleTypes, candidacy);
    }

    @Override
    protected void internalExecute() {
        ExecutionDegree executionDegree = this.getExecutionDegree();
        Registration registration = this.createRegistration();
        this.enrolStudentInCurricularCourses(executionDegree, registration);
        this.associateShiftsFor(registration);
        Signal.emit((String)"academic.candidacy.registration.created", (Object)((Object)new RegistrationCreatedByCandidacy(registration, this.getStudentCandidacy())));
    }

    protected void associateShiftsFor(Registration registration) {
        if (this.getExecutionYear().getShiftDistribution() != null) {
            for (ShiftDistributionEntry shiftEntry : this.getExecutionDegree().getNextFreeShiftDistributions()) {
                shiftEntry.setDistributed(Boolean.TRUE);
                shiftEntry.getShift().addStudents(registration);
                this.correctExecutionCourseIfNecessary(registration, shiftEntry.getShift());
            }
        }
    }

    private void correctExecutionCourseIfNecessary(Registration registration, Shift shift) {
        StudentCurricularPlan studentCurricularPlan = registration.getActiveStudentCurricularPlan();
        ExecutionSemester semester = ExecutionSemester.readActualExecutionSemester();
        ExecutionCourse executionCourse = shift.getExecutionCourse();
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            Enrolment enrolment = studentCurricularPlan.findEnrolmentFor(curricularCourse, semester);
            if (enrolment == null) continue;
            Attends attends = enrolment.getAttendsFor(semester);
            if (attends == null || attends.isFor(executionCourse)) break;
            attends.setDisciplinaExecucao(executionCourse);
            break;
        }
    }

    private ExecutionDegree getExecutionDegree() {
        return this.getStudentCandidacy().getExecutionDegree();
    }

    protected ExecutionYear getExecutionYear() {
        return this.getExecutionDegree().getExecutionYear();
    }

    protected void enrolStudentInCurricularCourses(ExecutionDegree executionDegree, Registration registration) {
        ExecutionSemester executionSemester = this.getExecutionPeriod();
        StudentCurricularPlan studentCurricularPlan = StudentCurricularPlan.createBolonhaStudentCurricularPlan(registration, executionDegree.getDegreeCurricularPlan(), new YearMonthDay(), executionSemester);
        studentCurricularPlan.createFirstTimeStudentEnrolmentsFor(executionSemester, this.getCurrentUsername());
        registration.updateEnrolmentDate(executionSemester.getExecutionYear());
    }

    private String getCurrentUsername() {
        if (Authenticate.getUser() != null) {
            return AccessControl.getPerson().getUsername();
        }
        return this.getStudentCandidacy().getPerson().getUsername();
    }

    private ExecutionSemester getExecutionPeriod() {
        return this.getExecutionYear().getExecutionSemesterFor(1);
    }

    protected Registration createRegistration() {
        Registration registration = new Registration(this.getStudentCandidacy().getPerson(), this.getStudentCandidacy());
        this.getStudentCandidacy().getPrecedentDegreeInformation().setRegistration(registration);
        this.getStudentCandidacy().getPrecedentDegreeInformation().getPersonalIngressionData().setStudent(this.getStudentCandidacy().getPerson().getStudent());
        registration.getStudent().setPersonalDataAuthorization(this.getStudentCandidacy().getStudentPersonalDataAuthorizationChoice());
        registration.getStudent().setStudentPersonalDataStudentsAssociationAuthorization(this.getStudentCandidacy().getStudentPersonalDataStudentsAssociationAuthorization());
        if (this.getStudentCandidacy().getApplyForResidence().booleanValue()) {
            registration.getStudent().setResidenceCandidacyForCurrentExecutionYear(this.getStudentCandidacy().getNotesAboutResidenceAppliance());
        }
        return registration;
    }

    private StudentCandidacy getStudentCandidacy() {
        return (StudentCandidacy)((Object)this.getCandidacy());
    }

    @Override
    public CandidacyOperationType getType() {
        return CandidacyOperationType.REGISTRATION;
    }

    @Override
    public boolean isInput() {
        return false;
    }

    public static class RegistrationCreatedByCandidacy
    extends DomainObjectEvent<Registration> {
        private final StudentCandidacy candidacy;

        public RegistrationCreatedByCandidacy(Registration instance, StudentCandidacy candidacy) {
            super((DomainObject)instance);
            this.candidacy = candidacy;
        }

        public StudentCandidacy getCandidacy() {
            return this.candidacy;
        }
    }
}

