/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.dfa;

import java.util.Collection;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.dfa.DfaRegistrationEvent;
import org.fenixedu.academic.domain.accounting.postingRules.FixedAmountWithPenaltyPR;
import org.fenixedu.academic.domain.accounting.postingRules.dfa.DfaRegistrationPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class DfaRegistrationPR
extends DfaRegistrationPR_Base {
    private DfaRegistrationPR() {
    }

    public DfaRegistrationPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money fixedAmount, Money fixedAmountPenalty) {
        this();
        super.init(EntryType.REGISTRATION_FEE, EventType.DFA_REGISTRATION, startDate, endDate, serviceAgreementTemplate, fixedAmount, fixedAmountPenalty);
    }

    protected boolean hasPenalty(Event event, DateTime when) {
        return this.hasPenaltyForRegistration((DfaRegistrationEvent)((Object)event)) && !this.hasPayedPenaltyForCandidacy((DfaRegistrationEvent)((Object)event));
    }

    private boolean hasPenaltyForRegistration(DfaRegistrationEvent dfaRegistrationEvent) {
        return dfaRegistrationEvent.hasRegistrationPeriodInDegreeCurricularPlan() && !dfaRegistrationEvent.getRegistrationPeriodInDegreeCurricularPlan().containsDate(dfaRegistrationEvent.getRegistrationDate());
    }

    private boolean hasPayedPenaltyForCandidacy(DfaRegistrationEvent dfaRegistrationEvent) {
        return dfaRegistrationEvent.hasCandidacyPeriodInDegreeCurricularPlan() && !dfaRegistrationEvent.getCandidacyPeriodInDegreeCurricularPlan().containsDate(dfaRegistrationEvent.getCandidacyDate());
    }

    public FixedAmountWithPenaltyPR edit(Money fixedAmount, Money penaltyAmount) {
        this.deactivate();
        return new DfaRegistrationPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), fixedAmount, penaltyAmount);
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        this.checkPreconditionsToProcess(event);
        return super.internalProcess(user, entryDTOs, event, fromAccount, toAccount, transactionDetail);
    }

    private void checkPreconditionsToProcess(Event event) {
        DfaRegistrationEvent dfaRegistrationEvent = (DfaRegistrationEvent)((Object)event);
        if (!dfaRegistrationEvent.hasRegistrationPeriodInDegreeCurricularPlan()) {
            throw new DomainException("error.accounting.postingRules.dfa.DfaRegistrationPR.cannot.process.without.registration.period.defined", new String[0]);
        }
    }
}

