/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.paymentPlanRules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.FirstTimeInstitutionStudentsPaymentPlanRule;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.HasEnrolmentsForExecutionSemesterPaymentPlanRule;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.HasEnrolmentsOnlyInSecondSemesterPaymentPlanRule;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.IsAlienRule;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.IsPartialRegimePaymentPlanRule;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.PaymentPlanRule;
import org.fenixedu.academic.domain.accounting.paymentPlanRules.PaymentPlanRuleFactory;

public class PaymentPlanRuleManager {
    private static final Map<Class<? extends PaymentPlanRule>, PaymentPlanRule> rules = new HashMap<Class<? extends PaymentPlanRule>, PaymentPlanRule>();

    public static void register(Class<? extends PaymentPlanRule> clazz) {
        if (!PaymentPlanRuleManager.containsRuleFor(clazz)) {
            PaymentPlanRuleManager.register(PaymentPlanRuleFactory.create(clazz));
        }
    }

    public static void register(PaymentPlanRule paymentPlanRule) {
        if (!PaymentPlanRuleManager.containsRuleFor(paymentPlanRule)) {
            PaymentPlanRuleManager.putRule(paymentPlanRule);
        }
    }

    static boolean containsRuleFor(PaymentPlanRule paymentPlanRule) {
        return PaymentPlanRuleManager.containsRuleFor(paymentPlanRule.getClass());
    }

    public static boolean containsRuleFor(Class<? extends PaymentPlanRule> clazz) {
        return rules.containsKey(clazz);
    }

    public static PaymentPlanRule getRule(Class<? extends PaymentPlanRule> clazz) {
        return rules.get(clazz);
    }

    private static void putRule(PaymentPlanRule paymentPlanRule) {
        rules.put(paymentPlanRule.getClass(), paymentPlanRule);
    }

    public static Collection<PaymentPlanRule> getAllPaymentPlanRules() {
        return rules.values();
    }

    static {
        rules.put(HasEnrolmentsForExecutionSemesterPaymentPlanRule.class, new HasEnrolmentsForExecutionSemesterPaymentPlanRule());
        rules.put(HasEnrolmentsOnlyInSecondSemesterPaymentPlanRule.class, new HasEnrolmentsOnlyInSecondSemesterPaymentPlanRule());
        rules.put(IsPartialRegimePaymentPlanRule.class, new IsPartialRegimePaymentPlanRule());
        rules.put(FirstTimeInstitutionStudentsPaymentPlanRule.class, new FirstTimeInstitutionStudentsPaymentPlanRule());
        rules.put(IsAlienRule.class, new IsAlienRule());
    }
}

