/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.specializationDegree;

import org.fenixedu.academic.domain.CandidacyPeriodInDegreeCurricularPlan;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.RegistrationPeriodInDegreeCurricularPlan;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountType;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.specializationDegree.SpecializationDegreeRegistrationEvent_Base;
import org.fenixedu.academic.domain.accounting.serviceAgreementTemplates.AdministrativeOfficeServiceAgreementTemplate;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.LabelFormatter;
import org.joda.time.DateTime;

public class SpecializationDegreeRegistrationEvent
extends SpecializationDegreeRegistrationEvent_Base {
    private SpecializationDegreeRegistrationEvent() {
    }

    public SpecializationDegreeRegistrationEvent(AdministrativeOffice administrativeOffice, Person person, Registration registration) {
        this();
        this.init(administrativeOffice, person, registration);
    }

    private void init(AdministrativeOffice administrativeOffice, Person person, Registration registration) {
        super.init(administrativeOffice, EventType.SPECIALIZATION_DEGREE_REGISTRATION, person);
        this.checkParameters(registration);
        super.setRegistration(registration);
    }

    private void checkParameters(Registration registration) {
        if (registration == null) {
            throw new DomainException("error.accounting.events.dfa.DfaRegistrationEvent.registration.cannot.be.null", new String[0]);
        }
        if (registration.getDegreeType().isSpecializationDegree()) {
            throw new DomainException("error.accounting.events.specializationDegree.SpecializationDegreeRegistrationEvent.registrationType.incorrect", new String[0]);
        }
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" (").appendLabel(this.getDegree().getDegreeType().getName().getContent()).appendLabel(" - ").appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent()).appendLabel(" - ").appendLabel(this.getExecutionDegree().getExecutionYear().getYear()).appendLabel(")");
        return labelFormatter;
    }

    private ExecutionDegree getExecutionDegree() {
        return this.getRegistration().getStudentCandidacy().getExecutionDegree();
    }

    private Degree getDegree() {
        return this.getExecutionDegree().getDegree();
    }

    public PostingRule getPostingRule() {
        return this.getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getWhenOccured());
    }

    private AdministrativeOfficeServiceAgreementTemplate getServiceAgreementTemplate() {
        return this.getAdministrativeOffice().getServiceAgreementTemplate();
    }

    public Account getToAccount() {
        return this.getAdministrativeOffice().getUnit().getAccountBy(AccountType.INTERNAL);
    }

    protected Account getFromAccount() {
        return this.getPerson().getAccountBy(AccountType.EXTERNAL);
    }

    public void setRegistration(Registration registration) {
        throw new DomainException("error.accounting.events.dfa.SpecializationDegreeRegistrationEvent.cannot.modify.registration", new String[0]);
    }

    public DateTime getRegistrationDate() {
        return this.getRegistration().getStartDate().toDateTimeAtMidnight();
    }

    public RegistrationPeriodInDegreeCurricularPlan getRegistrationPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().getRegistrationPeriod(this.getExecutionYear());
    }

    public boolean hasRegistrationPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().hasRegistrationPeriodFor(this.getExecutionYear());
    }

    private ExecutionYear getExecutionYear() {
        return this.getExecutionDegree().getExecutionYear();
    }

    public CandidacyPeriodInDegreeCurricularPlan getCandidacyPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().getCandidacyPeriod(this.getExecutionYear());
    }

    public boolean hasCandidacyPeriodInDegreeCurricularPlan() {
        return this.getExecutionDegree().getDegreeCurricularPlan().hasCandidacyPeriodFor(this.getExecutionYear());
    }

    private StudentCandidacy getCandidacy() {
        return this.getRegistration().getStudentCandidacy();
    }

    public DateTime getCandidacyDate() {
        return this.getCandidacy().getCandidacyDate();
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent()).appendLabel(" - ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent()).appendLabel(" - ");
        labelFormatter.appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    public boolean isSpecializationDegreeRegistrationEvent() {
        return true;
    }
}

