/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.CertificateRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.CertificateRequest;
import org.fenixedu.academic.util.LabelFormatter;

public class CertificateRequestEvent
extends CertificateRequestEvent_Base {
    protected CertificateRequestEvent() {
    }

    public CertificateRequestEvent(AdministrativeOffice administrativeOffice, EventType eventType, Person person, CertificateRequest certificateRequest) {
        this();
        super.init(administrativeOffice, eventType, person, (RegistrationAcademicServiceRequest)((Object)certificateRequest));
    }

    public LabelFormatter getDescription() {
        LabelFormatter result = super.getDescription();
        this.fillDescription(result);
        return result;
    }

    public final LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        this.fillDescription(labelFormatter);
        if (this.getAcademicServiceRequest().getExecutionYear() != null) {
            labelFormatter.appendLabel(" - " + this.getExecutionYear().getYear());
        }
        return labelFormatter;
    }

    protected void fillDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (");
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent());
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel("label.in", "resources.ApplicationResources");
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent());
        labelFormatter.appendLabel(")");
    }

    public final Integer getNumberOfUnits() {
        return ((CertificateRequest)((Object)this.getAcademicServiceRequest())).getNumberOfUnits();
    }

    public final Integer getNumberOfPages() {
        return ((CertificateRequest)((Object)this.getAcademicServiceRequest())).getNumberOfPages();
    }

    public boolean isExemptionAppliable() {
        return true;
    }
}

