/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.ProfessorshipManagementLog;
import org.fenixedu.academic.domain.ProfessorshipPermissions_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class ProfessorshipPermissions
extends ProfessorshipPermissions_Base {
    public ProfessorshipPermissions(Professorship professorship) {
        this.setRootDomainObject(Bennu.getInstance());
        if (professorship == null) {
            throw new NullPointerException();
        }
        this.setProfessorship(professorship);
        this.setPersonalization(true);
        this.setSiteArchive(true);
        this.setAnnouncements(true);
        this.setSections(true);
        this.setSummaries(true);
        this.setStudents(true);
        this.setPlanning(true);
        this.setEvaluationSpecific(true);
        this.setEvaluationWorksheets(true);
        this.setEvaluationProject(true);
        this.setEvaluationTests(true);
        this.setEvaluationExams(true);
        this.setEvaluationFinal(true);
        this.setWorksheets(true);
        this.setGroups(true);
        this.setShift(true);
        this.setEvaluationMethod(true);
        this.setBibliografy(true);
    }

    public ProfessorshipPermissions copyPremissions(Professorship professorship) {
        ProfessorshipPermissions p = professorship.getPermissions();
        p.setPersonalization(this.getPersonalization());
        p.setSiteArchive(this.getSiteArchive());
        p.setAnnouncements(this.getAnnouncements());
        p.setSections(this.getSections());
        p.setSummaries(this.getSummaries());
        p.setStudents(this.getStudents());
        p.setPlanning(this.getPlanning());
        p.setEvaluationSpecific(this.getEvaluationSpecific());
        p.setEvaluationWorksheets(this.getEvaluationWorksheets());
        p.setEvaluationProject(this.getEvaluationProject());
        p.setEvaluationTests(this.getEvaluationTests());
        p.setEvaluationExams(this.getEvaluationExams());
        p.setWorksheets(this.getWorksheets());
        p.setGroups(this.getGroups());
        p.setShift(this.getShift());
        p.setEvaluationMethod(this.getEvaluationMethod());
        p.setBibliografy(this.getBibliografy());
        return p;
    }

    public void delete() {
        this.setRootDomainObject(null);
        this.setProfessorship(null);
        this.deleteDomainObject();
    }

    public void logEditProfessorship() {
        ExecutionCourse ec = this.getProfessorship().getExecutionCourse();
        ProfessorshipManagementLog.createLog(ec, "resources.MessagingResources", "log.executionCourse.professorship.edited", this.getProfessorship().getPerson().getPresentationName(), ec.getNome(), ec.getDegreePresentationString());
    }
}

