/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.exceptions.DomainException;

public class GradeDistribution {
    private static final String A = "A";
    private static final String B = "B";
    private static final String C = "C";
    private static final String D = "D";
    private static final String E = "E";
    private GradeScale gradeScale;
    private Map<Grade, Distribution> gradeDistribution;
    public static GradeDistribution IST_SCALE_20 = new GradeDistribution(GradeScale.TYPE20);
    public static GradeDistribution IST_SCALE_5 = new GradeDistribution(GradeScale.TYPE5);
    public static GradeDistribution ECTS_SCALE_20 = new GradeDistribution(GradeScale.TYPE20);

    private GradeDistribution(GradeScale gradeScale) {
        this.gradeScale = gradeScale;
        this.gradeDistribution = new ConcurrentHashMap<Grade, Distribution>();
    }

    public GradeScale getGradeScale() {
        return this.gradeScale;
    }

    public Distribution addDistribution(Grade grade, BigDecimal percentage, String ectsScale) {
        Distribution result = new Distribution(grade, percentage, ectsScale);
        this.gradeDistribution.put(grade, result);
        return result;
    }

    public Distribution getDistribution(Integer value) {
        return this.getDistribution(Grade.createGrade(String.valueOf(value), this.gradeScale));
    }

    public Distribution getDistribution(String value) {
        return this.getDistribution(Grade.createGrade(value, this.gradeScale));
    }

    public Distribution getDistribution(Grade grade) {
        if (grade.getGradeScale() != this.gradeScale) {
            throw new DomainException("GradeDistribution.invalid.grade.scale", new String[0]);
        }
        return this.gradeDistribution.get(grade);
    }

    static {
        IST_SCALE_20.addDistribution(Grade.createGrade("10", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), D);
        IST_SCALE_20.addDistribution(Grade.createGrade("11", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), D);
        IST_SCALE_20.addDistribution(Grade.createGrade("12", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), D);
        IST_SCALE_20.addDistribution(Grade.createGrade("13", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), D);
        IST_SCALE_20.addDistribution(Grade.createGrade("14", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), C);
        IST_SCALE_20.addDistribution(Grade.createGrade("15", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), C);
        IST_SCALE_20.addDistribution(Grade.createGrade("16", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), B);
        IST_SCALE_20.addDistribution(Grade.createGrade("17", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), B);
        IST_SCALE_20.addDistribution(Grade.createGrade("18", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), A);
        IST_SCALE_20.addDistribution(Grade.createGrade("19", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), A);
        IST_SCALE_20.addDistribution(Grade.createGrade("20", IST_SCALE_20.getGradeScale()), BigDecimal.valueOf(0L), A);
        IST_SCALE_5.addDistribution(Grade.createGrade("3", IST_SCALE_5.getGradeScale()), BigDecimal.valueOf(0L), C);
        IST_SCALE_5.addDistribution(Grade.createGrade("4", IST_SCALE_5.getGradeScale()), BigDecimal.valueOf(0L), B);
        IST_SCALE_5.addDistribution(Grade.createGrade("5", IST_SCALE_5.getGradeScale()), BigDecimal.valueOf(0L), A);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("10", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(10L), E);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("11", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(10L), E);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("12", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(10L), D);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("13", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(20L), C);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("14", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(30L), B);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("15", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(40L), B);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("16", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(50L), A);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("17", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(60L), A);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("18", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(70L), A);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("19", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(80L), A);
        ECTS_SCALE_20.addDistribution(Grade.createGrade("20", ECTS_SCALE_20.getGradeScale()), BigDecimal.valueOf(90L), A);
    }

    public static class Distribution {
        private Grade grade;
        private BigDecimal percentage;
        private String scale;

        public Distribution(Grade grade, BigDecimal percentage, String ectsScale) {
            this.grade = grade;
            this.percentage = percentage;
            this.scale = ectsScale;
        }

        public Grade getGrade() {
            return this.grade;
        }

        public BigDecimal getPercentage() {
            return this.percentage;
        }

        public String getScale() {
            return this.scale;
        }
    }
}

