/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.integration.tuitioninfo;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfo;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoSettings;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoType;
import org.fenixedu.academictreasury.domain.integration.tuitioninfo.ERPTuitionInfoTypeAcademicEntry;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;

public class ERPTuitionInfoBean
implements ITreasuryBean {
    private List<TreasuryTupleDataSourceBean> executionYearDataSource = Lists.newArrayList();
    private List<TreasuryTupleDataSourceBean> erpTuitionInfoTypeDataSource = Lists.newArrayList();
    private DebtAccount debtAccount = null;
    private ExecutionYear executionYear = null;
    private ERPTuitionInfoType erpTuitionInfoType = null;
    private String pendingErpTuitionInfoMessage;

    public ERPTuitionInfoBean(DebtAccount debtAccount) {
        this.debtAccount = debtAccount;
        this.updateData();
    }

    private Set<AcademicTreasuryEvent> tuitionAcademicTreasuryEvents() {
        if (this.executionYear == null) {
            return Sets.newHashSet();
        }
        return ((PersonCustomer)this.debtAccount.getCustomer()).getAssociatedPerson().getAcademicTreasuryEventSet().stream().filter(e -> e.isForRegistrationTuition() || e.isForStandaloneTuition() || e.isForExtracurricularTuition()).filter(e -> e.getExecutionYear() == this.executionYear).collect(Collectors.toSet());
    }

    private List<TreasuryTupleDataSourceBean> executionYearDataSource() {
        List<TreasuryTupleDataSourceBean> result = ExecutionYear.readNotClosedExecutionYears().stream().filter(e -> ERPTuitionInfoSettings.getInstance().getActiveExecutionYearsSet().contains(e)).sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList()).stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getQualifiedName())).collect(Collectors.toList());
        result.add(0, AcademicTreasuryConstants.SELECT_OPTION);
        return result;
    }

    private List<TreasuryTupleDataSourceBean> erpTuitionInfoTypeDataSource() {
        if (this.executionYear == null) {
            return Lists.newArrayList();
        }
        List<TreasuryTupleDataSourceBean> result = ERPTuitionInfoType.findActiveForExecutionYear(this.executionYear).filter(t -> this.isForAnyOfTreasuryEvent((ERPTuitionInfoType)((Object)t))).map(t -> new TreasuryTupleDataSourceBean(t.getExternalId(), t.getErpTuitionInfoProduct().getName())).sorted(TreasuryTupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList());
        result.add(0, AcademicTreasuryConstants.SELECT_OPTION);
        return result;
    }

    private boolean isForAnyOfTreasuryEvent(ERPTuitionInfoType t) {
        for (AcademicTreasuryEvent ev : this.tuitionAcademicTreasuryEvents()) {
            for (ERPTuitionInfoTypeAcademicEntry entry : t.getErpTuitionInfoTypeAcademicEntriesSet()) {
                if (entry.isForStandalone() || entry.isForExtracurricular()) {
                    return true;
                }
                if (!entry.isAppliedForRegistration(ev.getRegistration(), this.executionYear)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateData() {
        ERPTuitionInfo pendingErpTuitionInfo;
        this.executionYearDataSource = this.executionYearDataSource();
        this.erpTuitionInfoTypeDataSource = this.erpTuitionInfoTypeDataSource();
        this.pendingErpTuitionInfoMessage = "";
        if (this.getErpTuitionInfoType() != null && (pendingErpTuitionInfo = (ERPTuitionInfo)ERPTuitionInfo.findUniquePendingToExport((Customer)((PersonCustomer)this.getDebtAccount().getCustomer()), this.getErpTuitionInfoType()).orElse(null)) != null) {
            this.pendingErpTuitionInfoMessage = AcademicTreasuryConstants.academicTreasuryBundle("error.ERPTuitionInfo.pending.to.export", pendingErpTuitionInfo.getUiDocumentNumber());
        }
    }

    public DebtAccount getDebtAccount() {
        return this.debtAccount;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public ERPTuitionInfoType getErpTuitionInfoType() {
        return this.erpTuitionInfoType;
    }

    public List<TreasuryTupleDataSourceBean> getErpTuitionInfoTypeDataSource() {
        return this.erpTuitionInfoTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getExecutionYearDataSource() {
        return this.executionYearDataSource;
    }

    public String getpendingErpTuitionInfoMessage() {
        return this.pendingErpTuitionInfoMessage;
    }
}

