/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.customer.mbwaypaymentrequest;

import com.google.common.base.Strings;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.ui.customer.CustomerAccountingController;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.ui.accounting.managecustomer.MbwayPaymentRequestController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerAccountingController.class)
@RequestMapping(value={"/academictreasury/customer/mbwaypaymentrequest"})
public class CustomerAccountingMbwayPaymentRequestController
extends MbwayPaymentRequestController {
    public static final String CONTROLLER_URL = "/academictreasury/customer/mbwaypaymentrequest";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/academictreasury/customer/mbwaypaymentrequest/create";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/academictreasury/customer/mbwaypaymentrequest/createpostback";
    private static final String _SHOW_MBWAY_PAYMENT_REQUEST_URI = "/showmbwaypaymentrequest";
    public static final String SHOW_MBWAY_PAYMENT_REQUEST_URL = "/academictreasury/customer/mbwaypaymentrequest/showmbwaypaymentrequest";

    protected void checkPermissions(DebtAccount debtAccount, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        Person person = User.findByUsername((String)loggedUsername).getPerson();
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        if (PersonCustomer.findUnique(person, addressFiscalCountryCode, fiscalNumber).get() != debtAccount.getCustomer()) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]), model);
            throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]));
        }
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        return super.create(debtAccount, model);
    }

    @RequestMapping(value={"/createpostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model) {
        return super.createpostback(debtAccount, bean, model);
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String createpost(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model, RedirectAttributes redirectAttributes) {
        return super.createpost(debtAccount, bean, model, redirectAttributes);
    }

    @RequestMapping(value={"/showmbwaypaymentrequest/{debtAccountId}/{mbwayPaymentRequestId}"})
    public String showmbwaypaymentrequest(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="mbwayPaymentRequestId") MbwayPaymentRequest mbwayPaymentRequest, Model model) {
        return super.showmbwaypaymentrequest(debtAccount, mbwayPaymentRequest, model);
    }

    protected String readDebtAccountUrl(DebtAccount debtAccount) {
        return String.format("%s/%s", "/academictreasury/customer/viewaccount/account/read/", debtAccount.getExternalId());
    }

    protected String getCreateUrl() {
        return CREATE_URL;
    }

    protected String getCreatePostbackUrl() {
        return CREATEPOSTBACK_URL;
    }

    protected String getShowMbwayPaymentRequest() {
        return SHOW_MBWAY_PAYMENT_REQUEST_URL;
    }
}

