/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.services.RegistrationServices$callable$createPersonCustomer;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class RegistrationServices {
    private static final Logger logger;
    public static final Advice advice$createPersonCustomer;

    public static PersonCustomer createPersonCustomer(Person person) {
        return (PersonCustomer)((Object)advice$createPersonCustomer.perform((Callable)new RegistrationServices$callable$createPersonCustomer(person)));
    }

    static /* synthetic */ PersonCustomer advised$createPersonCustomer(Person p) {
        String fiscalCountryCode = PersonCustomer.addressCountryCode(p);
        String fiscalNumber = PersonCustomer.fiscalNumber(p);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            AcademicTreasuryDomainException exception = new AcademicTreasuryDomainException("error.RegistrationServices.createPersonCustomer.fiscalInformation.required", p.getName());
            logger.warn(exception.getLocalizedMessage());
            throw exception;
        }
        Optional<? extends PersonCustomer> findUnique = PersonCustomer.findUnique(p, fiscalCountryCode, fiscalNumber);
        if (findUnique.isPresent()) {
            return findUnique.get();
        }
        return PersonCustomer.create(p, fiscalCountryCode, fiscalNumber);
    }

    public void newRegistrationEvent(DomainObjectEvent<Registration> event) {
        Registration reg = (Registration)event.getInstance();
        if (reg.getStudent() != null) {
            RegistrationServices.createPersonCustomer(reg.getStudent().getPerson());
        }
    }

    static {
        advice$createPersonCustomer = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(RegistrationServices.class);
    }
}

