/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.services.PersonServices$callable$createPersonCustomer;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PersonServices {
    public static final Advice advice$createPersonCustomer = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static PersonCustomer createPersonCustomer(Person person) {
        return (PersonCustomer)((Object)advice$createPersonCustomer.perform((Callable)new PersonServices$callable$createPersonCustomer(person)));
    }

    static /* synthetic */ PersonCustomer advised$createPersonCustomer(Person p) {
        String addressFiscalCountryCode = PersonCustomer.addressCountryCode(p);
        String fiscalNumber = PersonCustomer.fiscalNumber(p);
        if (Strings.isNullOrEmpty((String)addressFiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new AcademicTreasuryDomainException("error.PersonCustomer.fiscalInformation.required", new String[0]);
        }
        Optional<? extends PersonCustomer> findUnique = PersonCustomer.findUnique(p, addressFiscalCountryCode, fiscalNumber);
        if (findUnique.isPresent()) {
            return findUnique.get();
        }
        return PersonCustomer.create(p, addressFiscalCountryCode, fiscalNumber);
    }

    public static boolean isAcademicalActsBlocked(Person person, LocalDate when) {
        if (AcademicActBlockingSuspension.isBlockingSuspended(person, when)) {
            return false;
        }
        for (PersonCustomer personCustomer : PersonCustomer.find(person).collect(Collectors.toSet())) {
            if (!personCustomer.isBlockingAcademicalActs(when)) continue;
            return true;
        }
        return false;
    }

    @Subscribe
    public void newPersonEvent(DomainObjectEvent<Person> event) {
        Person p = (Person)event.getInstance();
        PersonServices.createPersonCustomer((Person)event.getInstance());
    }
}

