/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.services;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataByExecutionYear;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.joda.time.LocalDate;

public interface IAcademicTreasuryPlatformDependentServices {
    default public Set<DegreeType> readAllDegreeTypes() {
        return DegreeType.all().collect(Collectors.toSet());
    }

    default public Set<DegreeCurricularPlan> readAllDegreeCurricularPlansSet() {
        return Degree.readAllMatching(dt -> true).stream().flatMap(d -> d.getDegreeCurricularPlansSet().stream()).collect(Collectors.toSet());
    }

    default public Set<DegreeCurricularPlan> readDegreeCurricularPlansWithExecutionDegree(ExecutionYear executionYear, DegreeType degreeType) {
        return ExecutionDegree.getAllByExecutionYearAndDegreeType((ExecutionYear)executionYear, (DegreeType[])new DegreeType[]{degreeType}).stream().map(e -> e.getDegreeCurricularPlan()).collect(Collectors.toSet());
    }

    default public Set<CurricularYear> readAllCurricularYearsSet() {
        HashSet result = Sets.newHashSet();
        for (int i = 1; i <= 10; ++i) {
            if (CurricularYear.readByYear((Integer)i) == null) {
                return result;
            }
            result.add(CurricularYear.readByYear((Integer)i));
        }
        return result;
    }

    default public Set<IngressionType> readAllIngressionTypesSet() {
        return IngressionType.findAllByPredicate(i -> true).collect(Collectors.toSet());
    }

    default public Set<RegistrationProtocol> readAllRegistrationProtocol() {
        return RegistrationProtocol.findByPredicate(p -> true).collect(Collectors.toSet());
    }

    default public Set<StatuteType> readAllStatuteTypesSet() {
        return StatuteType.readAll((Predicate[])new Predicate[]{s -> true}).collect(Collectors.toSet());
    }

    default public Set<Person> readAllPersonsSet() {
        return Party.getPartysSet(Person.class);
    }

    public String fiscalCountry(Person var1);

    public String fiscalNumber(Person var1);

    public boolean isFrontOfficeMember(String var1, FinantialEntity var2);

    public boolean isBackOfficeMember(String var1, FinantialEntity var2);

    public boolean isAllowToModifySettlements(String var1, FinantialEntity var2);

    public boolean isAllowToModifyInvoices(String var1, FinantialEntity var2);

    public Set<Degree> readDegrees(FinantialEntity var1);

    public FinantialEntity finantialEntityOfDegree(Degree var1, LocalDate var2);

    public Set<String> getFrontOfficeMemberUsernames(FinantialEntity var1);

    public Set<String> getBackOfficeMemberUsernames(FinantialEntity var1);

    public String localizedNameOfDegreeType(DegreeType var1);

    public String localizedNameOfStatuteType(StatuteType var1);

    public String localizedNameOfEnrolment(Enrolment var1);

    public String localizedNameOfEnrolment(Enrolment var1, Locale var2);

    default public RegistrationDataByExecutionYear findRegistrationDataByExecutionYear(Registration registration, ExecutionYear executionYear) {
        if (registration == null || executionYear == null) {
            return null;
        }
        return registration.getRegistrationDataByExecutionYearSet().stream().filter(r -> r.getExecutionYear() == executionYear).findFirst().orElse(null);
    }

    public IngressionType ingression(Registration var1);

    public RegistrationRegimeType registrationRegimeType(Registration var1, ExecutionYear var2);

    public Set<StatuteType> statutesTypesValidOnAnyExecutionSemesterFor(Student var1, ExecutionYear var2);

    default public Stream<AdministrativeOffice> findAdministrativeOfficesByPredicate(Predicate<AdministrativeOffice> predicate) {
        return Bennu.getInstance().getAdministrativeOfficesSet().stream().filter(predicate);
    }
}

