/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.dto.tariff;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CurricularYear;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.candidacy.IngressionType;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.student.RegistrationProtocol;
import org.fenixedu.academic.domain.student.RegistrationRegimeType;
import org.fenixedu.academic.domain.student.StatuteType;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tuition.EctsCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionCalculationType;
import org.fenixedu.academictreasury.domain.tuition.TuitionInstallmentTariff;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlan;
import org.fenixedu.academictreasury.domain.tuition.TuitionPaymentPlanGroup;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.joda.time.LocalDate;

public class TuitionPaymentPlanBean
implements Serializable,
ITreasuryBean {
    private static final long serialVersionUID = 1L;
    private FinantialEntity finantialEntity;
    private Product product;
    private TuitionPaymentPlanGroup tuitionPaymentPlanGroup;
    private ExecutionYear executionYear;
    private DegreeType degreeType;
    private Set<DegreeCurricularPlan> degreeCurricularPlans = Sets.newHashSet();
    private boolean showAllDcps;
    private boolean defaultPaymentPlan;
    private RegistrationRegimeType registrationRegimeType;
    private RegistrationProtocol registrationProtocol;
    private IngressionType ingression;
    private CurricularYear curricularYear;
    private ExecutionInterval executionSemester;
    private boolean firstTimeStudent;
    private boolean customized;
    private StatuteType statuteType;
    private DebtAccount payorDebtAccount;
    private String name;
    private boolean withLaboratorialClasses;
    private List<TreasuryTupleDataSourceBean> executionYearDataSource = null;
    private List<TreasuryTupleDataSourceBean> degreeTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> degreeCurricularPlanDataSource = null;
    private List<TreasuryTupleDataSourceBean> registrationRegimeTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> registrationProtocolDataSource = null;
    private List<TreasuryTupleDataSourceBean> ingressionDataSource = null;
    private List<TreasuryTupleDataSourceBean> curricularYearDataSource = null;
    private List<TreasuryTupleDataSourceBean> semesterDataSource = null;
    private List<TreasuryTupleDataSourceBean> statuteTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> payorDebtAccountDataSource = null;
    private List<TreasuryTupleDataSourceBean> tuitionCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> ectsCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> interestTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> dueDateCalculationTypeDataSource = null;
    private List<TreasuryTupleDataSourceBean> tuitionInstallmentProductDataSource = null;
    public List<AcademicTariffBean> tuitionInstallmentBeans = Lists.newArrayList();
    private LocalDate beginDate = new LocalDate();
    private LocalDate endDate = AcademicTreasuryConstants.INFINITY_DATE.toLocalDate();
    private DueDateCalculationType dueDateCalculationType;
    private LocalDate fixedDueDate = new LocalDate();
    private int numberOfDaysAfterCreationForDueDate;
    private boolean applyInterests;
    private InterestType interestType;
    private int numberOfDaysAfterDueDate;
    private boolean applyInFirstWorkday;
    private int maximumDaysToApplyPenalty;
    private int maximumMonthsToApplyPenalty;
    private BigDecimal interestFixedAmount;
    private BigDecimal rate;
    private Product tuitionInstallmentProduct;
    private int installmentOrder;
    private TuitionCalculationType tuitionCalculationType;
    private BigDecimal fixedAmount;
    private EctsCalculationType ectsCalculationType;
    private BigDecimal factor;
    private BigDecimal totalEctsOrUnits;
    private boolean applyMaximumAmount;
    private BigDecimal maximumAmount;
    private boolean academicalActBlockingOn;
    private boolean blockAcademicActsOnDebt;
    private ExecutionYear copiedExecutionYear;
    private String sheetName;
    public static final Comparator<TreasuryTupleDataSourceBean> COMPARE_BY_ID_AND_TEXT = new Comparator<TreasuryTupleDataSourceBean>(){

        @Override
        public int compare(TreasuryTupleDataSourceBean o1, TreasuryTupleDataSourceBean o2) {
            if (o1.getId() == "") {
                return -1;
            }
            if (o2.getId() == "") {
                return 1;
            }
            return TreasuryTupleDataSourceBean.COMPARE_BY_TEXT.compare(o1, o2);
        }
    };

    public TuitionPaymentPlanBean() {
    }

    public TuitionPaymentPlanBean(Product product, TuitionPaymentPlanGroup tuitionPaymentPlanGroup, FinantialEntity finantialEntity, ExecutionYear executionYear) {
        this.showAllDcps = false;
        this.product = product;
        this.tuitionPaymentPlanGroup = tuitionPaymentPlanGroup;
        this.finantialEntity = finantialEntity;
        this.executionYear = executionYear;
        this.updateData();
        this.resetInstallmentFields();
    }

    public TuitionPaymentPlanBean(TuitionPaymentPlan tuitionPaymentPlan) {
        this(tuitionPaymentPlan.getProduct(), tuitionPaymentPlan.getTuitionPaymentPlanGroup(), tuitionPaymentPlan.getFinantialEntity(), tuitionPaymentPlan.getExecutionYear());
        this.degreeType = tuitionPaymentPlan.getDegreeCurricularPlan().getDegreeType();
        this.copiedExecutionYear = tuitionPaymentPlan.getExecutionYear();
        this.curricularYear = tuitionPaymentPlan.getCurricularYear();
        this.customized = tuitionPaymentPlan.isCustomized();
        this.defaultPaymentPlan = tuitionPaymentPlan.isDefaultPaymentPlan();
        if (tuitionPaymentPlan.getSemester() != null) {
            this.executionSemester = this.getExecutionYear().getExecutionSemesterFor(tuitionPaymentPlan.getSemester());
        }
        this.firstTimeStudent = tuitionPaymentPlan.isFirstTimeStudent();
        this.ingression = tuitionPaymentPlan.getIngression();
        this.name = tuitionPaymentPlan.getCustomizedName().getContent();
        this.registrationProtocol = tuitionPaymentPlan.getRegistrationProtocol();
        this.registrationRegimeType = tuitionPaymentPlan.getRegistrationRegimeType();
        this.statuteType = tuitionPaymentPlan.getStatuteType();
        this.withLaboratorialClasses = tuitionPaymentPlan.isWithLaboratorialClasses();
        this.payorDebtAccount = tuitionPaymentPlan.getPayorDebtAccount();
        this.fillWithInstallments(tuitionPaymentPlan);
    }

    private void fillWithInstallments(TuitionPaymentPlan tuitionPaymentPlan) {
        for (TuitionInstallmentTariff tuitionInstallmentTariff : tuitionPaymentPlan.getOrderedTuitionInstallmentTariffs()) {
            this.tuitionInstallmentProduct = tuitionInstallmentTariff.getProduct();
            this.beginDate = tuitionInstallmentTariff.getBeginDate().toLocalDate();
            this.dueDateCalculationType = tuitionInstallmentTariff.getDueDateCalculationType();
            this.fixedDueDate = tuitionInstallmentTariff.getFixedDueDate();
            this.numberOfDaysAfterCreationForDueDate = tuitionInstallmentTariff.getNumberOfDaysAfterCreationForDueDate();
            this.applyInterests = tuitionInstallmentTariff.getApplyInterests();
            if (this.applyInterests) {
                this.interestType = tuitionInstallmentTariff.getInterestRate().getInterestType();
                this.numberOfDaysAfterDueDate = tuitionInstallmentTariff.getNumberOfDaysAfterCreationForDueDate();
                this.applyInFirstWorkday = tuitionInstallmentTariff.getInterestRate().isApplyInFirstWorkday();
                this.maximumDaysToApplyPenalty = tuitionInstallmentTariff.getInterestRate().getMaximumDaysToApplyPenalty();
                this.maximumMonthsToApplyPenalty = tuitionInstallmentTariff.getInterestRate().getMaximumMonthsToApplyPenalty();
                this.interestFixedAmount = tuitionInstallmentTariff.getInterestRate().getInterestFixedAmount();
                this.rate = tuitionInstallmentTariff.getInterestRate().getRate();
            }
            this.tuitionCalculationType = tuitionInstallmentTariff.getTuitionCalculationType();
            this.fixedAmount = tuitionInstallmentTariff.getFixedAmount();
            this.ectsCalculationType = tuitionInstallmentTariff.getEctsCalculationType();
            this.factor = tuitionInstallmentTariff.getFactor();
            this.totalEctsOrUnits = tuitionInstallmentTariff.getTotalEctsOrUnits();
            this.applyMaximumAmount = tuitionInstallmentTariff.isApplyMaximumAmount();
            this.maximumAmount = tuitionInstallmentTariff.getMaximumAmount();
            this.academicalActBlockingOn = !tuitionInstallmentTariff.getAcademicalActBlockingOff();
            this.blockAcademicActsOnDebt = tuitionInstallmentTariff.getBlockAcademicActsOnDebt();
            this.addInstallment();
        }
    }

    public void updateData() {
        this.degreeTypeDataSource = this.degreeTypeDataSource();
        this.degreeCurricularPlanDataSource = this.degreeCurricularPlanDataSource();
        this.degreeCurricularPlans.clear();
        this.registrationRegimeTypeDataSource = this.registrationRegimeTypeDataSource();
        this.registrationProtocolDataSource = this.registrationProtocolDataSource();
        this.ingressionDataSource = this.ingressionDataSource();
        this.curricularYearDataSource = this.curricularYearDataSource();
        this.semesterDataSource = this.semesterDataSource();
        this.tuitionCalculationTypeDataSource = TuitionPaymentPlanBean.tuitionCalculationTypeDataSource();
        this.ectsCalculationTypeDataSource = TuitionPaymentPlanBean.ectsCalculationTypeDataSource();
        this.interestTypeDataSource = TuitionPaymentPlanBean.interestTypeDataSource();
        this.dueDateCalculationTypeDataSource = TuitionPaymentPlanBean.dueDateCalculationTypeDataSource();
        this.tuitionInstallmentProductDataSource = TuitionPaymentPlanBean.tuitionInstallmentProductDataSource(this.getTuitionPaymentPlanGroup(), this.tuitionInstallmentBeans.size() + 1);
        this.statuteTypeDataSource = this.statuteTypeDataSource();
        this.payorDebtAccountDataSource = this.payorDebtAccountDataSource();
        this.executionYearDataSource = this.executionYearDataSource();
    }

    public void updateDatesBasedOnSelectedExecutionYear() {
        int executionYearInterval = this.executionYear.getAcademicInterval().getStart().getYear() - this.copiedExecutionYear.getAcademicInterval().getStart().getYear();
        for (AcademicTariffBean academicTariffBean : this.tuitionInstallmentBeans) {
            academicTariffBean.setBeginDate(academicTariffBean.getBeginDate().plusYears(executionYearInterval));
            if (academicTariffBean.getFixedDueDate() == null) continue;
            academicTariffBean.setFixedDueDate(academicTariffBean.getFixedDueDate().plusYears(executionYearInterval));
        }
    }

    public static List<TreasuryTupleDataSourceBean> dueDateCalculationTypeDataSource() {
        return Arrays.asList((Object[])DueDateCalculationType.values()).stream().filter(t -> !t.isNoDueDate() && !t.isFixedDate()).map(t -> new TreasuryTupleDataSourceBean(t.name(), t.getDescriptionI18N().getContent())).collect(Collectors.toList());
    }

    public List<String> addInstallment() {
        ArrayList errorMessages = Lists.newArrayList();
        AcademicTariffBean installmentBean = new AcademicTariffBean(this.tuitionInstallmentBeans.size() + 1);
        if (this.tuitionInstallmentProduct == null) {
            errorMessages.add("error.TuitionPaymentPlan.tuitionInstallmentProduct.required");
        }
        if (this.tuitionCalculationType == null) {
            errorMessages.add("error.TuitionPaymentPlan.tuitionCalculationType.required");
        }
        if (this.tuitionCalculationType != null && this.tuitionCalculationType.isFixedAmount() && this.fixedAmount == null) {
            errorMessages.add("error.TuitionPaymentPlan.fixedAmount.required");
        }
        if (this.tuitionCalculationType != null && (this.tuitionCalculationType.isEcts() || this.tuitionCalculationType.isUnits()) && this.ectsCalculationType == null) {
            errorMessages.add("error.TuitionPaymentPlan.ectsCalculationType.required");
        }
        if (this.tuitionCalculationType != null && (this.tuitionCalculationType.isEcts() || this.tuitionCalculationType.isUnits()) && this.ectsCalculationType != null && this.ectsCalculationType.isFixedAmount() && this.fixedAmount == null) {
            errorMessages.add("error.TuitionPaymentPlan.fixedAmount.required");
        }
        if (this.tuitionCalculationType != null && (this.tuitionCalculationType.isEcts() || this.tuitionCalculationType.isUnits()) && this.ectsCalculationType != null && this.ectsCalculationType.isDependentOnDefaultPaymentPlan() && this.factor == null) {
            errorMessages.add("error.TuitionPaymentPlan.factor.required");
        }
        if (this.tuitionCalculationType != null && (this.tuitionCalculationType.isEcts() || this.tuitionCalculationType.isUnits()) && this.ectsCalculationType != null && this.ectsCalculationType.isDependentOnDefaultPaymentPlan() && this.totalEctsOrUnits == null) {
            errorMessages.add("error.TuitionPaymentPlan.totalEctsOrUnits.required");
        }
        if (this.applyMaximumAmount && (this.maximumAmount == null || !AcademicTreasuryConstants.isPositive(this.maximumAmount))) {
            errorMessages.add("error.TuitionPaymentPlan.maximumAmount.required");
        }
        if (this.beginDate == null) {
            errorMessages.add("error.TuitionPaymentPlan.beginDate.required");
        }
        if (this.dueDateCalculationType == null) {
            errorMessages.add("error.TuitionPaymentPlan.dueDateCalculationType.required");
        }
        if (this.dueDateCalculationType != null && this.dueDateCalculationType.isFixedDate() && this.fixedDueDate == null) {
            errorMessages.add("error.TuitionPaymentPlan.fixedDueDate.required");
        }
        if (this.applyInterests && this.interestType == null) {
            errorMessages.add("error.TuitionPaymentPlan.interestType.required");
        }
        if (this.applyInterests && this.interestType != null && this.interestType.isFixedAmount() && this.interestFixedAmount == null) {
            errorMessages.add("error.TuitionPaymentPlan.interestFixedAmount.required");
        }
        if (this.applyInterests && this.interestType != null && (this.interestType.isDaily() || this.interestType.isMonthly()) && this.rate == null) {
            errorMessages.add("error.TuitionPaymentPlan.interestRate.required");
        }
        if (this.getTuitionInstallmentBeans().stream().filter(l -> l.getTuitionInstallmentProduct() == this.getTuitionInstallmentProduct()).count() > 0L) {
            errorMessages.add("error.TuitionPaymentPlan.installment.already.with.product");
        }
        if (this.getTuitionPaymentPlanGroup().isForRegistration() && (this.getTuitionCalculationType().isEcts() || this.getTuitionCalculationType().isUnits()) && this.getEctsCalculationType().isDefaultPaymentPlanCourseFunctionCostIndexed()) {
            errorMessages.add("error.TuitionInstallmentTariff.defaultPaymentPlanCourseFunctionCostIndexed.not.supported.for.registrationTuition");
        }
        if (!this.isAcademicalActBlockingOn() && this.isBlockAcademicActsOnDebt()) {
            errorMessages.add("error.TuitionPaymentPlanBean.cannot.suspend.and.also.block.academical.acts.on.debt");
        }
        if (!errorMessages.isEmpty()) {
            return errorMessages;
        }
        installmentBean.setBeginDate(this.beginDate);
        installmentBean.setEndDate(this.endDate);
        installmentBean.setDueDateCalculationType(this.dueDateCalculationType);
        installmentBean.setFixedDueDate(this.fixedDueDate);
        installmentBean.setNumberOfDaysAfterCreationForDueDate(this.numberOfDaysAfterCreationForDueDate);
        installmentBean.setApplyInterests(this.applyInterests);
        installmentBean.setInterestType(this.interestType);
        installmentBean.setNumberOfDaysAfterDueDate(this.numberOfDaysAfterDueDate);
        installmentBean.setApplyInFirstWorkday(this.applyInFirstWorkday);
        installmentBean.setMaximumDaysToApplyPenalty(this.maximumDaysToApplyPenalty);
        installmentBean.setMaximumMonthsToApplyPenalty(this.maximumMonthsToApplyPenalty);
        installmentBean.setInterestFixedAmount(this.interestFixedAmount);
        installmentBean.setRate(this.rate);
        installmentBean.setTuitionInstallmentProduct(this.getTuitionInstallmentProduct());
        installmentBean.setTuitionCalculationType(this.tuitionCalculationType);
        installmentBean.setFixedAmount(this.fixedAmount);
        installmentBean.setEctsCalculationType(this.ectsCalculationType);
        installmentBean.setFactor(this.factor);
        installmentBean.setTotalEctsOrUnits(this.totalEctsOrUnits);
        installmentBean.setApplyMaximumAmount(this.applyMaximumAmount);
        installmentBean.setMaximumAmount(this.maximumAmount);
        installmentBean.setAcademicalActBlockingOn(this.academicalActBlockingOn);
        installmentBean.setBlockAcademicActsOnDebt(this.blockAcademicActsOnDebt);
        this.tuitionInstallmentBeans.add(installmentBean);
        this.tuitionInstallmentProductDataSource = TuitionPaymentPlanBean.tuitionInstallmentProductDataSource(this.getTuitionPaymentPlanGroup(), this.tuitionInstallmentBeans.size() + 1);
        return errorMessages;
    }

    public void removeInstallment(int installmentNumber) {
        if (this.findTariffBeanByInstallmentNumber(installmentNumber + 1) != null) {
            throw new AcademicTreasuryDomainException("error.TuitionPaymentPlan.delete.after.first", new String[0]);
        }
        AcademicTariffBean removeBean = this.findTariffBeanByInstallmentNumber(installmentNumber);
        if (removeBean != null) {
            this.getTuitionInstallmentBeans().remove(removeBean);
            int i = 1;
            for (AcademicTariffBean academicTariffBean : this.getTuitionInstallmentBeans()) {
                academicTariffBean.setInstallmentOrder(i++);
            }
        }
        this.tuitionInstallmentProductDataSource = TuitionPaymentPlanBean.tuitionInstallmentProductDataSource(this.getTuitionPaymentPlanGroup(), this.tuitionInstallmentBeans.size() + 1);
    }

    private AcademicTariffBean findTariffBeanByInstallmentNumber(int installmentNumber) {
        for (AcademicTariffBean academicTariffBean : this.getTuitionInstallmentBeans()) {
            if (academicTariffBean.getInstallmentOrder() != installmentNumber) continue;
            return academicTariffBean;
        }
        return null;
    }

    public void resetInstallmentFields() {
        this.beginDate = this.executionYear != null ? this.executionYear.getBeginLocalDate() : null;
        this.endDate = AcademicTreasuryConstants.INFINITY_DATE.toLocalDate();
        this.dueDateCalculationType = DueDateCalculationType.DAYS_AFTER_CREATION;
        this.fixedDueDate = this.executionYear != null ? this.executionYear.getBeginLocalDate() : null;
        this.numberOfDaysAfterCreationForDueDate = 0;
        this.applyInterests = true;
        this.interestType = InterestType.GLOBAL_RATE;
        this.numberOfDaysAfterDueDate = 1;
        this.applyInFirstWorkday = false;
        this.maximumDaysToApplyPenalty = 0;
        this.maximumMonthsToApplyPenalty = 0;
        this.interestFixedAmount = null;
        this.rate = null;
        this.tuitionInstallmentProduct = null;
        this.tuitionCalculationType = TuitionCalculationType.FIXED_AMOUNT;
        this.fixedAmount = null;
        this.ectsCalculationType = EctsCalculationType.FIXED_AMOUNT;
        this.factor = null;
        this.totalEctsOrUnits = null;
        this.applyMaximumAmount = false;
        this.maximumAmount = null;
        this.academicalActBlockingOn = true;
        this.blockAcademicActsOnDebt = false;
        if (this.tuitionPaymentPlanGroup.isForExtracurricular() || this.tuitionPaymentPlanGroup.isForStandalone()) {
            this.setTuitionInstallmentProduct(this.tuitionPaymentPlanGroup.getCurrentProduct());
        }
    }

    public FinantialEntity getFinantialEntity() {
        return this.finantialEntity;
    }

    public void setFinantialEntity(FinantialEntity finantialEntity) {
        this.finantialEntity = finantialEntity;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public TuitionPaymentPlanGroup getTuitionPaymentPlanGroup() {
        return this.tuitionPaymentPlanGroup;
    }

    public void setTuitionPaymentPlanGroup(TuitionPaymentPlanGroup tuitionPaymentPlanGroup) {
        this.tuitionPaymentPlanGroup = tuitionPaymentPlanGroup;
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public void setExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public DegreeType getDegreeType() {
        return this.degreeType;
    }

    public void setDegreeType(DegreeType degreeType) {
        this.degreeType = degreeType;
    }

    public Set<DegreeCurricularPlan> getDegreeCurricularPlans() {
        return this.degreeCurricularPlans;
    }

    public void setDegreeCurricularPlans(Set<DegreeCurricularPlan> degreeCurricularPlans) {
        this.degreeCurricularPlans = degreeCurricularPlans;
    }

    public boolean isDefaultPaymentPlan() {
        return this.defaultPaymentPlan;
    }

    public void setDefaultPaymentPlan(boolean defaultPaymentPlan) {
        this.defaultPaymentPlan = defaultPaymentPlan;
    }

    public RegistrationRegimeType getRegistrationRegimeType() {
        return this.registrationRegimeType;
    }

    public void setRegistrationRegimeType(RegistrationRegimeType registrationRegimeType) {
        this.registrationRegimeType = registrationRegimeType;
    }

    public RegistrationProtocol getRegistrationProtocol() {
        return this.registrationProtocol;
    }

    public void setRegistrationProtocol(RegistrationProtocol registrationProtocol) {
        this.registrationProtocol = registrationProtocol;
    }

    public IngressionType getIngression() {
        return this.ingression;
    }

    public void setIngression(IngressionType ingression) {
        this.ingression = ingression;
    }

    public CurricularYear getCurricularYear() {
        return this.curricularYear;
    }

    public void setCurricularYear(CurricularYear curricularYear) {
        this.curricularYear = curricularYear;
    }

    public ExecutionInterval getExecutionSemester() {
        return this.executionSemester;
    }

    public void setExecutionSemester(ExecutionInterval executionSemester) {
        this.executionSemester = executionSemester;
    }

    public boolean isFirstTimeStudent() {
        return this.firstTimeStudent;
    }

    public void setFirstTimeStudent(boolean firstTimeStudent) {
        this.firstTimeStudent = firstTimeStudent;
    }

    public boolean isCustomized() {
        return this.customized;
    }

    public void setCustomized(boolean customized) {
        this.customized = customized;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isWithLaboratorialClasses() {
        return this.withLaboratorialClasses;
    }

    public void setWithLaboratorialClasses(boolean withLaboratorialClasses) {
        this.withLaboratorialClasses = withLaboratorialClasses;
    }

    public List<AcademicTariffBean> getTuitionInstallmentBeans() {
        return this.tuitionInstallmentBeans;
    }

    public void setTuitionInstallmentBeans(List<AcademicTariffBean> tuitionInstallmentBeans) {
        this.tuitionInstallmentBeans = tuitionInstallmentBeans;
    }

    public List<TreasuryTupleDataSourceBean> getDegreeTypeDataSource() {
        return this.degreeTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getDegreeCurricularPlanDataSource() {
        return this.degreeCurricularPlanDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getRegistrationRegimeTypeDataSource() {
        return this.registrationRegimeTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getRegistrationProtocolDataSource() {
        return this.registrationProtocolDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getIngressionDataSource() {
        return this.ingressionDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getCurricularYearDataSource() {
        return this.curricularYearDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getSemesterDataSource() {
        return this.semesterDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getTuitionCalculationTypeDataSource() {
        return this.tuitionCalculationTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getEctsCalculationTypeDataSource() {
        return this.ectsCalculationTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getInterestTypeDataSource() {
        return this.interestTypeDataSource;
    }

    public List<TreasuryTupleDataSourceBean> getTuitionInstallmentProductDataSource() {
        return this.tuitionInstallmentProductDataSource;
    }

    public DebtAccount getPayorDebtAccount() {
        return this.payorDebtAccount;
    }

    public void setPayorDebtAccount(DebtAccount payorDebtAccount) {
        this.payorDebtAccount = payorDebtAccount;
    }

    public LocalDate getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(LocalDate beginDate) {
        this.beginDate = beginDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public DueDateCalculationType getDueDateCalculationType() {
        return this.dueDateCalculationType;
    }

    public void setDueDateCalculationType(DueDateCalculationType dueDateCalculationType) {
        this.dueDateCalculationType = dueDateCalculationType;
    }

    public LocalDate getFixedDueDate() {
        return this.fixedDueDate;
    }

    public void setFixedDueDate(LocalDate fixedDueDate) {
        this.fixedDueDate = fixedDueDate;
    }

    public int getNumberOfDaysAfterCreationForDueDate() {
        return this.numberOfDaysAfterCreationForDueDate;
    }

    public void setNumberOfDaysAfterCreationForDueDate(int numberOfDaysAfterCreationForDueDate) {
        this.numberOfDaysAfterCreationForDueDate = numberOfDaysAfterCreationForDueDate;
    }

    public boolean isApplyInterests() {
        return this.applyInterests;
    }

    public void setApplyInterests(boolean applyInterests) {
        this.applyInterests = applyInterests;
    }

    public boolean isApplyInFirstWorkday() {
        return this.applyInFirstWorkday;
    }

    public void setApplyInFirstWorkday(boolean applyInFirstWorkday) {
        this.applyInFirstWorkday = applyInFirstWorkday;
    }

    public InterestType getInterestType() {
        return this.interestType;
    }

    public void setInterestType(InterestType interestType) {
        this.interestType = interestType;
    }

    public int getNumberOfDaysAfterDueDate() {
        return this.numberOfDaysAfterDueDate;
    }

    public void setNumberOfDaysAfterDueDate(int numberOfDaysAfterDueDate) {
        this.numberOfDaysAfterDueDate = numberOfDaysAfterDueDate;
    }

    public int getMaximumDaysToApplyPenalty() {
        return this.maximumDaysToApplyPenalty;
    }

    public void setMaximumDaysToApplyPenalty(int maximumDaysToApplyPenalty) {
        this.maximumDaysToApplyPenalty = maximumDaysToApplyPenalty;
    }

    public int getMaximumMonthsToApplyPenalty() {
        return this.maximumMonthsToApplyPenalty;
    }

    public void setMaximumMonthsToApplyPenalty(int maximumMonthsToApplyPenalty) {
        this.maximumMonthsToApplyPenalty = maximumMonthsToApplyPenalty;
    }

    public BigDecimal getInterestFixedAmount() {
        return this.interestFixedAmount;
    }

    public void setInterestFixedAmount(BigDecimal interestFixedAmount) {
        this.interestFixedAmount = interestFixedAmount;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public Product getTuitionInstallmentProduct() {
        return this.tuitionInstallmentProduct;
    }

    public void setTuitionInstallmentProduct(Product tuitionInstallmentProduct) {
        this.tuitionInstallmentProduct = tuitionInstallmentProduct;
    }

    public int getInstallmentOrder() {
        return this.installmentOrder;
    }

    public void setInstallmentOrder(int installmentOrder) {
        this.installmentOrder = installmentOrder;
    }

    public TuitionCalculationType getTuitionCalculationType() {
        return this.tuitionCalculationType;
    }

    public void setTuitionCalculationType(TuitionCalculationType tuitionCalculationType) {
        this.tuitionCalculationType = tuitionCalculationType;
    }

    public BigDecimal getFixedAmount() {
        return this.fixedAmount;
    }

    public void setFixedAmount(BigDecimal fixedAmount) {
        this.fixedAmount = fixedAmount;
    }

    public EctsCalculationType getEctsCalculationType() {
        return this.ectsCalculationType;
    }

    public void setEctsCalculationType(EctsCalculationType ectsCalculationType) {
        this.ectsCalculationType = ectsCalculationType;
    }

    public BigDecimal getFactor() {
        return this.factor;
    }

    public void setFactor(BigDecimal factor) {
        this.factor = factor;
    }

    public BigDecimal getTotalEctsOrUnits() {
        return this.totalEctsOrUnits;
    }

    public void setTotalEctsOrUnits(BigDecimal totalEctsOrUnits) {
        this.totalEctsOrUnits = totalEctsOrUnits;
    }

    public boolean isAcademicalActBlockingOn() {
        return this.academicalActBlockingOn;
    }

    public void setAcademicalActBlockingOn(boolean academicalActBlockingOn) {
        this.academicalActBlockingOn = academicalActBlockingOn;
    }

    public boolean isBlockAcademicActsOnDebt() {
        return this.blockAcademicActsOnDebt;
    }

    public void setBlockAcademicActsOnDebt(boolean blockAcademicActsOnDebt) {
        this.blockAcademicActsOnDebt = blockAcademicActsOnDebt;
    }

    public StatuteType getStatuteType() {
        return this.statuteType;
    }

    public void setStatuteType(StatuteType statuteType) {
        this.statuteType = statuteType;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isApplyMaximumAmount() {
        return this.applyMaximumAmount;
    }

    public void setApplyMaximumAmount(boolean applyMaximumAmount) {
        this.applyMaximumAmount = applyMaximumAmount;
    }

    public BigDecimal getMaximumAmount() {
        return this.maximumAmount;
    }

    public void setMaximumAmount(BigDecimal maximumAmount) {
        this.maximumAmount = maximumAmount;
    }

    public boolean isShowAllDcps() {
        return this.showAllDcps;
    }

    public void setShowAllDcps(boolean degreeCurricularPlansShownFilteredByExecutions) {
        this.showAllDcps = degreeCurricularPlansShownFilteredByExecutions;
    }

    private List<TreasuryTupleDataSourceBean> degreeTypeDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        ArrayList result = Lists.newArrayList((Iterable)DegreeType.all().map(dt -> new TreasuryTupleDataSourceBean(dt.getExternalId(), academicTreasuryServices.localizedNameOfDegreeType((DegreeType)dt))).collect(Collectors.toList()));
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> degreeCurricularPlanDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (this.getExecutionYear() == null) {
            return Collections.emptyList();
        }
        if (this.getDegreeType() == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        if (this.isShowAllDcps()) {
            result.addAll(academicTreasuryServices.readAllDegreeCurricularPlansSet().stream().filter(dcp -> dcp.getDegreeType() == this.getDegreeType()).map(dcp -> new TreasuryTupleDataSourceBean(dcp.getExternalId(), "[" + dcp.getDegree().getCode() + "] " + dcp.getPresentationName(this.getExecutionYear()))).collect(Collectors.toList()));
        } else {
            result.addAll(academicTreasuryServices.readDegreeCurricularPlansWithExecutionDegree(this.getExecutionYear(), this.getDegreeType()).stream().map(dcp -> new TreasuryTupleDataSourceBean(dcp.getExternalId(), "[" + dcp.getDegree().getCode() + "] " + dcp.getPresentationName(this.getExecutionYear()))).collect(Collectors.toList()));
        }
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> semesterDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        if (this.getExecutionYear() == null) {
            return Lists.newArrayList();
        }
        List result = this.getExecutionYear().getExecutionPeriodsSet().stream().map(cs -> new TreasuryTupleDataSourceBean(cs.getExternalId(), cs.getQualifiedName())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> curricularYearDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        List result = academicTreasuryServices.readAllCurricularYearsSet().stream().map(cy -> new TreasuryTupleDataSourceBean(cy.getExternalId(), cy.getYear().toString())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> ingressionDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        List result = academicTreasuryServices.readAllIngressionTypesSet().stream().map(i -> new TreasuryTupleDataSourceBean(i.getExternalId(), i.getDescription().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> registrationProtocolDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        List result = academicTreasuryServices.readAllRegistrationProtocol().stream().map(rp -> new TreasuryTupleDataSourceBean(rp.getExternalId(), rp.getDescription().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> registrationRegimeTypeDataSource() {
        List result = Arrays.asList((Object[])RegistrationRegimeType.values()).stream().map(t -> new TreasuryTupleDataSourceBean(t.name(), t.getLocalizedName())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    public static List<TreasuryTupleDataSourceBean> interestTypeDataSource() {
        List result = InterestType.findAll().stream().map(it -> new TreasuryTupleDataSourceBean(it.name(), it.getDescriptionI18N().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    public static List<TreasuryTupleDataSourceBean> ectsCalculationTypeDataSource() {
        List result = Arrays.asList((Object[])EctsCalculationType.values()).stream().map(ct -> new TreasuryTupleDataSourceBean(ct.name(), ct.getDescriptionI18N().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    public static List<TreasuryTupleDataSourceBean> tuitionCalculationTypeDataSource() {
        List result = Arrays.asList((Object[])TuitionCalculationType.values()).stream().map(ct -> new TreasuryTupleDataSourceBean(ct.name(), ct.getDescriptionI18N().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    public static List<TreasuryTupleDataSourceBean> tuitionInstallmentProductDataSource(TuitionPaymentPlanGroup tuitionPaymentPlanGroup, int desiredTuitionInstallmentOrder) {
        List result = null;
        result = tuitionPaymentPlanGroup != null && tuitionPaymentPlanGroup.isForRegistration() ? AcademicTreasurySettings.getInstance().getTuitionProductGroup().getProductsSet().stream().filter(p -> p.isActive() && p.getTuitionInstallmentOrder() == desiredTuitionInstallmentOrder).map(p -> new TreasuryTupleDataSourceBean(p.getExternalId(), p.getName().getContent())).collect(Collectors.toList()) : AcademicTreasurySettings.getInstance().getTuitionProductGroup().getProductsSet().stream().filter(p -> p.isActive()).map(p -> new TreasuryTupleDataSourceBean(p.getExternalId(), p.getName().getContent())).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> statuteTypeDataSource() {
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        List result = academicTreasuryServices.readAllStatuteTypesSet().stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), academicTreasuryServices.localizedNameOfStatuteType((StatuteType)l))).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> payorDebtAccountDataSource() {
        if (this.finantialEntity == null) {
            return Lists.newArrayList();
        }
        SortedSet payorDebtAccountsSet = DebtAccount.findActiveAdhocDebtAccountsSortedByCustomerName((FinantialInstitution)this.finantialEntity.getFinantialInstitution());
        List result = payorDebtAccountsSet.stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), String.format("%s - %s", l.getCustomer().getUiFiscalNumber(), l.getCustomer().getName()))).collect(Collectors.toList());
        result.add(AcademicTreasuryConstants.SELECT_OPTION);
        return result.stream().sorted(COMPARE_BY_ID_AND_TEXT).collect(Collectors.toList());
    }

    private List<TreasuryTupleDataSourceBean> executionYearDataSource() {
        List<TreasuryTupleDataSourceBean> result = ExecutionYear.readNotClosedExecutionYears().stream().sorted(ExecutionYear.REVERSE_COMPARATOR_BY_YEAR).collect(Collectors.toList()).stream().map(l -> new TreasuryTupleDataSourceBean(l.getExternalId(), l.getQualifiedName())).collect(Collectors.toList());
        result.add(0, AcademicTreasuryConstants.SELECT_OPTION);
        return result;
    }

    public List<String> validateStudentConditions() {
        ArrayList result = Lists.newArrayList();
        if (!this.hasAtLeastOneConditionSpecified()) {
            result.add("error.TuitionPaymentPlan.specify.at.least.one.condition");
        }
        if (this.isCustomized() && (this.isDefaultPaymentPlan() || this.hasStudentConditionSelected())) {
            result.add("error.TuitionPaymentPlan.customized.plan.cannot.have.other.options");
        }
        if (this.isDefaultPaymentPlan() && this.hasStudentConditionSelected()) {
            result.add("error.TuitionPaymentPlan.default.payment.plan.cannot.have.other.options");
        }
        return result;
    }

    private boolean hasStudentConditionSelected() {
        return this.getRegistrationRegimeType() != null || this.getRegistrationProtocol() != null || this.getIngression() != null || this.getCurricularYear() != null || this.getExecutionSemester() != null || this.isFirstTimeStudent() || this.getStatuteType() != null;
    }

    private boolean hasAtLeastOneConditionSpecified() {
        boolean hasAtLeastOneCondition = false;
        hasAtLeastOneCondition |= this.isDefaultPaymentPlan();
        hasAtLeastOneCondition |= this.getRegistrationRegimeType() != null;
        hasAtLeastOneCondition |= this.getRegistrationProtocol() != null;
        hasAtLeastOneCondition |= this.getIngression() != null;
        hasAtLeastOneCondition |= this.getCurricularYear() != null;
        hasAtLeastOneCondition |= this.getStatuteType() != null;
        hasAtLeastOneCondition |= this.getExecutionSemester() != null;
        hasAtLeastOneCondition |= this.isFirstTimeStudent();
        hasAtLeastOneCondition |= this.isCustomized();
        return hasAtLeastOneCondition |= this.isWithLaboratorialClasses();
    }
}

