/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.treasury;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.treasury.IAcademicTreasuryAccountUrl;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;

public class DefaultAcademicTreasuryAccountUrl
implements IAcademicTreasuryAccountUrl {
    @Override
    public String getPersonAccountTreasuryManagementURL(Person person) {
        String countryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        return "/treasury/accounting/managecustomer/customer/read/" + PersonCustomer.findUnique(person, countryCode, fiscalNumber).get().getExternalId();
    }

    @Override
    public String getRegistrationAccountTreasuryManagementURL(Registration registration) {
        String fiscalNumber;
        String countryCode;
        if (registration.getDegree().getAdministrativeOffice().getFinantialEntity() == null) {
            return this.getPersonAccountTreasuryManagementURL(registration.getPerson());
        }
        FinantialInstitution inst = registration.getDegree().getAdministrativeOffice().getFinantialEntity().getFinantialInstitution();
        Person person = registration.getPerson();
        PersonCustomer customer = PersonCustomer.findUnique(person, countryCode = PersonCustomer.addressCountryCode(person), fiscalNumber = PersonCustomer.fiscalNumber(person)).get();
        DebtAccount account = customer.getDebtAccountFor(inst);
        if (account != null) {
            return "/treasury/accounting/managecustomer/debtaccount/read/" + customer.getDebtAccountFor(inst).getExternalId();
        }
        return this.getPersonAccountTreasuryManagementURL(person);
    }

    @Override
    public String getDebtAccountURL(TreasuryEvent treasuryEvent) {
        if (DebitEntry.findActive((TreasuryEvent)treasuryEvent).findFirst().isPresent()) {
            return "/treasury/accounting/managecustomer/debtaccount/read/" + ((DebitEntry)DebitEntry.findActive((TreasuryEvent)treasuryEvent).findFirst().get()).getDebtAccount().getExternalId();
        }
        return null;
    }
}

