/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.treasury;

import com.google.common.base.Strings;
import com.google.common.eventbus.Subscribe;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.treasury.IAcademicServiceRequestAndAcademicTaxTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IAcademicTreasuryTarget;
import org.fenixedu.academic.domain.treasury.IImprovementTreasuryEvent;
import org.fenixedu.academic.domain.treasury.IPaymentCodePool;
import org.fenixedu.academic.domain.treasury.ITreasuryBridgeAPI;
import org.fenixedu.academic.domain.treasury.ITreasuryCustomer;
import org.fenixedu.academic.domain.treasury.ITreasuryDebtAccount;
import org.fenixedu.academic.domain.treasury.ITreasuryEntity;
import org.fenixedu.academic.domain.treasury.ITreasuryProduct;
import org.fenixedu.academic.domain.treasury.ITuitionTreasuryEvent;
import org.fenixedu.academictreasury.domain.academicalAct.AcademicActBlockingSuspension;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.academictreasury.domain.debtGeneration.AcademicDebtGenerationRule;
import org.fenixedu.academictreasury.domain.event.AcademicTreasuryEvent;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.settings.AcademicTreasurySettings;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.services.AcademicTaxServices;
import org.fenixedu.academictreasury.services.AcademicTreasuryPlataformDependentServicesFactory;
import org.fenixedu.academictreasury.services.IAcademicTreasuryPlatformDependentServices;
import org.fenixedu.academictreasury.services.PersonServices;
import org.fenixedu.academictreasury.services.TuitionServices;
import org.fenixedu.bennu.core.signals.DomainObjectEvent;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

public class AcademicTreasuryBridgeImpl
implements ITreasuryBridgeAPI {
    private static final Logger logger = LoggerFactory.getLogger(AcademicTreasuryBridgeImpl.class);

    public Set<ITreasuryEntity> getTreasuryEntities() {
        return FinantialEntity.findAll().map(f -> new TreasuryEntity((FinantialEntity)f)).collect(Collectors.toSet());
    }

    public ITreasuryEntity getTreasuryEntityByCode(String code) {
        if (FenixFramework.getDomainObject((String)code) == null) {
            throw new AcademicTreasuryDomainException("error.ITreasuryBridgeAPI.finantial.entity.not.found", new String[0]);
        }
        return new TreasuryEntity((FinantialEntity)FenixFramework.getDomainObject((String)code));
    }

    public Set<ITreasuryProduct> getProducts(ITreasuryEntity treasuryEntity) {
        return Product.findAllActive().filter(p -> p.getFinantialInstitutionsSet().contains(((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution())).map(p -> new AcademicProduct((Product)p)).collect(Collectors.toSet());
    }

    public ITreasuryProduct getProductByCode(String code) {
        return Product.findUniqueByCode((String)code).map(p -> new AcademicProduct((Product)p)).orElse(null);
    }

    public List<IPaymentCodePool> getPaymentCodePools(ITreasuryEntity treasuryEntity) {
        FinantialInstitution finantialInstitution = ((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution();
        return finantialInstitution.getPaymentCodePoolsSet().stream().map(p -> new PaymentCodePoolImpl((PaymentCodePool)p)).collect(Collectors.toList());
    }

    public IPaymentCodePool getPaymentCodePoolByCode(String code) {
        if (FenixFramework.getDomainObject((String)code) == null) {
            throw new AcademicTreasuryDomainException("error.ITreasuryBridgeAPI.paymentCodePool.not.found", new String[0]);
        }
        return new PaymentCodePoolImpl((PaymentCodePool)FenixFramework.getDomainObject((String)code));
    }

    public IAcademicServiceRequestAndAcademicTaxTreasuryEvent academicTreasuryEventForAcademicServiceRequest(AcademicServiceRequest academicServiceRequest) {
        return academicServiceRequest.getAcademicTreasuryEvent();
    }

    public void standaloneUnenrolment(Enrolment standaloneEnrolment) {
        TuitionServices.removeDebitEntryForStandaloneEnrolment(standaloneEnrolment);
    }

    public void extracurricularUnenrolment(Enrolment extracurricularEnrolment) {
        TuitionServices.removeDebitEntryForExtracurricularEnrolment(extracurricularEnrolment);
    }

    public ITuitionTreasuryEvent getTuitionForRegistrationTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.findAcademicTreasuryEventTuitionForRegistration(registration, executionYear);
    }

    public ITuitionTreasuryEvent getTuitionForStandaloneTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.findAcademicTreasuryEventTuitionForStandalone(registration, executionYear);
    }

    public ITuitionTreasuryEvent getTuitionForExtracurricularTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return null;
    }

    public ITuitionTreasuryEvent getTuitionForImprovementTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        return AcademicTaxServices.findAcademicTreasuryEventForImprovementTax(registration, executionYear);
    }

    public void improvementUnrenrolment(EnrolmentEvaluation improvementEnrolmentEvaluation) {
        AcademicTaxServices.removeDebitEntryForImprovement(improvementEnrolmentEvaluation);
    }

    public boolean isToPayTuition(Registration registration, ExecutionYear executionYear) {
        return TuitionServices.isToPayRegistrationTuition(registration, executionYear);
    }

    public List<IAcademicTreasuryEvent> getAcademicTaxesList(Registration registration, ExecutionYear executionYear) {
        return AcademicTaxServices.findAllTreasuryEventsForAcademicTaxes(registration, executionYear);
    }

    public IImprovementTreasuryEvent getImprovementTaxTreasuryEvent(Registration registration, ExecutionYear executionYear) {
        if (!AcademicTreasuryEvent.findUniqueForImprovementTuition(registration, executionYear).isPresent()) {
            return null;
        }
        return AcademicTreasuryEvent.findUniqueForImprovementTuition(registration, executionYear).get();
    }

    public IAcademicTreasuryEvent getAcademicTreasuryEventForTarget(IAcademicTreasuryTarget target) {
        Person person = target.getAcademicTreasuryTargetPerson();
        return AcademicTreasuryEvent.findUniqueForTarget(person, target).orElse(null);
    }

    public void anullDebtsForTarget(IAcademicTreasuryTarget target, String reason) {
        IAcademicTreasuryEvent event = this.getAcademicTreasuryEventForTarget(target);
        if (event != null) {
            event.annulDebts(reason);
        }
    }

    public IAcademicTreasuryEvent createDebt(ITreasuryEntity treasuryEntity, ITreasuryProduct treasuryProduct, IAcademicTreasuryTarget target, LocalDate when, boolean createPaymentCode, IPaymentCodePool paymentCodePool, int numberOfUnits, int numberOfPages) {
        AcademicTreasuryEvent treasuryEvent;
        DebtAccount debtAccount;
        FinantialEntity finantialEntity = ((TreasuryEntity)treasuryEntity).finantialEntity;
        FinantialInstitution finantialInstitution = finantialEntity.getFinantialInstitution();
        DocumentNumberSeries documentNumberSeries = (DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)finantialInstitution).get();
        DateTime now = new DateTime();
        Product product = ((AcademicProduct)treasuryProduct).product;
        Vat vat = (Vat)Vat.findActiveUnique((VatType)product.getVatType(), (FinantialInstitution)finantialInstitution, (DateTime)when.toDateTimeAtStartOfDay()).get();
        AdministrativeOffice administrativeOffice = finantialEntity.getAdministrativeOffice();
        PaymentCodePool pool = ((PaymentCodePoolImpl)paymentCodePool).paymentCodePool;
        Person person = target.getAcademicTreasuryTargetPerson();
        PersonCustomer personCustomer = person.getPersonCustomer();
        if (personCustomer == null) {
            personCustomer = PersonCustomer.createWithCurrentFiscalInformation(person);
        }
        if ((debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).orElse(null)) == null) {
            debtAccount = DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer);
        }
        if ((treasuryEvent = (AcademicTreasuryEvent)this.getAcademicTreasuryEventForTarget(target)) == null) {
            treasuryEvent = AcademicTreasuryEvent.createForAcademicTreasuryEventTarget(product, target);
        }
        if (treasuryEvent.isCharged()) {
            return treasuryEvent;
        }
        AcademicTariff academicTariff = null;
        academicTariff = target.getAcademicTreasuryTargetDegree() != null ? AcademicTariff.findMatch(finantialEntity, product, target.getAcademicTreasuryTargetDegree(), when.toDateTimeAtStartOfDay()) : AcademicTariff.findMatch(finantialEntity, product, administrativeOffice, when.toDateTimeAtStartOfDay());
        if (academicTariff == null) {
            throw new AcademicTreasuryDomainException("error.EmolumentServices.tariff.not.found", when.toString("yyyy/MM/dd"));
        }
        LocalDate dueDate = academicTariff.dueDate(when);
        DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)documentNumberSeries, (DateTime)now);
        BigDecimal amount = academicTariff.amountToPay(numberOfUnits, numberOfPages);
        DebitEntry debitEntry = DebitEntry.create(Optional.of(debitNote), (DebtAccount)debtAccount, (TreasuryEvent)treasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, (Map)target.getAcademicTreasuryTargetPropertiesMap(), (Product)product, (String)target.getAcademicTreasuryTargetDescription().getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)BigDecimal.ONE, (InterestRate)academicTariff.getInterestRate(), (DateTime)when.toDateTimeAtStartOfDay());
        if (createPaymentCode) {
            this.createPaymentReferenceCode(pool, debitEntry, when, dueDate);
        }
        return treasuryEvent;
    }

    public IAcademicTreasuryEvent createDebt(ITreasuryEntity treasuryEntity, ITreasuryProduct treasuryProduct, IAcademicTreasuryTarget target, BigDecimal amount, LocalDate when, LocalDate dueDate, boolean createPaymentCode, IPaymentCodePool paymentCodePool) {
        AcademicTreasuryEvent treasuryEvent;
        DebtAccount debtAccount;
        FinantialInstitution finantialInstitution = ((TreasuryEntity)treasuryEntity).finantialEntity.getFinantialInstitution();
        DocumentNumberSeries documentNumberSeries = (DocumentNumberSeries)DocumentNumberSeries.findUniqueDefault((FinantialDocumentType)FinantialDocumentType.findForDebitNote(), (FinantialInstitution)finantialInstitution).get();
        DateTime now = new DateTime();
        Product product = ((AcademicProduct)treasuryProduct).product;
        Vat vat = (Vat)Vat.findActiveUnique((VatType)product.getVatType(), (FinantialInstitution)finantialInstitution, (DateTime)when.toDateTimeAtStartOfDay()).get();
        PaymentCodePool pool = ((PaymentCodePoolImpl)paymentCodePool).paymentCodePool;
        Person person = target.getAcademicTreasuryTargetPerson();
        PersonCustomer personCustomer = person.getPersonCustomer();
        if (personCustomer == null) {
            personCustomer = PersonCustomer.createWithCurrentFiscalInformation(person);
        }
        if ((debtAccount = (DebtAccount)DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)personCustomer).orElse(null)) == null) {
            debtAccount = DebtAccount.create((FinantialInstitution)finantialInstitution, (Customer)personCustomer);
        }
        if ((treasuryEvent = (AcademicTreasuryEvent)this.getAcademicTreasuryEventForTarget(target)) == null) {
            treasuryEvent = AcademicTreasuryEvent.createForAcademicTreasuryEventTarget(product, target);
        }
        DebitNote debitNote = DebitNote.create((DebtAccount)debtAccount, (DocumentNumberSeries)documentNumberSeries, (DateTime)now);
        DebitEntry debitEntry = DebitEntry.create(Optional.of(debitNote), (DebtAccount)debtAccount, (TreasuryEvent)treasuryEvent, (Vat)vat, (BigDecimal)amount, (LocalDate)dueDate, (Map)target.getAcademicTreasuryTargetPropertiesMap(), (Product)product, (String)target.getAcademicTreasuryTargetDescription().getContent(TreasuryConstants.DEFAULT_LANGUAGE), (BigDecimal)BigDecimal.ONE, null, (DateTime)when.toDateTimeAtStartOfDay());
        if (createPaymentCode) {
            this.createPaymentReferenceCode(pool, debitEntry, when, dueDate);
        }
        return treasuryEvent;
    }

    private PaymentReferenceCode createPaymentReferenceCode(PaymentCodePool paymentCodePool, DebitEntry debitEntry, LocalDate when, LocalDate dueDate) {
        PaymentReferenceCodeBean referenceCodeBean = new PaymentReferenceCodeBean(paymentCodePool, debitEntry.getDebtAccount());
        referenceCodeBean.setBeginDate(when);
        referenceCodeBean.setEndDate(dueDate);
        referenceCodeBean.setSelectedDebitEntries(new ArrayList());
        referenceCodeBean.getSelectedDebitEntries().add(debitEntry);
        PaymentReferenceCode paymentReferenceCode = PaymentReferenceCode.createPaymentReferenceCodeForMultipleDebitEntries((DebtAccount)debitEntry.getDebtAccount(), (PaymentReferenceCodeBean)referenceCodeBean);
        return paymentReferenceCode;
    }

    public boolean isAcademicalActsBlocked(Person person, LocalDate when) {
        return PersonServices.isAcademicalActsBlocked(person, when);
    }

    public boolean isAcademicalActBlockingSuspended(Person person, LocalDate when) {
        return AcademicActBlockingSuspension.isBlockingSuspended(person, when);
    }

    public List<IAcademicTreasuryEvent> getAllAcademicTreasuryEventsList(Person person) {
        return AcademicTreasuryEvent.find(person).collect(Collectors.toList());
    }

    public String getPersonAccountTreasuryManagementURL(Person person) {
        return AcademicTreasurySettings.getInstance().getAcademicTreasuryAccountUrl().getPersonAccountTreasuryManagementURL(person);
    }

    public boolean isPersonAccountTreasuryManagementAvailable(Person person) {
        String addressCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        return PersonCustomer.findUnique(person, addressCountryCode, fiscalNumber).isPresent();
    }

    public String getRegistrationAccountTreasuryManagementURL(Registration registration) {
        return AcademicTreasurySettings.getInstance().getAcademicTreasuryAccountUrl().getRegistrationAccountTreasuryManagementURL(registration);
    }

    public void createAcademicDebts(Registration registration) {
        AcademicDebtGenerationRule.runAllActiveForRegistration(registration, true);
    }

    @Subscribe
    public void handle(DomainObjectEvent<SettlementNote> settlementNoteEvent) {
        SettlementNote settlementNote = (SettlementNote)settlementNoteEvent.getInstance();
        boolean toReturn = true;
        try {
            toReturn = !FenixFramework.isDomainObjectValid((DomainObject)settlementNote);
        }
        catch (Throwable t) {
            toReturn = true;
        }
        if (toReturn) {
            return;
        }
        for (SettlementEntry s : settlementNote.getSettlemetEntries().collect(Collectors.toSet())) {
            AcademicTreasuryEvent academicTreasuryEvent;
            DebitEntry d;
            InvoiceEntry invoiceEntry = s.getInvoiceEntry();
            if (!(invoiceEntry instanceof DebitEntry) || (d = (DebitEntry)invoiceEntry).getTreasuryEvent() == null || !(d.getTreasuryEvent() instanceof AcademicTreasuryEvent) || !(academicTreasuryEvent = (AcademicTreasuryEvent)d.getTreasuryEvent()).isForTreasuryEventTarget()) continue;
            ((IAcademicTreasuryTarget)academicTreasuryEvent.getTreasuryEventTarget()).handleSettlement((IAcademicTreasuryEvent)academicTreasuryEvent);
        }
    }

    public boolean isValidFiscalNumber(String fiscalAddressCountryCode, String fiscalNumber) {
        return FiscalCodeValidation.isValidFiscalNumber((String)fiscalAddressCountryCode, (String)fiscalNumber);
    }

    public boolean updateCustomer(Person person, String fiscalCountryCode, String fiscalNumber) {
        return PersonCustomer.switchCustomer(person, fiscalCountryCode, fiscalNumber);
    }

    public boolean createCustomerIfMissing(Person person) {
        String fiscalCountryCode = PersonCustomer.addressCountryCode(person);
        String fiscalNumber = PersonCustomer.fiscalNumber(person);
        if (Strings.isNullOrEmpty((String)fiscalCountryCode) || Strings.isNullOrEmpty((String)fiscalNumber)) {
            AcademicTreasuryDomainException exception = new AcademicTreasuryDomainException("error.RegistrationServices.createPersonCustomer.fiscalInformation.required", person.getName());
            logger.warn(exception.getLocalizedMessage());
            throw exception;
        }
        Optional<? extends PersonCustomer> findUnique = PersonCustomer.findUnique(person, fiscalCountryCode, fiscalNumber);
        if (findUnique.isPresent()) {
            return false;
        }
        PersonCustomer.create(person, fiscalCountryCode, fiscalNumber);
        return true;
    }

    public void saveFiscalAddressFieldsFromPersonInActiveCustomer(Person person) {
        if (person.getPersonCustomer() == null) {
            return;
        }
        person.getPersonCustomer().saveFiscalAddressFieldsFromPersonInCustomer();
    }

    public PhysicalAddress createSaftDefaultPhysicalAddress(Person person) {
        PhysicalAddressData data = new PhysicalAddressData();
        data.setAddress("Desconhecido");
        data.setCountryOfResidence(Country.readDefault());
        data.setDistrictOfResidence("Desconhecido");
        data.setDistrictSubdivisionOfResidence("Desconhecido");
        data.setAreaCode("0000-000");
        PhysicalAddress physicalAddress = PhysicalAddress.createPhysicalAddress((Party)person, (PhysicalAddressData)data, (PartyContactType)PartyContactType.PERSONAL, (Boolean)false);
        physicalAddress.setValid();
        return physicalAddress;
    }

    public ITreasuryCustomer getActiveCustomer(Person person) {
        PersonCustomer customer = PersonCustomer.findUnique(person, PersonCustomer.addressCountryCode(person), PersonCustomer.fiscalNumber(person)).orElse(null);
        if (customer == null) {
            return null;
        }
        return new TreasuryCustomer(customer);
    }

    public List<ITreasuryCustomer> getCustomersForFiscalNumber(Person person, String fiscalCountry, String fiscalNumber) {
        return PersonCustomer.find(person, fiscalCountry, fiscalNumber).map(pc -> new TreasuryCustomer((PersonCustomer)((Object)pc))).collect(Collectors.toList());
    }

    public ITreasuryDebtAccount getActiveDebtAccountForRegistration(Registration registration) {
        String fiscalNumber;
        String addressCountryCode;
        IAcademicTreasuryPlatformDependentServices academicTreasuryServices = AcademicTreasuryPlataformDependentServicesFactory.implementation();
        Person person = registration.getPerson();
        PersonCustomer customer = PersonCustomer.findUnique(person, addressCountryCode = PersonCustomer.addressCountryCode(person), fiscalNumber = PersonCustomer.fiscalNumber(person)).orElse(null);
        if (customer == null) {
            return null;
        }
        FinantialEntity finantialEntity = academicTreasuryServices.finantialEntityOfDegree(registration.getDegree(), new LocalDate());
        FinantialInstitution finantialInstitution = finantialEntity.getFinantialInstitution();
        DebtAccount debtAccount = DebtAccount.findUnique((FinantialInstitution)finantialInstitution, (Customer)customer).orElse(null);
        if (debtAccount == null) {
            return null;
        }
        return new TreasuryDebtAccount(debtAccount);
    }

    private static class TreasuryDebtAccount
    implements ITreasuryDebtAccount {
        private DebtAccount debtAccount;

        public TreasuryDebtAccount(DebtAccount debtAccount) {
            this.debtAccount = debtAccount;
        }

        @Override
        public String getExternalId() {
            return this.debtAccount.getExternalId();
        }
    }

    private static class TreasuryCustomer
    implements ITreasuryCustomer {
        private PersonCustomer personCustomer;

        public TreasuryCustomer(PersonCustomer personCustomer) {
            this.personCustomer = personCustomer;
        }

        @Override
        public String getExternalId() {
            return this.personCustomer.getExternalId();
        }

        @Override
        @Deprecated
        public String getFiscalCountry() {
            return this.personCustomer.getFiscalCountry();
        }

        @Override
        public String getFiscalNumber() {
            return this.personCustomer.getFiscalNumber();
        }

        @Override
        public String getUiFiscalNumber() {
            return this.personCustomer.getUiFiscalNumber();
        }
    }

    private static class PaymentCodePoolImpl
    implements IPaymentCodePool {
        private PaymentCodePool paymentCodePool;

        public PaymentCodePoolImpl(PaymentCodePool paymentCodePool) {
            this.paymentCodePool = paymentCodePool;
        }

        public String getCode() {
            return this.paymentCodePool.getExternalId();
        }

        public String getName() {
            return this.paymentCodePool.getName();
        }

        public boolean isActive() {
            return this.paymentCodePool.getActive() != null && this.paymentCodePool.getActive() != false;
        }

        public int hashCode() {
            return this.paymentCodePool.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof PaymentCodePoolImpl && ((PaymentCodePoolImpl)obj).paymentCodePool == this.paymentCodePool;
        }
    }

    private static class TreasuryEntity
    implements ITreasuryEntity {
        private FinantialEntity finantialEntity;

        public TreasuryEntity(FinantialEntity finantialEntity) {
            this.finantialEntity = finantialEntity;
        }

        public String getCode() {
            return this.finantialEntity.getExternalId();
        }

        public String getName() {
            return this.finantialEntity.getName().getContent();
        }

        public int hashCode() {
            return this.finantialEntity.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof TreasuryEntity && ((TreasuryEntity)obj).finantialEntity == this.finantialEntity;
        }
    }

    private static class AcademicProduct
    implements ITreasuryProduct {
        private Product product;

        private AcademicProduct(Product product) {
            this.product = product;
        }

        public String getCode() {
            return this.product.getCode();
        }

        public String getName() {
            return this.product.getName().getContent();
        }

        public int hashCode() {
            return this.product.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof AcademicProduct && ((AcademicProduct)obj).product == this.product;
        }
    }
}

