/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.domain.debtGeneration;

import java.util.stream.Stream;
import org.fenixedu.academictreasury.domain.debtGeneration.DebtGenerationRuleRestriction_Base;
import org.fenixedu.academictreasury.domain.debtGeneration.IDebtGenerationRuleRestrictionStrategy;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import pt.ist.fenixframework.FenixFramework;

public class DebtGenerationRuleRestriction
extends DebtGenerationRuleRestriction_Base {
    public DebtGenerationRuleRestriction() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected DebtGenerationRuleRestriction(String name, String strategyImplementation) {
        this();
        this.setName(name);
        this.setStrategyImplementation(strategyImplementation);
    }

    public IDebtGenerationRuleRestrictionStrategy strategyImplementation() {
        try {
            Class<?> clazz = Class.forName(this.getStrategyImplementation());
            IDebtGenerationRuleRestrictionStrategy strategy = (IDebtGenerationRuleRestrictionStrategy)clazz.newInstance();
            return strategy;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void delete() {
        if (!this.getAcademicDebtGenerationRulesSet().isEmpty()) {
            throw new AcademicTreasuryDomainException("error.DebtGenerationRuleRestriction.academicDebtGenerationRulesSet.not.empty", new String[0]);
        }
        this.setDomainRoot(null);
        this.deleteDomainObject();
    }

    public static Stream<DebtGenerationRuleRestriction> findAll() {
        return FenixFramework.getDomainRoot().getDebtGenerationRuleRestrictionsSet().stream();
    }

    public static Stream<DebtGenerationRuleRestriction> findByStrategyImplementation(String strategyImplementation) {
        return DebtGenerationRuleRestriction.findAll().filter(r -> strategyImplementation.equals(r.getStrategyImplementation()));
    }

    public static DebtGenerationRuleRestriction create(String name, String strategyImplementation) {
        return new DebtGenerationRuleRestriction(name, strategyImplementation);
    }
}

