/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.managetuitionpaymentplan;

import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.AcademicTreasuryController;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Component(value="org.fenixedu.academictreasury.ui.managetuitionpaymentplan")
@SpringFunctionality(app=AcademicTreasuryController.class, title="label.title.manageTuitionPaymentPlan", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/academictreasury/managetuitionpaymentplan/finantialentity"})
public class FinantialEntityController
extends AcademicTreasuryBaseController {
    public static final String CONTROLLER_URL = "/academictreasury/managetuitionpaymentplan/finantialentity";
    private static final String JSP_PATH = "academicTreasury/managetuitionpaymentplan/finantialentity";
    private static final String _CHOOSEFINANTIALENTITY_URI = "/choosefinantialentity";
    public static final String CHOOSEFINANTIALENTITY_URL = "/academictreasury/managetuitionpaymentplan/finantialentity/choosefinantialentity";
    private static final String _CHOOSEFINANTIALENTITY_TO_CHOOSE_ACTION_URI = "/chooseFinantialEntity/choose/";
    public static final String CHOOSEFINANTIALENTITY_TO_CHOOSE_ACTION_URL = "/academictreasury/managetuitionpaymentplan/finantialentity/chooseFinantialEntity/choose/";

    @RequestMapping
    public String home(Model model) {
        return "forward:/academictreasury/managetuitionpaymentplan/finantialentity/choosefinantialentity";
    }

    @RequestMapping(value={"/choosefinantialentity"})
    public String chooseFinantialEntity(Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        model.addAttribute("choosefinantialentityResultsDataSet", FinantialEntity.findWithBackOfficeAccessFor((String)loggedUsername).sorted(FinantialEntity.COMPARE_BY_NAME).collect(Collectors.toList()));
        return this.jspPage("choosefinantialentity");
    }

    @RequestMapping(value={"/chooseFinantialEntity/choose/{finantialEntityId}"})
    public String processChooseFinantialEntityToChooseAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, Model model, RedirectAttributes redirectAttributes) {
        ExecutionYear executionYear = ExecutionYear.readCurrentExecutionYear();
        return this.redirect("/academictreasury/managetuitionpaymentplan/degreecurricularplan/choosedegreecurricularplan" + String.format("/%s/%s", finantialEntity.getExternalId(), executionYear.getExternalId()), model, redirectAttributes);
    }

    private String jspPage(String page) {
        return "academicTreasury/managetuitionpaymentplan/finantialentity/" + page;
    }
}

