/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academictreasury.ui.manageemoluments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academictreasury.domain.exceptions.AcademicTreasuryDomainException;
import org.fenixedu.academictreasury.domain.tariff.AcademicTariff;
import org.fenixedu.academictreasury.dto.tariff.AcademicTariffBean;
import org.fenixedu.academictreasury.ui.AcademicTreasuryBaseController;
import org.fenixedu.academictreasury.ui.manageemoluments.FinantialEntityController;
import org.fenixedu.academictreasury.util.AcademicTreasuryConstants;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@BennuSpringController(value=FinantialEntityController.class)
@RequestMapping(value={"/academictreasury/manageemoluments/academictariff"})
public class AcademicTariffController
extends AcademicTreasuryBaseController {
    @RequestMapping(value={"/viewemolumenttariffs/{finantialEntityId}/{productId}"})
    public String viewEmolumentTariffs(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("product", (Object)product);
        model.addAttribute("viewemolumenttariffsResultsDataSet", this.filterViewEmolumentTariffs(finantialEntity, product));
        return "academicTreasury/manageemoluments/academictariff/viewemolumenttariffs";
    }

    private List<AcademicTariff> getSearchUniverseViewEmolumentTariffsDataSet(FinantialEntity finantialEntity, Product product) {
        return new ArrayList<AcademicTariff>(AcademicTariff.find(finantialEntity, product).collect(Collectors.toSet()));
    }

    private List<AcademicTariff> filterViewEmolumentTariffs(FinantialEntity finantialEntity, Product product) {
        return this.getSearchUniverseViewEmolumentTariffsDataSet(finantialEntity, product).stream().collect(Collectors.toList());
    }

    @RequestMapping(value={"/viewEmolumentTariffs/view/{oid}"})
    public String processViewEmolumentTariffsToViewAction(@PathVariable(value="oid") AcademicTariff academicTariff, Model model) {
        return String.format("redirect:/academictreasury/manageemoluments/academictariff/viewemolumenttariff/%s", academicTariff.getExternalId());
    }

    @RequestMapping(value={"/viewEmolumentTariffs/delete/{finantialEntityId}/{productId}/{academicTariffId}"}, method={RequestMethod.POST})
    public String processViewEmolumentTariffsToDeleteAction(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, @PathVariable(value="academicTariffId") AcademicTariff academicTariff, Model model) {
        try {
            academicTariff.delete();
            this.addInfoMessage(AcademicTreasuryConstants.academicTreasuryBundle("label.AcademicTariff.delete.success", new String[0]), model);
        }
        catch (DomainException ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return String.format("redirect:/academictreasury/manageemoluments/academictariff/viewemolumenttariffs/%s/%s", finantialEntity.getExternalId(), product.getExternalId());
    }

    @RequestMapping(value={"/createemolumenttariff/{finantialEntityId}/{productId}"}, method={RequestMethod.GET})
    public String createemolumenttariff(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, Model model) {
        return this._createemolumenttariff(finantialEntity, product, new AcademicTariffBean(), model);
    }

    @RequestMapping(value={"/createemolumenttariffpostback/{finantialEntityId}/{productId}"}, method={RequestMethod.POST})
    public String createemolumenttariffpostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, @RequestParam(value="academicTariffBean", required=true) AcademicTariffBean academicTariffBean, Model model) {
        return this._createemolumenttariff(finantialEntity, product, academicTariffBean, model);
    }

    protected String _createemolumenttariff(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, @RequestParam(value="academicTariffBean", required=true) AcademicTariffBean academicTariffBean, Model model) {
        academicTariffBean.resetFields();
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("product", (Object)product);
        model.addAttribute("academicTariffBean", (Object)academicTariffBean);
        model.addAttribute("academicTariffBeanJson", (Object)this.getBeanJson(academicTariffBean));
        model.addAttribute("AcademicTariff_administrativeOffice_options", Bennu.getInstance().getAdministrativeOfficesSet().stream().sorted(new Comparator<AdministrativeOffice>(){

            @Override
            public int compare(AdministrativeOffice o1, AdministrativeOffice o2) {
                int c = o1.getName().getContent().compareTo(o2.getName().getContent());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        }).collect(Collectors.toList()));
        model.addAttribute("AcademicTariff_degreeType_options", DegreeType.all().sorted(new Comparator<DegreeType>(){

            @Override
            public int compare(DegreeType o1, DegreeType o2) {
                int c = o1.getName().getContent().compareTo(o2.getName().getContent());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        }).collect(Collectors.toList()));
        model.addAttribute("AcademicTariff_degree_options", Degree.readAllMatching(Predicate.isEqual(academicTariffBean.getDegreeType())).stream().sorted(Degree.COMPARATOR_BY_NAME).collect(Collectors.toList()));
        model.addAttribute("AcademicTariff_cycleType_options", academicTariffBean.getDegree() != null ? academicTariffBean.getDegreeType().getCycleTypes() : Collections.emptyList());
        model.addAttribute("AcademicTariff_dueDateCalculationType_options", Arrays.asList(DueDateCalculationType.values()));
        model.addAttribute("AcademicTariff_interestType_options", (Object)InterestType.findAll());
        return "academicTreasury/manageemoluments/academictariff/createemolumenttariff";
    }

    @RequestMapping(value={"/createemolumenttariff/{finantialEntityId}/{productId}"}, method={RequestMethod.POST})
    public String createemolumenttariff(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, @RequestParam(value="academicTariffBean", required=false) AcademicTariffBean bean, Model model) {
        try {
            bean.resetFields();
            if (bean.getAdministrativeOffice() == null) {
                throw new AcademicTreasuryDomainException("error.AcademicTariff.administrativeOffice.required", new String[0]);
            }
            AcademicTariff academicTariff = AcademicTariff.create(finantialEntity, product, bean);
            return String.format("redirect:/academictreasury/manageemoluments/academictariff/viewemolumenttariffs/%s/%s", finantialEntity.getExternalId(), product.getExternalId(), academicTariff.getExternalId());
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this._createemolumenttariff(finantialEntity, product, bean, model);
        }
    }

    @RequestMapping(value={"/updateemolumenttariff/{finantialEntityId}/{productId}/{academicTariffId}"}, method={RequestMethod.GET})
    public String updateemolumenttariff(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, @PathVariable(value="academicTariffId") AcademicTariff academicTariff, Model model) {
        return this._updateemolumenttariff(finantialEntity, product, academicTariff, new AcademicTariffBean(academicTariff), model);
    }

    public String _updateemolumenttariff(FinantialEntity finantialEntity, Product product, AcademicTariff academicTariff, AcademicTariffBean bean, Model model) {
        model.addAttribute("finantialEntity", (Object)finantialEntity);
        model.addAttribute("product", (Object)product);
        model.addAttribute("academicTariff", (Object)academicTariff);
        model.addAttribute("academicTariffBean", (Object)bean);
        model.addAttribute("academicTariffBeanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("AcademicTariff_interestType_options", (Object)InterestType.findAll());
        return "academicTreasury/manageemoluments/academictariff/updateemolumenttariff";
    }

    @RequestMapping(value={"/updateemolumenttariffpostback/{finantialEntityId}/{productId}/{academicTariffId}"}, method={RequestMethod.POST})
    public String updateemolumenttariffpostback(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, @PathVariable(value="academicTariffId") AcademicTariff academicTariff, @RequestParam(value="academicTariffBean", required=false) AcademicTariffBean bean, Model model) {
        return this._updateemolumenttariff(finantialEntity, product, academicTariff, bean, model);
    }

    @RequestMapping(value={"/updateemolumenttariff/{finantialEntityId}/{productId}/{academicTariffId}"}, method={RequestMethod.POST})
    public String updateemolumenttariff(@PathVariable(value="finantialEntityId") FinantialEntity finantialEntity, @PathVariable(value="productId") Product product, @PathVariable(value="academicTariffId") AcademicTariff academicTariff, @RequestParam(value="academicTariffBean", required=false) AcademicTariffBean academicTariffBean, Model model) {
        try {
            academicTariff.edit(academicTariffBean);
            return String.format("redirect:/academictreasury/manageemoluments/academictariff/viewemolumenttariffs/%s/%s", finantialEntity.getExternalId(), product.getExternalId(), academicTariff.getExternalId());
        }
        catch (DomainException de) {
            this.addErrorMessage(de.getLocalizedMessage(), model);
            return this._updateemolumenttariff(finantialEntity, product, academicTariff, academicTariffBean, model);
        }
    }
}

